/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.lcov;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.coverage.NewCoverage;
import org.sonar.plugins.javascript.lcov.FileLocator;
import org.sonar.plugins.javascript.lcov.LCOVParser;
import org.sonarsource.analyzer.commons.FileProvider;

public class CoverageSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(CoverageSensor.class);

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguages(new String[]{"js", "ts"}).onlyWhenConfiguration(conf -> conf.hasKey("sonar.javascript.lcov.reportPaths") || conf.hasKey("sonar.typescript.lcov.reportPaths")).name("JavaScript/TypeScript Coverage").onlyOnFileType(InputFile.Type.MAIN);
    }

    public void execute(SensorContext context) {
        List<File> lcovFiles;
        HashSet<String> reports = new HashSet<String>(Arrays.asList(context.config().getStringArray("sonar.javascript.lcov.reportPaths")));
        reports.addAll(Arrays.asList(context.config().getStringArray("sonar.typescript.lcov.reportPaths")));
        CoverageSensor.logIfUsedProperty(context, "sonar.javascript.lcov.reportPaths");
        CoverageSensor.logIfUsedProperty(context, "sonar.typescript.lcov.reportPaths");
        if (context.config().hasKey("sonar.javascript.lcov.reportPaths") && context.config().hasKey("sonar.typescript.lcov.reportPaths")) {
            LOG.info("Merging coverage reports from {} and {}.", (Object)"sonar.javascript.lcov.reportPaths", (Object)"sonar.typescript.lcov.reportPaths");
        }
        if ((lcovFiles = CoverageSensor.getLcovFiles(context.fileSystem().baseDir(), reports)).isEmpty()) {
            LOG.warn("No coverage information will be saved because all LCOV files cannot be found.");
            return;
        }
        CoverageSensor.saveCoverageFromLcovFiles(context, lcovFiles);
    }

    private static List<File> getLcovFiles(File baseDir, Set<String> reportPaths) {
        ArrayList<File> lcovFiles = new ArrayList<File>();
        for (String reportPath : reportPaths) {
            LOG.debug("Using '{}' to resolve LCOV files", (Object)reportPath);
            File fileByHardcodedPath = CoverageSensor.getFileByHardcodedPath(baseDir, reportPath);
            if (fileByHardcodedPath != null) {
                lcovFiles.add(fileByHardcodedPath);
                continue;
            }
            FileProvider fileProvider = new FileProvider(baseDir, reportPath);
            List<File> matchingFiles = fileProvider.getMatchingFiles();
            if (matchingFiles.isEmpty()) {
                LOG.info("No LCOV files were found using {}", (Object)reportPath);
            }
            lcovFiles.addAll(matchingFiles);
        }
        return lcovFiles;
    }

    private static void saveCoverageFromLcovFiles(SensorContext context, List<File> lcovFiles) {
        int inconsistenciesNumber;
        LOG.info("Analysing {}", (Object)lcovFiles);
        FileSystem fileSystem = context.fileSystem();
        FilePredicate mainFilePredicate = fileSystem.predicates().and(fileSystem.predicates().hasType(InputFile.Type.MAIN), fileSystem.predicates().hasLanguages(new String[]{"js", "ts"}));
        FileLocator fileLocator = new FileLocator(fileSystem.inputFiles(mainFilePredicate));
        LCOVParser parser = LCOVParser.create(context, lcovFiles, fileLocator);
        Map<InputFile, NewCoverage> coveredFiles = parser.coverageByFile();
        for (InputFile inputFile : fileSystem.inputFiles(mainFilePredicate)) {
            NewCoverage fileCoverage = coveredFiles.get(inputFile);
            if (fileCoverage == null) continue;
            fileCoverage.save();
        }
        List<String> unresolvedPaths = parser.unresolvedPaths();
        if (!unresolvedPaths.isEmpty()) {
            LOG.warn("Could not resolve {} file paths in {}", (Object)unresolvedPaths.size(), (Object)lcovFiles);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unresolved paths:\n{}", (Object)String.join((CharSequence)"\n", unresolvedPaths));
            } else {
                LOG.warn("First unresolved path: {} (Run in DEBUG mode to get full list of unresolved paths)", (Object)unresolvedPaths.get(0));
            }
        }
        if ((inconsistenciesNumber = parser.inconsistenciesNumber()) > 0) {
            LOG.warn("Found {} inconsistencies in coverage report. Re-run analyse in debug mode to see details.", (Object)inconsistenciesNumber);
        }
    }

    private static File getFileByHardcodedPath(File baseDir, String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(baseDir, path);
        }
        if (!file.isFile()) {
            return null;
        }
        return file;
    }

    private static void logIfUsedProperty(SensorContext context, String property) {
        if (context.config().hasKey(property)) {
            LOG.debug(String.format("Property %s is used.", property));
        }
    }
}

