/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.external;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.rules.RuleType;
import org.sonar.plugins.javascript.external.AbstractExternalIssuesSensor;
import org.sonar.plugins.javascript.rules.TslintRulesDefinition;

public class TslintReportSensor
extends AbstractExternalIssuesSensor {
    private static final Logger LOG = LoggerFactory.getLogger(TslintReportSensor.class);

    @Override
    String linterName() {
        return "TSLint";
    }

    @Override
    String reportsPropertyName() {
        return "sonar.typescript.tslint.reportPaths";
    }

    @Override
    void importReport(File report, SensorContext context) {
        LOG.info("Importing {}", (Object)report.getAbsoluteFile());
        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(report), StandardCharsets.UTF_8);){
            TslintError[] tslintErrors;
            for (TslintError tslintError : tslintErrors = gson.fromJson((Reader)inputStreamReader, TslintError[].class)) {
                this.saveTslintError(context, tslintError);
            }
        }
        catch (IOException e) {
            LOG.error("No issues information will be saved as the report file can't be read.", e);
        }
    }

    private void saveTslintError(SensorContext context, TslintError tslintError) {
        String tslintKey = tslintError.ruleName;
        InputFile inputFile = this.getInputFile(context, tslintError.name);
        if (inputFile == null) {
            return;
        }
        TextRange location = TslintReportSensor.getLocation(tslintError, inputFile);
        TextPointer start = location.start();
        RuleType ruleType = TslintRulesDefinition.ruleType(tslintKey);
        LOG.debug("Saving external TSLint issue { file:\"{}\", id:{}, message:\"{}\", line:{}, offset:{}, type: {} }", tslintError.name, tslintKey, tslintError.failure, start.line(), start.lineOffset(), ruleType);
        NewExternalIssue newExternalIssue = context.newExternalIssue();
        NewIssueLocation primaryLocation = newExternalIssue.newLocation().message(tslintError.failure).on((InputComponent)inputFile).at(location);
        newExternalIssue.at(primaryLocation).engineId("tslint_repo").ruleId(tslintKey).type(ruleType).severity(DEFAULT_SEVERITY).remediationEffortMinutes(Long.valueOf(5L)).save();
    }

    private static TextRange getLocation(TslintError tslintError, InputFile inputFile) {
        if (tslintError.startPosition.equals(tslintError.endPosition)) {
            return inputFile.selectLine(tslintError.startPosition.getOneBasedLine());
        }
        return inputFile.newRange(tslintError.startPosition.getOneBasedLine(), tslintError.startPosition.character, tslintError.endPosition.getOneBasedLine(), tslintError.endPosition.character);
    }

    private static class TslintError {
        TslintPosition startPosition;
        TslintPosition endPosition;
        String failure;
        String name;
        String ruleName;

        private TslintError() {
        }
    }

    private static class TslintPosition {
        int character;
        int line;

        private TslintPosition() {
        }

        private int getOneBasedLine() {
            return this.line + 1;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TslintPosition other = (TslintPosition)obj;
            return this.line == other.line && this.character == other.character;
        }

        public int hashCode() {
            return Objects.hash(this.line, this.character);
        }
    }
}

