/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.external;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.plugins.javascript.bridge.BridgeServer;
import org.sonar.plugins.javascript.external.ExternalIssue;

public class ExternalIssueRepository {
    private ExternalIssueRepository() {
    }

    public static void save(ExternalIssue issue, SensorContext context) {
        InputFile file = issue.file();
        NewExternalIssue newIssue = context.newExternalIssue();
        NewIssueLocation newLocation = newIssue.newLocation();
        newLocation.on((InputComponent)file);
        if (issue.message() != null) {
            newLocation.message(issue.message());
        }
        newLocation.at(file.newRange(issue.location().start().line(), issue.location().start().lineOffset(), issue.location().end().line(), issue.location().end().lineOffset()));
        newIssue.severity(issue.severity()).remediationEffortMinutes(issue.effort()).at(newLocation).engineId(issue.engineId()).ruleId(issue.name()).type(issue.type()).save();
    }

    public static void dedupeAndSaveESLintIssues(SensorContext context, Map<String, List<ExternalIssue>> externalIssuesMap, List<BridgeServer.Issue> issues) {
        List<ExternalIssue> externalIssues = externalIssuesMap.values().stream().flatMap(Collection::stream).toList();
        if (!externalIssues.isEmpty()) {
            List<ExternalIssue> deduplicatedExternalIssues = ExternalIssueRepository.deduplicateIssues(externalIssues, issues);
            ExternalIssueRepository.saveESLintIssues(context, deduplicatedExternalIssues);
        }
    }

    public static void saveESLintIssues(SensorContext context, List<ExternalIssue> externalIssues) {
        for (ExternalIssue externalIssue : externalIssues) {
            ExternalIssueRepository.save(externalIssue, context);
        }
    }

    public static List<ExternalIssue> deduplicateIssues(@Nullable List<ExternalIssue> externalIssues, List<BridgeServer.Issue> issues) {
        if (externalIssues == null) {
            return List.of();
        }
        ArrayList<ExternalIssue> deduplicatedIssues = new ArrayList<ExternalIssue>();
        HashSet<String> normalizedIssues = new HashSet<String>();
        for (BridgeServer.Issue issue : issues) {
            for (String ruleKey : issue.ruleESLintKeys()) {
                String issueKey = String.format("%s-%s-%d-%d-%d-%d", ruleKey, issue.filePath().replaceAll(Pattern.quote(File.separator), "/"), issue.line(), issue.column(), issue.endLine(), issue.endColumn());
                normalizedIssues.add(issueKey);
            }
        }
        for (ExternalIssue externalIssue : externalIssues) {
            String issueKey = String.format("%s-%s-%d-%d-%d-%d", externalIssue.name(), externalIssue.file().absolutePath().replaceAll(Pattern.quote(File.separator), "/"), externalIssue.location().start().line(), externalIssue.location().start().lineOffset(), externalIssue.location().end().line(), externalIssue.location().end().lineOffset());
            if (normalizedIssues.contains(issueKey)) continue;
            deduplicatedIssues.add(externalIssue);
        }
        return deduplicatedIssues;
    }
}

