/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.external;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.rules.RuleType;
import org.sonar.plugins.javascript.analysis.JsTsContext;
import org.sonar.plugins.javascript.external.ExternalIssue;
import org.sonar.plugins.javascript.rules.EslintRulesDefinition;
import org.sonarsource.analyzer.commons.ExternalReportProvider;
import org.sonarsource.analyzer.commons.ExternalRuleLoader;

public class EslintReportImporter {
    private static final Logger LOG = LoggerFactory.getLogger(EslintReportImporter.class);

    String linterName() {
        return "ESLint";
    }

    String reportsPropertyName() {
        return "sonar.eslint.reportPaths";
    }

    InputFile getInputFile(JsTsContext<?> context, String fileName) {
        FilePredicates predicates;
        FileSystem fileSystem = context.getSensorContext().fileSystem();
        InputFile inputFile = fileSystem.inputFile((predicates = fileSystem.predicates()).hasPath(fileName));
        if (inputFile == null) {
            LOG.warn("No input file found for {}. No {} issues will be imported on this file.", (Object)fileName, (Object)this.linterName());
            return null;
        }
        return inputFile;
    }

    public Map<String, List<ExternalIssue>> execute(JsTsContext<?> context) {
        HashMap<String, List<ExternalIssue>> results = new HashMap<String, List<ExternalIssue>>();
        List<File> reportFiles = ExternalReportProvider.getReportFiles(context.getSensorContext(), this.reportsPropertyName());
        reportFiles.forEach(report -> results.putAll(this.importReportByFilePath((File)report, context)));
        return results;
    }

    Map<String, List<ExternalIssue>> importReportByFilePath(File report, JsTsContext<?> context) {
        LOG.info("Importing external issues from: {}", (Object)report.getAbsoluteFile());
        HashMap<String, List<ExternalIssue>> results = new HashMap<String, List<ExternalIssue>>();
        Gson serializer = new Gson();
        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(report), StandardCharsets.UTF_8);){
            FileWithMessages[] filesWithMessages;
            for (FileWithMessages fileWithMessages : filesWithMessages = serializer.fromJson((Reader)inputStreamReader, FileWithMessages[].class)) {
                InputFile inputFile = this.getInputFile(context, fileWithMessages.filePath);
                if (inputFile == null) continue;
                ArrayList<ExternalIssue> externalIssuesForFile = new ArrayList<ExternalIssue>();
                for (EslintError eslintError : fileWithMessages.messages) {
                    if (eslintError.ruleId == null) {
                        LOG.warn("Parse error issue from ESLint will not be imported, file {}", (Object)inputFile.uri());
                        continue;
                    }
                    externalIssuesForFile.add(EslintReportImporter.createIssue(eslintError, inputFile));
                }
                if (externalIssuesForFile.isEmpty()) continue;
                results.put(inputFile.absolutePath(), externalIssuesForFile);
            }
        }
        catch (JsonSyntaxException | IOException e) {
            LOG.warn("No issues information will be saved as the report file can't be read.", e);
        }
        return results;
    }

    private static ExternalIssue createIssue(EslintError eslintError, InputFile inputFile) {
        String eslintKey = eslintError.ruleId;
        TextRange location = EslintReportImporter.getLocation(eslintError, inputFile);
        ExternalRuleLoader ruleLoader = EslintRulesDefinition.loader(eslintKey);
        RuleType ruleType = ruleLoader.ruleType(eslintKey);
        Severity severity = ruleLoader.ruleSeverity(eslintKey);
        Long effortInMinutes = ruleLoader.ruleConstantDebtMinutes(eslintKey);
        return new ExternalIssue(eslintKey, inputFile, location, ruleType, eslintError.message, severity, effortInMinutes, "eslint_repo");
    }

    private static TextRange getLocation(EslintError eslintError, InputFile inputFile) {
        if (eslintError.endLine == 0 || eslintError.isZeroLengthRange()) {
            return inputFile.selectLine(eslintError.line);
        }
        return inputFile.newRange(eslintError.line, eslintError.column - 1, eslintError.endLine, eslintError.endColumn - 1);
    }

    private static class FileWithMessages {
        String filePath;
        EslintError[] messages;

        private FileWithMessages() {
        }
    }

    private static class EslintError {
        String ruleId;
        String message;
        int line;
        int column;
        int endLine;
        int endColumn;

        private EslintError() {
        }

        boolean isZeroLengthRange() {
            return this.line == this.endLine && this.column == this.endColumn;
        }
    }
}

