/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.external;

import com.google.gson.Gson;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonarsource.analyzer.commons.ExternalReportProvider;

abstract class AbstractExternalIssuesSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractExternalIssuesSensor.class);
    static final Gson gson = new Gson();
    static final long DEFAULT_REMEDIATION_COST = 5L;
    static final Severity DEFAULT_SEVERITY = Severity.MAJOR;
    static final String FILE_EXCEPTION_MESSAGE = "No issues information will be saved as the report file can't be read.";

    AbstractExternalIssuesSensor() {
    }

    public void describe(SensorDescriptor sensorDescriptor) {
        sensorDescriptor.onlyWhenConfiguration(conf -> conf.hasKey(this.reportsPropertyName())).name("Import of " + this.linterName() + " issues");
    }

    public void execute(SensorContext context) {
        List<File> reportFiles = ExternalReportProvider.getReportFiles(context, this.reportsPropertyName());
        reportFiles.forEach(report -> this.importReport((File)report, context));
    }

    InputFile getInputFile(SensorContext context, String fileName) {
        FilePredicates predicates = context.fileSystem().predicates();
        InputFile inputFile = context.fileSystem().inputFile(predicates.hasPath(fileName));
        if (inputFile == null) {
            LOG.warn("No input file found for {}. No {} issues will be imported on this file.", (Object)fileName, (Object)this.linterName());
            return null;
        }
        return inputFile;
    }

    abstract String linterName();

    abstract String reportsPropertyName();

    abstract void importReport(File var1, SensorContext var2);
}

