/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.bridge;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.plugins.javascript.api.RulesBundle;
import org.sonar.plugins.javascript.bridge.BundleUtils;
import org.sonarsource.api.sonarlint.SonarLintSide;

@ScannerSide
@SonarLintSide(lifespan="INSTANCE")
public class RulesBundles {
    private static final Logger LOG = LoggerFactory.getLogger(RulesBundles.class);
    private final List<URL> bundleUrls;
    private final List<RulesBundle> bundles;

    public RulesBundles() {
        this.bundles = Collections.emptyList();
        this.bundleUrls = Collections.emptyList();
    }

    public RulesBundles(RulesBundle[] rulesBundles) {
        this.bundles = List.of(rulesBundles);
        this.bundleUrls = Arrays.stream(rulesBundles).map(bundle -> {
            URL resource = bundle.getClass().getResource(bundle.bundlePath());
            if (resource == null) {
                throw new IllegalStateException(String.format("Resource for bundle %s from %s not found.", bundle.bundlePath(), bundle));
            }
            return resource;
        }).toList();
    }

    public List<Path> deploy(Path target) {
        ArrayList<Path> unpackedBundles = new ArrayList<Path>();
        this.bundleUrls.forEach(bundle -> {
            try {
                Path location = Files.createTempDirectory(target, "custom-rules", new FileAttribute[0]);
                LOG.debug("Deploying custom rules bundle {} to {}", bundle, (Object)location);
                BundleUtils.extractFromClasspath(bundle.openStream(), location);
                Path deployedBundle = location.resolve("package").toAbsolutePath();
                if (!Files.exists(deployedBundle, new LinkOption[0])) {
                    throw new IllegalStateException("Failed to deploy bundle " + String.valueOf(bundle) + ". Didn't find 'package' dir.");
                }
                unpackedBundles.add(Paths.get(deployedBundle.toString(), "dist", "rules.js"));
            }
            catch (IOException e) {
                LOG.error("Failed to extract bundle " + String.valueOf(bundle), e);
            }
        });
        return unpackedBundles;
    }
}

