/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.bridge;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.utils.Version;
import org.sonar.plugins.javascript.bridge.AnalysisWarningsWrapper;
import org.sonarsource.api.sonarlint.SonarLintSide;

@ScannerSide
@SonarLintSide(lifespan="INSTANCE")
public class NodeDeprecationWarning {
    private static final Logger LOG = LoggerFactory.getLogger(NodeDeprecationWarning.class);
    private static final String NODE_PROPERTIES_FILE = "/node-info.properties";
    static final Version MIN_SUPPORTED_NODE_VERSION;
    private static final List<String> RECOMMENDED_NODE_VERSIONS;
    public static final Version RECOMMENDED_NODE_VERSION;
    private final AnalysisWarningsWrapper analysisWarnings;

    public NodeDeprecationWarning(AnalysisWarningsWrapper analysisWarnings) {
        this.analysisWarnings = analysisWarnings;
    }

    static Properties loadProperties(String resourceName) {
        Properties properties;
        block8: {
            InputStream inputStream = NodeDeprecationWarning.class.getResourceAsStream(resourceName);
            try {
                properties = NodeDeprecationWarning.loadProperties(inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new ExceptionInInitializerError("Failed to load /node-info.properties: " + String.valueOf(ex));
                }
            }
            inputStream.close();
        }
        return properties;
    }

    static Properties loadProperties(@Nullable InputStream inputStream) throws IOException {
        Properties props = new Properties();
        if (inputStream != null) {
            props.load(inputStream);
            return props;
        }
        throw new IOException("Provided InputStream is null");
    }

    void logNodeDeprecation(Version actualNodeVersion) {
        if (!actualNodeVersion.isGreaterThanOrEqual(RECOMMENDED_NODE_VERSION)) {
            String msg = String.format("Using Node.js version %s to execute analysis is not recommended. Please upgrade to a newer LTS version of Node.js: %s.", actualNodeVersion, RECOMMENDED_NODE_VERSION);
            LOG.warn(msg);
            this.analysisWarnings.addUnique(msg);
        }
    }

    static {
        Properties props = NodeDeprecationWarning.loadProperties(NODE_PROPERTIES_FILE);
        MIN_SUPPORTED_NODE_VERSION = Version.parse((String)props.getProperty("node.version.min"));
        RECOMMENDED_NODE_VERSIONS = Arrays.asList(props.getProperty("node.recommended.versions").split(","));
        RECOMMENDED_NODE_VERSION = Version.parse((String)RECOMMENDED_NODE_VERSIONS.get(RECOMMENDED_NODE_VERSIONS.size() - 1));
    }
}

