/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.bridge;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.plugins.javascript.bridge.WebSocketMessageHandler;

public class JSWebSocketClient
extends WebSocketClient {
    private static final Logger LOG = LoggerFactory.getLogger(JSWebSocketClient.class);
    private static final Gson GSON = new Gson();
    private final List<WebSocketMessageHandler<?>> messageHandlers = new CopyOnWriteArrayList();

    public JSWebSocketClient(URI serverUri) {
        super(serverUri);
        this.setConnectionLostTimeout(0);
    }

    public void registerHandler(WebSocketMessageHandler<?> handler) {
        this.messageHandlers.add(handler);
        handler.getFuture().whenComplete((result, exception) -> {
            this.messageHandlers.remove(handler);
            if (exception != null) {
                LOG.error("Error in handler execution", (Throwable)exception);
            }
        });
    }

    public List<WebSocketMessageHandler<?>> getMessageHandlers() {
        return this.messageHandlers;
    }

    @Override
    public void onOpen(ServerHandshake handshakeData) {
        LOG.debug("WebSocket connection opened: {}", (Object)this.uri);
    }

    @Override
    public void onMessage(String message) {
        LOG.trace("Received WebSocket message: {}", (Object)message);
        JsonObject jsonObject = JsonParser.parseString(message).getAsJsonObject();
        if ("error".equals(jsonObject.get("messageType").getAsString())) {
            this.handleError(jsonObject.get("error").getAsJsonObject().toString());
            return;
        }
        for (WebSocketMessageHandler<?> handler : this.messageHandlers) {
            handler.handleMessage(jsonObject);
            if (!handler.getContext().isCancelled()) continue;
            this.send(GSON.toJson(Map.of("type", "on-cancel-analysis")));
        }
    }

    private void handleError(String message) {
        String errorMessage = String.format("Received error from bridge: %s", message);
        for (WebSocketMessageHandler<?> handler : this.messageHandlers) {
            handler.getFuture().completeExceptionally(new RuntimeException(errorMessage));
        }
    }

    @Override
    public void onClose(int code, String reason, boolean remote) {
        LOG.debug("WebSocket connection closed: {} (code: {})", (Object)reason, (Object)code);
        for (WebSocketMessageHandler<?> handler : this.messageHandlers) {
            handler.onClose(code, reason, remote);
        }
    }

    @Override
    public void onError(Exception e) {
        LOG.error("WebSocket error occurred", e);
        for (WebSocketMessageHandler<?> handler : this.messageHandlers) {
            handler.onError(e);
        }
    }
}

