/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.bridge;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Http {
    public static Http getJdkHttpClient() {
        return new JdkHttp();
    }

    public Response post(String var1, URI var2, long var3) throws IOException;

    public String get(URI var1) throws IOException;

    public static class JdkHttp
    implements Http {
        private static final Logger LOG = LoggerFactory.getLogger(JdkHttp.class);
        private final HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).build();

        JdkHttp() {
        }

        @Override
        public Response post(String json, URI uri, long timeoutSeconds) throws IOException {
            HttpRequest request = HttpRequest.newBuilder().version(HttpClient.Version.HTTP_1_1).uri(uri).timeout(Duration.ofSeconds(timeoutSeconds)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(json)).build();
            try {
                HttpResponse<byte[]> response = this.client.send(request, HttpResponse.BodyHandlers.ofByteArray());
                String contentType = response.headers().firstValue("Content-Type").orElse(null);
                return new Response(contentType, response.body());
            }
            catch (InterruptedException e) {
                throw JdkHttp.handleInterruptedException(e, "Request " + String.valueOf(uri) + " was interrupted.");
            }
        }

        @Override
        public String get(URI uri) throws IOException {
            HttpRequest request = HttpRequest.newBuilder(uri).version(HttpClient.Version.HTTP_1_1).GET().build();
            try {
                HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
                return response.body();
            }
            catch (InterruptedException e) {
                throw JdkHttp.handleInterruptedException(e, "isAlive was interrupted");
            }
        }

        private static IllegalStateException handleInterruptedException(InterruptedException e, String msg) {
            LOG.error(msg, e);
            Thread.currentThread().interrupt();
            return new IllegalStateException(msg, e);
        }
    }

    public record Response(@Nullable String contentType, byte[] body) {
    }
}

