/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.bridge;

import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.plugins.javascript.api.AnalysisMode;

public class EslintRule {
    final String key;
    final List<String> fileTypeTargets;
    final List<Object> configurations;
    final List<AnalysisMode> analysisModes;
    final List<String> blacklistedExtensions;
    final String language;

    public EslintRule(String key, List<Object> configurations, List<InputFile.Type> fileTypeTargets, List<AnalysisMode> analysisModes, List<String> blacklistedExtensions, String language) {
        this.key = key;
        this.fileTypeTargets = fileTypeTargets.stream().map(Enum::name).toList();
        this.configurations = configurations;
        this.analysisModes = analysisModes;
        this.blacklistedExtensions = blacklistedExtensions;
        if (!"js".equals(language) && !"ts".equals(language)) {
            throw new IllegalArgumentException("Invalid language " + language);
        }
        this.language = language;
    }

    public String toString() {
        return this.key;
    }

    public String getKey() {
        return this.key;
    }

    public List<Object> getConfigurations() {
        return this.configurations;
    }

    public List<AnalysisMode> getAnalysisModes() {
        return this.analysisModes;
    }

    static EslintRule findFirstRuleWithKey(List<EslintRule> rules, String eslintKey) {
        return rules.stream().filter(EslintRule.ruleMatcher(eslintKey)).findFirst().orElse(null);
    }

    public static List<EslintRule> findAllBut(List<EslintRule> rules, Set<String> blackListRuleKeys) {
        return rules.stream().filter(rule -> !blackListRuleKeys.contains(rule.key)).toList();
    }

    private static Predicate<EslintRule> ruleMatcher(String eslintKey) {
        return rule -> rule.key.equals(eslintKey);
    }
}

