/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.bridge;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.stream.Stream;
import org.sonar.api.config.Configuration;
import org.sonar.api.scanner.ScannerSide;
import org.sonarsource.api.sonarlint.SonarLintSide;

@ScannerSide
@SonarLintSide(lifespan="INSTANCE")
public class Environment {
    private final Configuration configuration;

    public Environment(Configuration configuration) {
        this.configuration = configuration;
    }

    public Path getSonarUserHome() {
        return Stream.of(this.configuration.get("sonar.userHome").orElse(null), System.getenv("SONAR_USER_HOME"), Environment.defaultSonarUserHome()).filter(Objects::nonNull).findFirst().map(x$0 -> Path.of(x$0, new String[0])).get();
    }

    public static String defaultSonarUserHome() {
        return System.getProperty("user.home") + File.separator + ".sonar";
    }

    public String getOsName() {
        return System.getProperty("os.name");
    }

    public String getOsArch() {
        return System.getProperty("os.arch");
    }

    public boolean isAlpine() {
        return Files.exists(Path.of("/etc/alpine-release", new String[0]), new LinkOption[0]);
    }
}

