/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.bridge;

import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Locale;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.plugins.javascript.bridge.Environment;
import org.sonar.plugins.javascript.nodejs.NodeVersion;
import org.sonar.plugins.javascript.nodejs.ProcessWrapper;
import org.sonarsource.api.sonarlint.SonarLintSide;
import org.tukaani.xz.XZInputStream;

@ScannerSide
@SonarLintSide(lifespan="INSTANCE")
public class EmbeddedNode {
    public static final String VERSION_FILENAME = "version.txt";
    private static final String DEPLOY_LOCATION = Path.of("js", "node-runtime").toString();
    private static final long EXTRACTION_LOCK_WAIT_TIME_MILLIS = 10000L;
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedNode.class);
    private final Path deployLocation;
    private final Platform platform;
    private final Environment env;
    private final ProcessWrapper processWrapper;
    private boolean isAvailable;

    public EmbeddedNode(ProcessWrapper processWrapper, Environment env) {
        this.platform = Platform.detect(env);
        this.deployLocation = EmbeddedNode.runtimeCachePathFrom(env.getSonarUserHome());
        this.env = env;
        this.processWrapper = processWrapper;
    }

    private static Path runtimeCachePathFrom(Path baseDir) {
        return baseDir.resolve(DEPLOY_LOCATION);
    }

    public boolean isAvailable() {
        return this.platform != Platform.UNSUPPORTED && this.isAvailable;
    }

    public void deploy() throws IOException {
        LOG.info("Detected os: {} arch: {} alpine: {}. Platform: {}", new Object[]{this.env.getOsName(), this.env.getOsArch(), this.env.isAlpine(), this.platform});
        if (this.platform == Platform.UNSUPPORTED) {
            LOG.debug("Your platform is not supported for embedded Node.js. Falling back to host Node.js.");
            return;
        }
        try {
            InputStream is = this.getClass().getResourceAsStream(this.platform.archivePathInJar());
            if (is == null) {
                LOG.debug("Embedded node not found for platform {}", (Object)this.platform.archivePathInJar());
                return;
            }
            Path targetRuntime = this.deployLocation.resolve(this.platform.binary());
            Path targetDirectory = targetRuntime.getParent();
            Path targetVersion = targetDirectory.resolve(VERSION_FILENAME);
            LOG.info("Deploy location {}, tagetRuntime: {},  version: {}", this.deployLocation, targetRuntime, targetVersion);
            InputStream versionIs = this.getClass().getResourceAsStream(this.platform.versionPathInJar());
            if (Files.exists(targetVersion, new LinkOption[0]) && !EmbeddedNode.isDifferent(versionIs, targetVersion)) {
                LOG.debug("Skipping node deploy. Deployed node has latest version.");
            } else {
                this.extractWithLocking(is, targetRuntime, targetDirectory);
            }
            String detected = NodeVersion.getVersion(this.processWrapper, this.binary().toString());
            LOG.debug("Deployed node version {}", (Object)detected);
            this.isAvailable = true;
        }
        catch (Exception e) {
            LOG.warn("Embedded Node.js failed to deploy in {}.\nYou can change the location by setting the option `sonar.userHome` or the environment variable `SONAR_USER_HOME`.\nOtherwise, it will default to {}.\nWill fallback to host Node.js.", this.deployLocation, Environment.defaultSonarUserHome(), e);
        }
    }

    private static boolean isDifferent(InputStream newVersionIs, Path currentVersionPath) throws IOException {
        String newVersionString = new String(newVersionIs.readAllBytes(), StandardCharsets.UTF_8);
        String currentVersionString = Files.readString(currentVersionPath);
        LOG.debug("Currently installed Node.js version: {}. Available version in analyzer: {}", (Object)currentVersionString, (Object)newVersionString);
        return !newVersionString.equals(currentVersionString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractWithLocking(InputStream source, Path targetRuntime, Path targetDirectory) throws IOException {
        block17: {
            Path targetLockFile = targetDirectory.resolve("lockfile");
            Files.createDirectories(targetDirectory, new FileAttribute[0]);
            try (FileOutputStream fos = new FileOutputStream(targetLockFile.toString());
                 FileChannel channel = fos.getChannel();){
                FileLock lock = channel.tryLock();
                if (lock != null) {
                    try {
                        LOG.debug("Lock acquired for extraction");
                        this.extract(source, targetRuntime);
                        InputStream versionIs = this.getClass().getResourceAsStream(this.platform.versionPathInJar());
                        Files.copy(versionIs, this.deployLocation.resolve(VERSION_FILENAME), StandardCopyOption.REPLACE_EXISTING);
                        break block17;
                    }
                    finally {
                        lock.release();
                    }
                }
                try {
                    LOG.debug("Lock taken, waiting 10000ms for other process to extract node runtime.");
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    LOG.warn("Interrupted while waiting for another process to extract the node runtime.");
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private void extract(InputStream source, Path target) throws IOException {
        try (BufferedInputStream stream = new BufferedInputStream(source);
             XZInputStream archive = new XZInputStream(stream);
             OutputStream os = Files.newOutputStream(target, new OpenOption[0]);){
            int nextBytes;
            LOG.debug("Extracting embedded node to {}", (Object)target);
            byte[] buf = new byte[0x800000];
            while ((nextBytes = archive.read(buf)) > -1) {
                os.write(buf, 0, nextBytes);
            }
            if (this.platform != Platform.WIN_X64) {
                Files.setPosixFilePermissions(target, Set.of(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE));
            }
        }
    }

    public Path binary() {
        return this.deployLocation.resolve(this.platform.binary());
    }

    static enum Platform {
        WIN_X64,
        LINUX_ARM64,
        LINUX_X64,
        LINUX_X64_MUSL,
        DARWIN_ARM64,
        DARWIN_X64,
        UNSUPPORTED;


        private String pathInJar() {
            return switch (this.ordinal()) {
                case 0 -> "/win-x64/";
                case 1 -> "/linux-arm64/";
                case 2 -> "/linux-x64/";
                case 3 -> "/linux-x64-musl/";
                case 4 -> "/darwin-arm64/";
                case 5 -> "/darwin-x64/";
                default -> "";
            };
        }

        String archivePathInJar() {
            return this.pathInJar() + this.binary() + ".xz";
        }

        String versionPathInJar() {
            return this.pathInJar() + EmbeddedNode.VERSION_FILENAME;
        }

        String binary() {
            if (this == WIN_X64) {
                return "node.exe";
            }
            return "node";
        }

        static Platform detect(Environment env) {
            String osName = env.getOsName();
            String lowerCaseOsName = osName.toLowerCase(Locale.ROOT);
            if (osName.contains("Windows") && Platform.isX64(env)) {
                return WIN_X64;
            }
            if (lowerCaseOsName.contains("linux") && Platform.isARM64(env)) {
                return LINUX_ARM64;
            }
            if (lowerCaseOsName.contains("linux") && Platform.isX64(env)) {
                return env.isAlpine() ? LINUX_X64_MUSL : LINUX_X64;
            }
            if (lowerCaseOsName.contains("mac os") && Platform.isARM64(env)) {
                return DARWIN_ARM64;
            }
            if (lowerCaseOsName.contains("mac os") && Platform.isX64(env)) {
                return DARWIN_X64;
            }
            return UNSUPPORTED;
        }

        private static boolean isX64(Environment env) {
            return env.getOsArch().contains("amd64");
        }

        private static boolean isARM64(Environment env) {
            return env.getOsArch().contains("aarch64");
        }
    }
}

