/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.bridge;

import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import org.sonar.plugins.javascript.api.estree.ESTree;
import org.sonar.plugins.javascript.bridge.protobuf.ArrayElement;
import org.sonar.plugins.javascript.bridge.protobuf.ArrayExpression;
import org.sonar.plugins.javascript.bridge.protobuf.ArrayPattern;
import org.sonar.plugins.javascript.bridge.protobuf.ArrowFunctionExpression;
import org.sonar.plugins.javascript.bridge.protobuf.AssignmentExpression;
import org.sonar.plugins.javascript.bridge.protobuf.AssignmentPattern;
import org.sonar.plugins.javascript.bridge.protobuf.AwaitExpression;
import org.sonar.plugins.javascript.bridge.protobuf.BinaryExpression;
import org.sonar.plugins.javascript.bridge.protobuf.BlockStatement;
import org.sonar.plugins.javascript.bridge.protobuf.BreakStatement;
import org.sonar.plugins.javascript.bridge.protobuf.CallExpression;
import org.sonar.plugins.javascript.bridge.protobuf.CatchClause;
import org.sonar.plugins.javascript.bridge.protobuf.ChainExpression;
import org.sonar.plugins.javascript.bridge.protobuf.ClassBody;
import org.sonar.plugins.javascript.bridge.protobuf.ClassDeclaration;
import org.sonar.plugins.javascript.bridge.protobuf.ClassExpression;
import org.sonar.plugins.javascript.bridge.protobuf.ConditionalExpression;
import org.sonar.plugins.javascript.bridge.protobuf.ContinueStatement;
import org.sonar.plugins.javascript.bridge.protobuf.DoWhileStatement;
import org.sonar.plugins.javascript.bridge.protobuf.ExportAllDeclaration;
import org.sonar.plugins.javascript.bridge.protobuf.ExportAssignment;
import org.sonar.plugins.javascript.bridge.protobuf.ExportDefaultDeclaration;
import org.sonar.plugins.javascript.bridge.protobuf.ExportNamedDeclaration;
import org.sonar.plugins.javascript.bridge.protobuf.ExportSpecifier;
import org.sonar.plugins.javascript.bridge.protobuf.ExpressionStatement;
import org.sonar.plugins.javascript.bridge.protobuf.ForInStatement;
import org.sonar.plugins.javascript.bridge.protobuf.ForOfStatement;
import org.sonar.plugins.javascript.bridge.protobuf.ForStatement;
import org.sonar.plugins.javascript.bridge.protobuf.FunctionDeclaration;
import org.sonar.plugins.javascript.bridge.protobuf.FunctionExpression;
import org.sonar.plugins.javascript.bridge.protobuf.Identifier;
import org.sonar.plugins.javascript.bridge.protobuf.IfStatement;
import org.sonar.plugins.javascript.bridge.protobuf.ImportDeclaration;
import org.sonar.plugins.javascript.bridge.protobuf.ImportDefaultSpecifier;
import org.sonar.plugins.javascript.bridge.protobuf.ImportExpression;
import org.sonar.plugins.javascript.bridge.protobuf.ImportNamespaceSpecifier;
import org.sonar.plugins.javascript.bridge.protobuf.ImportSpecifier;
import org.sonar.plugins.javascript.bridge.protobuf.JSXAttribute;
import org.sonar.plugins.javascript.bridge.protobuf.JSXClosingElement;
import org.sonar.plugins.javascript.bridge.protobuf.JSXElement;
import org.sonar.plugins.javascript.bridge.protobuf.JSXExpressionContainer;
import org.sonar.plugins.javascript.bridge.protobuf.JSXFragment;
import org.sonar.plugins.javascript.bridge.protobuf.JSXIdentifier;
import org.sonar.plugins.javascript.bridge.protobuf.JSXMemberExpression;
import org.sonar.plugins.javascript.bridge.protobuf.JSXNamespacedName;
import org.sonar.plugins.javascript.bridge.protobuf.JSXOpeningElement;
import org.sonar.plugins.javascript.bridge.protobuf.JSXSpreadAttribute;
import org.sonar.plugins.javascript.bridge.protobuf.JSXSpreadChild;
import org.sonar.plugins.javascript.bridge.protobuf.JSXText;
import org.sonar.plugins.javascript.bridge.protobuf.LabeledStatement;
import org.sonar.plugins.javascript.bridge.protobuf.Literal;
import org.sonar.plugins.javascript.bridge.protobuf.LogicalExpression;
import org.sonar.plugins.javascript.bridge.protobuf.MemberExpression;
import org.sonar.plugins.javascript.bridge.protobuf.MetaProperty;
import org.sonar.plugins.javascript.bridge.protobuf.MethodDefinition;
import org.sonar.plugins.javascript.bridge.protobuf.NewExpression;
import org.sonar.plugins.javascript.bridge.protobuf.Node;
import org.sonar.plugins.javascript.bridge.protobuf.NodeType;
import org.sonar.plugins.javascript.bridge.protobuf.ObjectExpression;
import org.sonar.plugins.javascript.bridge.protobuf.ObjectPattern;
import org.sonar.plugins.javascript.bridge.protobuf.PrivateIdentifier;
import org.sonar.plugins.javascript.bridge.protobuf.Program;
import org.sonar.plugins.javascript.bridge.protobuf.Property;
import org.sonar.plugins.javascript.bridge.protobuf.PropertyDefinition;
import org.sonar.plugins.javascript.bridge.protobuf.RestElement;
import org.sonar.plugins.javascript.bridge.protobuf.ReturnStatement;
import org.sonar.plugins.javascript.bridge.protobuf.SequenceExpression;
import org.sonar.plugins.javascript.bridge.protobuf.SourceLocation;
import org.sonar.plugins.javascript.bridge.protobuf.SpreadElement;
import org.sonar.plugins.javascript.bridge.protobuf.StaticBlock;
import org.sonar.plugins.javascript.bridge.protobuf.SwitchCase;
import org.sonar.plugins.javascript.bridge.protobuf.SwitchStatement;
import org.sonar.plugins.javascript.bridge.protobuf.TSExternalModuleReference;
import org.sonar.plugins.javascript.bridge.protobuf.TSImportEqualsDeclaration;
import org.sonar.plugins.javascript.bridge.protobuf.TSModuleDeclaration;
import org.sonar.plugins.javascript.bridge.protobuf.TSParameterProperty;
import org.sonar.plugins.javascript.bridge.protobuf.TSQualifiedName;
import org.sonar.plugins.javascript.bridge.protobuf.TaggedTemplateExpression;
import org.sonar.plugins.javascript.bridge.protobuf.TemplateElement;
import org.sonar.plugins.javascript.bridge.protobuf.TemplateLiteral;
import org.sonar.plugins.javascript.bridge.protobuf.ThrowStatement;
import org.sonar.plugins.javascript.bridge.protobuf.TryStatement;
import org.sonar.plugins.javascript.bridge.protobuf.UnaryExpression;
import org.sonar.plugins.javascript.bridge.protobuf.UpdateExpression;
import org.sonar.plugins.javascript.bridge.protobuf.VariableDeclaration;
import org.sonar.plugins.javascript.bridge.protobuf.VariableDeclarator;
import org.sonar.plugins.javascript.bridge.protobuf.WhileStatement;
import org.sonar.plugins.javascript.bridge.protobuf.WithStatement;
import org.sonar.plugins.javascript.bridge.protobuf.YieldExpression;

public class ESTreeFactory {
    private ESTreeFactory() {
    }

    public static <T> T from(Node node, Class<T> clazz) {
        ESTree.Node estreeNode = switch (node.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case NodeType.ProgramType -> ESTreeFactory.fromProgramType(node);
            case NodeType.ExportAllDeclarationType -> ESTreeFactory.fromExportAllDeclarationType(node);
            case NodeType.IdentifierType -> ESTreeFactory.fromIdentifierType(node);
            case NodeType.ExportDefaultDeclarationType -> ESTreeFactory.fromExportDefaultDeclarationType(node);
            case NodeType.YieldExpressionType -> ESTreeFactory.fromYieldExpressionType(node);
            case NodeType.UpdateExpressionType -> ESTreeFactory.fromUpdateExpressionType(node);
            case NodeType.UnaryExpressionType -> ESTreeFactory.fromUnaryExpressionType(node);
            case NodeType.ThisExpressionType -> ESTreeFactory.fromThisExpressionType(node);
            case NodeType.TemplateLiteralType -> ESTreeFactory.fromTemplateLiteralType(node);
            case NodeType.TaggedTemplateExpressionType -> ESTreeFactory.fromTaggedTemplateExpressionType(node);
            case NodeType.SequenceExpressionType -> ESTreeFactory.fromSequenceExpressionType(node);
            case NodeType.ObjectExpressionType -> ESTreeFactory.fromObjectExpressionType(node);
            case NodeType.SpreadElementType -> ESTreeFactory.fromSpreadElementType(node);
            case NodeType.PropertyType -> ESTreeFactory.fromPropertyType(node);
            case NodeType.AssignmentPatternType -> ESTreeFactory.fromAssignmentPatternType(node);
            case NodeType.RestElementType -> ESTreeFactory.fromRestElementType(node);
            case NodeType.ArrayPatternType -> ESTreeFactory.fromArrayPatternType(node);
            case NodeType.ObjectPatternType -> ESTreeFactory.fromObjectPatternType(node);
            case NodeType.PrivateIdentifierType -> ESTreeFactory.fromPrivateIdentifierType(node);
            case NodeType.NewExpressionType -> ESTreeFactory.fromNewExpressionType(node);
            case NodeType.SuperType -> ESTreeFactory.fromSuperType(node);
            case NodeType.MetaPropertyType -> ESTreeFactory.fromMetaPropertyType(node);
            case NodeType.MemberExpressionType -> ESTreeFactory.fromMemberExpressionType(node);
            case NodeType.LogicalExpressionType -> ESTreeFactory.fromLogicalExpressionType(node);
            case NodeType.ImportExpressionType -> ESTreeFactory.fromImportExpressionType(node);
            case NodeType.BlockStatementType -> ESTreeFactory.fromBlockStatementType(node);
            case NodeType.ConditionalExpressionType -> ESTreeFactory.fromConditionalExpressionType(node);
            case NodeType.ClassExpressionType -> ESTreeFactory.fromClassExpressionType(node);
            case NodeType.ClassBodyType -> ESTreeFactory.fromClassBodyType(node);
            case NodeType.StaticBlockType -> ESTreeFactory.fromStaticBlockType(node);
            case NodeType.PropertyDefinitionType -> ESTreeFactory.fromPropertyDefinitionType(node);
            case NodeType.MethodDefinitionType -> ESTreeFactory.fromMethodDefinitionType(node);
            case NodeType.ChainExpressionType -> ESTreeFactory.fromChainExpressionType(node);
            case NodeType.CallExpressionType -> ESTreeFactory.fromCallExpressionType(node);
            case NodeType.BinaryExpressionType -> ESTreeFactory.fromBinaryExpressionType(node);
            case NodeType.AwaitExpressionType -> ESTreeFactory.fromAwaitExpressionType(node);
            case NodeType.AssignmentExpressionType -> ESTreeFactory.fromAssignmentExpressionType(node);
            case NodeType.ArrowFunctionExpressionType -> ESTreeFactory.fromArrowFunctionExpressionType(node);
            case NodeType.ArrayExpressionType -> ESTreeFactory.fromArrayExpressionType(node);
            case NodeType.ClassDeclarationType -> ESTreeFactory.fromClassDeclarationType(node);
            case NodeType.FunctionDeclarationType -> ESTreeFactory.fromFunctionDeclarationType(node);
            case NodeType.ExportNamedDeclarationType -> ESTreeFactory.fromExportNamedDeclarationType(node);
            case NodeType.ExportSpecifierType -> ESTreeFactory.fromExportSpecifierType(node);
            case NodeType.VariableDeclarationType -> ESTreeFactory.fromVariableDeclarationType(node);
            case NodeType.VariableDeclaratorType -> ESTreeFactory.fromVariableDeclaratorType(node);
            case NodeType.ImportDeclarationType -> ESTreeFactory.fromImportDeclarationType(node);
            case NodeType.ImportNamespaceSpecifierType -> ESTreeFactory.fromImportNamespaceSpecifierType(node);
            case NodeType.ImportDefaultSpecifierType -> ESTreeFactory.fromImportDefaultSpecifierType(node);
            case NodeType.ImportSpecifierType -> ESTreeFactory.fromImportSpecifierType(node);
            case NodeType.ForOfStatementType -> ESTreeFactory.fromForOfStatementType(node);
            case NodeType.ForInStatementType -> ESTreeFactory.fromForInStatementType(node);
            case NodeType.ForStatementType -> ESTreeFactory.fromForStatementType(node);
            case NodeType.DoWhileStatementType -> ESTreeFactory.fromDoWhileStatementType(node);
            case NodeType.WhileStatementType -> ESTreeFactory.fromWhileStatementType(node);
            case NodeType.TryStatementType -> ESTreeFactory.fromTryStatementType(node);
            case NodeType.CatchClauseType -> ESTreeFactory.fromCatchClauseType(node);
            case NodeType.ThrowStatementType -> ESTreeFactory.fromThrowStatementType(node);
            case NodeType.SwitchStatementType -> ESTreeFactory.fromSwitchStatementType(node);
            case NodeType.SwitchCaseType -> ESTreeFactory.fromSwitchCaseType(node);
            case NodeType.IfStatementType -> ESTreeFactory.fromIfStatementType(node);
            case NodeType.ContinueStatementType -> ESTreeFactory.fromContinueStatementType(node);
            case NodeType.BreakStatementType -> ESTreeFactory.fromBreakStatementType(node);
            case NodeType.LabeledStatementType -> ESTreeFactory.fromLabeledStatementType(node);
            case NodeType.ReturnStatementType -> ESTreeFactory.fromReturnStatementType(node);
            case NodeType.WithStatementType -> ESTreeFactory.fromWithStatementType(node);
            case NodeType.DebuggerStatementType -> ESTreeFactory.fromDebuggerStatementType(node);
            case NodeType.EmptyStatementType -> ESTreeFactory.fromEmptyStatementType(node);
            case NodeType.ExpressionStatementType -> {
                if (node.getExpressionStatement().hasDirective()) {
                    yield ESTreeFactory.fromDirective(node);
                }
                yield ESTreeFactory.fromExpressionStatementType(node);
            }
            case NodeType.LiteralType -> ESTreeFactory.fromLiteralType(node);
            case NodeType.TemplateElementType -> ESTreeFactory.fromTemplateElementType(node);
            case NodeType.FunctionExpressionType -> ESTreeFactory.fromFunctionExpressionType(node);
            case NodeType.TSExportAssignmentType -> ESTreeFactory.fromExportAssignment(node);
            case NodeType.TSImportEqualsDeclarationType -> ESTreeFactory.fromTSImportEqualsDeclaration(node);
            case NodeType.TSExternalModuleReferenceType -> ESTreeFactory.fromTSExternalModuleReferenceType(node);
            case NodeType.TSQualifiedNameType -> ESTreeFactory.fromTSQualifiedName(node);
            case NodeType.TSModuleBlockType -> ESTreeFactory.fromTSModuleBlock(node);
            case NodeType.TSModuleDeclarationType -> ESTreeFactory.fromTSModuleDeclaration(node);
            case NodeType.TSParameterPropertyType -> ESTreeFactory.fromTSParameterProperty(node);
            case NodeType.TSTypeAliasDeclarationType -> ESTreeFactory.fromTSTypeAliasDeclaration(node);
            case NodeType.TSEnumDeclarationType -> ESTreeFactory.fromTSEnumDeclaration(node);
            case NodeType.TSInterfaceDeclarationType -> ESTreeFactory.fromTSInterfaceDeclaration(node);
            case NodeType.TSDeclareFunctionType -> ESTreeFactory.fromTSDeclareFunction(node);
            case NodeType.TSEmptyBodyFunctionExpressionType -> ESTreeFactory.fromTSEmptyBodyFunctionExpression(node);
            case NodeType.TSAbstractMethodDefinitionType -> ESTreeFactory.fromTSAbstractMethodDefinition(node);
            case NodeType.TSTypeParameterInstantiationType -> ESTreeFactory.fromTSTypeParameterInstantiation(node);
            case NodeType.JSXElementType -> ESTreeFactory.fromJSXElement(node);
            case NodeType.JSXFragmentType -> ESTreeFactory.fromJSXFragment(node);
            case NodeType.JSXOpeningElementType -> ESTreeFactory.fromJSXOpeningElement(node);
            case NodeType.JSXClosingElementType -> ESTreeFactory.fromJSXClosingElement(node);
            case NodeType.JSXOpeningFragmentType -> ESTreeFactory.fromJSXOpeningFragment(node);
            case NodeType.JSXClosingFragmentType -> ESTreeFactory.fromJSXClosingFragment(node);
            case NodeType.JSXAttributeType -> ESTreeFactory.fromJSXAttribute(node);
            case NodeType.JSXIdentifierType -> ESTreeFactory.fromJSXIdentifier(node);
            case NodeType.JSXMemberExpressionType -> ESTreeFactory.fromJSXMemberExpression(node);
            case NodeType.JSXNamespacedNameType -> ESTreeFactory.fromJSXNamespacedName(node);
            case NodeType.JSXSpreadAttributeType -> ESTreeFactory.fromJSXSpreadAttribute(node);
            case NodeType.JSXExpressionContainerType -> ESTreeFactory.fromJSXExpressionContainer(node);
            case NodeType.JSXSpreadChildType -> ESTreeFactory.fromJSXSpreadChild(node);
            case NodeType.JSXTextType -> ESTreeFactory.fromJSXText(node);
            case NodeType.JSXEmptyExpressionType -> ESTreeFactory.fromJSXEmptyExpression(node);
            case NodeType.UnknownNodeType -> ESTreeFactory.fromUnknownNodeType(node);
            case NodeType.UNRECOGNIZED -> throw new IllegalArgumentException("Unknown node type: " + String.valueOf(node.getType()) + " at " + String.valueOf(node.getLoc()));
        };
        if (!clazz.isInstance(estreeNode)) {
            throw new IllegalStateException("Expected " + String.valueOf(clazz) + " but got " + String.valueOf(estreeNode.getClass()));
        }
        return clazz.cast(estreeNode);
    }

    private static <T> List<T> from(List<Node> bodyList, Class<T> clazz) {
        return bodyList.stream().map(n -> ESTreeFactory.from(n, clazz)).toList();
    }

    private static ESTree.Location fromLocation(SourceLocation location) {
        return new ESTree.Location(new ESTree.Position(location.getStart().getLine(), location.getStart().getColumn()), new ESTree.Position(location.getEnd().getLine(), location.getEnd().getColumn()));
    }

    private static ESTree.Program fromProgramType(Node node) {
        Program program = node.getProgram();
        return new ESTree.Program(ESTreeFactory.fromLocation(node.getLoc()), program.getSourceType(), ESTreeFactory.from(program.getBodyList(), ESTree.DirectiveOrModuleDeclarationOrStatement.class));
    }

    private static ESTree.ExportAllDeclaration fromExportAllDeclarationType(Node node) {
        ExportAllDeclaration exportAllDeclaration = node.getExportAllDeclaration();
        return new ESTree.ExportAllDeclaration(ESTreeFactory.fromLocation(node.getLoc()), exportAllDeclaration.hasExported() ? Optional.of(ESTreeFactory.from(exportAllDeclaration.getExported(), ESTree.IdentifierOrLiteral.class)) : Optional.empty(), ESTreeFactory.from(exportAllDeclaration.getSource(), ESTree.Literal.class));
    }

    private static ESTree.ExportAssignment fromExportAssignment(Node node) {
        ExportAssignment exportAssignment = node.getExportAssignment();
        return new ESTree.ExportAssignment(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(exportAssignment.getExpression(), ESTree.Expression.class));
    }

    private static ESTree.Identifier fromIdentifierType(Node node) {
        Identifier identifier = node.getIdentifier();
        return new ESTree.Identifier(ESTreeFactory.fromLocation(node.getLoc()), identifier.getName());
    }

    private static ESTree.ExportDefaultDeclaration fromExportDefaultDeclarationType(Node node) {
        ExportDefaultDeclaration exportDefaultDeclaration = node.getExportDefaultDeclaration();
        return new ESTree.ExportDefaultDeclaration(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(exportDefaultDeclaration.getDeclaration(), ESTree.ExpressionOrClassDeclarationOrFunctionDeclaration.class));
    }

    private static ESTree.YieldExpression fromYieldExpressionType(Node node) {
        YieldExpression yieldExpression = node.getYieldExpression();
        return new ESTree.YieldExpression(ESTreeFactory.fromLocation(node.getLoc()), yieldExpression.hasArgument() ? Optional.of(ESTreeFactory.from(yieldExpression.getArgument(), ESTree.Expression.class)) : Optional.empty(), yieldExpression.getDelegate());
    }

    private static ESTree.UpdateExpression fromUpdateExpressionType(Node node) {
        UpdateExpression updateExpression = node.getUpdateExpression();
        return new ESTree.UpdateExpression(ESTreeFactory.fromLocation(node.getLoc()), ESTree.UpdateOperator.from(updateExpression.getOperator()), ESTreeFactory.from(updateExpression.getArgument(), ESTree.Expression.class), updateExpression.getPrefix());
    }

    private static ESTree.UnaryExpression fromUnaryExpressionType(Node node) {
        UnaryExpression unaryExpression = node.getUnaryExpression();
        return new ESTree.UnaryExpression(ESTreeFactory.fromLocation(node.getLoc()), ESTree.UnaryOperator.from(unaryExpression.getOperator()), unaryExpression.getPrefix(), ESTreeFactory.from(unaryExpression.getArgument(), ESTree.Expression.class));
    }

    private static ESTree.ThisExpression fromThisExpressionType(Node node) {
        return new ESTree.ThisExpression(ESTreeFactory.fromLocation(node.getLoc()));
    }

    private static ESTree.TemplateLiteral fromTemplateLiteralType(Node node) {
        TemplateLiteral templateLiteral = node.getTemplateLiteral();
        return new ESTree.TemplateLiteral(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(templateLiteral.getQuasisList(), ESTree.TemplateElement.class), ESTreeFactory.from(templateLiteral.getExpressionsList(), ESTree.Expression.class));
    }

    private static ESTree.TaggedTemplateExpression fromTaggedTemplateExpressionType(Node node) {
        TaggedTemplateExpression taggedTemplateExpression = node.getTaggedTemplateExpression();
        return new ESTree.TaggedTemplateExpression(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(taggedTemplateExpression.getTag(), ESTree.Expression.class), ESTreeFactory.from(taggedTemplateExpression.getQuasi(), ESTree.TemplateLiteral.class));
    }

    private static ESTree.SequenceExpression fromSequenceExpressionType(Node node) {
        SequenceExpression sequenceExpression = node.getSequenceExpression();
        return new ESTree.SequenceExpression(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(sequenceExpression.getExpressionsList(), ESTree.Expression.class));
    }

    private static ESTree.ObjectExpression fromObjectExpressionType(Node node) {
        ObjectExpression objectExpression = node.getObjectExpression();
        return new ESTree.ObjectExpression(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(objectExpression.getPropertiesList(), ESTree.PropertyOrSpreadElement.class));
    }

    private static ESTree.SpreadElement fromSpreadElementType(Node node) {
        SpreadElement spreadElement = node.getSpreadElement();
        return new ESTree.SpreadElement(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(spreadElement.getArgument(), ESTree.Expression.class));
    }

    private static ESTree.Property fromPropertyType(Node node) {
        Property property = node.getProperty();
        return new ESTree.Property(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(property.getKey(), ESTree.ExpressionOrPrivateIdentifier.class), ESTreeFactory.from(property.getValue(), ESTree.ExpressionOrPattern.class), property.getKind(), property.getMethod(), property.getShorthand(), property.getComputed());
    }

    private static ESTree.AssignmentPattern fromAssignmentPatternType(Node node) {
        AssignmentPattern assignmentPattern = node.getAssignmentPattern();
        return new ESTree.AssignmentPattern(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(assignmentPattern.getLeft(), ESTree.Pattern.class), ESTreeFactory.from(assignmentPattern.getRight(), ESTree.Expression.class));
    }

    private static ESTree.RestElement fromRestElementType(Node node) {
        RestElement restElement = node.getRestElement();
        return new ESTree.RestElement(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(restElement.getArgument(), ESTree.Pattern.class));
    }

    private static ESTree.ArrayPattern fromArrayPatternType(Node node) {
        ArrayPattern arrayPattern = node.getArrayPattern();
        return new ESTree.ArrayPattern(ESTreeFactory.fromLocation(node.getLoc()), arrayPattern.getElementsList().stream().map(ESTreeFactory::fromArrayPatternElement).toList());
    }

    private static Optional<ESTree.Pattern> fromArrayPatternElement(ArrayElement element) {
        return element.hasElement() ? Optional.of(ESTreeFactory.from(element.getElement(), ESTree.Pattern.class)) : Optional.empty();
    }

    private static ESTree.ObjectPattern fromObjectPatternType(Node node) {
        ObjectPattern objectPattern = node.getObjectPattern();
        return new ESTree.ObjectPattern(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(objectPattern.getPropertiesList(), ESTree.PropertyOrRestElement.class));
    }

    private static ESTree.PrivateIdentifier fromPrivateIdentifierType(Node node) {
        PrivateIdentifier privateIdentifier = node.getPrivateIdentifier();
        return new ESTree.PrivateIdentifier(ESTreeFactory.fromLocation(node.getLoc()), privateIdentifier.getName());
    }

    private static ESTree.NewExpression fromNewExpressionType(Node node) {
        NewExpression newExpression = node.getNewExpression();
        return new ESTree.NewExpression(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(newExpression.getCallee(), ESTree.ExpressionOrSuper.class), ESTreeFactory.from(newExpression.getArgumentsList(), ESTree.ExpressionOrSpreadElement.class));
    }

    private static ESTree.Super fromSuperType(Node node) {
        return new ESTree.Super(ESTreeFactory.fromLocation(node.getLoc()));
    }

    private static ESTree.MetaProperty fromMetaPropertyType(Node node) {
        MetaProperty metaProperty = node.getMetaProperty();
        return new ESTree.MetaProperty(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(metaProperty.getMeta(), ESTree.Identifier.class), ESTreeFactory.from(metaProperty.getProperty(), ESTree.Identifier.class));
    }

    private static ESTree.MemberExpression fromMemberExpressionType(Node node) {
        MemberExpression memberExpression = node.getMemberExpression();
        return new ESTree.MemberExpression(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(memberExpression.getObject(), ESTree.ExpressionOrSuper.class), ESTreeFactory.from(memberExpression.getProperty(), ESTree.ExpressionOrPrivateIdentifier.class), memberExpression.getComputed(), memberExpression.getOptional());
    }

    private static ESTree.LogicalExpression fromLogicalExpressionType(Node node) {
        LogicalExpression logicalExpression = node.getLogicalExpression();
        return new ESTree.LogicalExpression(ESTreeFactory.fromLocation(node.getLoc()), ESTree.LogicalOperator.from(logicalExpression.getOperator()), ESTreeFactory.from(logicalExpression.getLeft(), ESTree.Expression.class), ESTreeFactory.from(logicalExpression.getRight(), ESTree.Expression.class));
    }

    private static ESTree.ImportExpression fromImportExpressionType(Node node) {
        ImportExpression importExpression = node.getImportExpression();
        return new ESTree.ImportExpression(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(importExpression.getSource(), ESTree.Expression.class));
    }

    private static ESTree.BlockStatement fromBlockStatementType(Node node) {
        BlockStatement blockStatement = node.getBlockStatement();
        return new ESTree.BlockStatement(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(blockStatement.getBodyList(), ESTree.Statement.class));
    }

    private static ESTree.ConditionalExpression fromConditionalExpressionType(Node node) {
        ConditionalExpression conditionalExpression = node.getConditionalExpression();
        return new ESTree.ConditionalExpression(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(conditionalExpression.getTest(), ESTree.Expression.class), ESTreeFactory.from(conditionalExpression.getAlternate(), ESTree.Expression.class), ESTreeFactory.from(conditionalExpression.getConsequent(), ESTree.Expression.class));
    }

    private static ESTree.ClassExpression fromClassExpressionType(Node node) {
        ClassExpression classExpression = node.getClassExpression();
        return new ESTree.ClassExpression(ESTreeFactory.fromLocation(node.getLoc()), classExpression.hasId() ? Optional.of(ESTreeFactory.from(classExpression.getId(), ESTree.Identifier.class)) : Optional.empty(), classExpression.hasSuperClass() ? Optional.of(ESTreeFactory.from(classExpression.getSuperClass(), ESTree.Expression.class)) : Optional.empty(), ESTreeFactory.from(classExpression.getBody(), ESTree.ClassBody.class));
    }

    private static ESTree.ClassBody fromClassBodyType(Node node) {
        ClassBody classBody = node.getClassBody();
        return new ESTree.ClassBody(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(classBody.getBodyList(), ESTree.MethodDefinitionOrPropertyDefinitionOrStaticBlock.class));
    }

    private static ESTree.StaticBlock fromStaticBlockType(Node node) {
        StaticBlock staticBlock = node.getStaticBlock();
        return new ESTree.StaticBlock(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(staticBlock.getBodyList(), ESTree.Statement.class));
    }

    private static ESTree.PropertyDefinition fromPropertyDefinitionType(Node node) {
        PropertyDefinition propertyDefinition = node.getPropertyDefinition();
        return new ESTree.PropertyDefinition(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(propertyDefinition.getKey(), ESTree.ExpressionOrPrivateIdentifier.class), propertyDefinition.hasValue() ? Optional.of(ESTreeFactory.from(propertyDefinition.getValue(), ESTree.Expression.class)) : Optional.empty(), propertyDefinition.getComputed(), propertyDefinition.getStatic());
    }

    private static ESTree.MethodDefinition fromMethodDefinitionType(Node node) {
        MethodDefinition methodDefinition = node.getMethodDefinition();
        return new ESTree.MethodDefinition(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(methodDefinition.getKey(), ESTree.ExpressionOrPrivateIdentifier.class), ESTreeFactory.from(methodDefinition.getValue(), ESTree.FunctionExpressionOrTSEmptyBodyFunctionExpression.class), methodDefinition.getKind(), methodDefinition.getComputed(), methodDefinition.getStatic());
    }

    private static ESTree.ChainExpression fromChainExpressionType(Node node) {
        ChainExpression chainExpression = node.getChainExpression();
        return new ESTree.ChainExpression(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(chainExpression.getExpression(), ESTree.ChainElement.class));
    }

    private static ESTree.CallExpression fromCallExpressionType(Node node) {
        CallExpression callExpression = node.getCallExpression();
        return new ESTree.SimpleCallExpression(ESTreeFactory.fromLocation(node.getLoc()), callExpression.getOptional(), ESTreeFactory.from(callExpression.getCallee(), ESTree.ExpressionOrSuper.class), ESTreeFactory.from(callExpression.getArgumentsList(), ESTree.ExpressionOrSpreadElement.class));
    }

    private static ESTree.BinaryExpression fromBinaryExpressionType(Node node) {
        BinaryExpression binaryExpression = node.getBinaryExpression();
        return new ESTree.BinaryExpression(ESTreeFactory.fromLocation(node.getLoc()), ESTree.BinaryOperator.from(binaryExpression.getOperator()), ESTreeFactory.from(binaryExpression.getLeft(), ESTree.Expression.class), ESTreeFactory.from(binaryExpression.getRight(), ESTree.Expression.class));
    }

    private static ESTree.AwaitExpression fromAwaitExpressionType(Node node) {
        AwaitExpression awaitExpression = node.getAwaitExpression();
        return new ESTree.AwaitExpression(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(awaitExpression.getArgument(), ESTree.Expression.class));
    }

    private static ESTree.AssignmentExpression fromAssignmentExpressionType(Node node) {
        AssignmentExpression assignmentExpression = node.getAssignmentExpression();
        return new ESTree.AssignmentExpression(ESTreeFactory.fromLocation(node.getLoc()), ESTree.AssignmentOperator.from(assignmentExpression.getOperator()), ESTreeFactory.from(assignmentExpression.getLeft(), ESTree.MemberExpressionOrPattern.class), ESTreeFactory.from(assignmentExpression.getRight(), ESTree.Expression.class));
    }

    private static ESTree.ArrowFunctionExpression fromArrowFunctionExpressionType(Node node) {
        ArrowFunctionExpression arrowFunctionExpression = node.getArrowFunctionExpression();
        return new ESTree.ArrowFunctionExpression(ESTreeFactory.fromLocation(node.getLoc()), arrowFunctionExpression.getExpression(), ESTreeFactory.from(arrowFunctionExpression.getBody(), ESTree.BlockStatementOrExpression.class), ESTreeFactory.from(arrowFunctionExpression.getParamsList(), ESTree.PatternOrTSParameterProperty.class), arrowFunctionExpression.getGenerator(), arrowFunctionExpression.getAsync());
    }

    private static ESTree.ArrayExpression fromArrayExpressionType(Node node) {
        ArrayExpression arrayExpression = node.getArrayExpression();
        return new ESTree.ArrayExpression(ESTreeFactory.fromLocation(node.getLoc()), arrayExpression.getElementsList().stream().map(ESTreeFactory::fromArrayExpressionElement).toList());
    }

    private static Optional<ESTree.ExpressionOrSpreadElement> fromArrayExpressionElement(ArrayElement element) {
        return element.hasElement() ? Optional.of(ESTreeFactory.from(element.getElement(), ESTree.ExpressionOrSpreadElement.class)) : Optional.empty();
    }

    private static ESTree.ClassDeclaration fromClassDeclarationType(Node node) {
        ClassDeclaration classDeclaration = node.getClassDeclaration();
        return new ESTree.ClassDeclaration(ESTreeFactory.fromLocation(node.getLoc()), classDeclaration.hasId() ? Optional.of(ESTreeFactory.from(classDeclaration.getId(), ESTree.Identifier.class)) : Optional.empty(), classDeclaration.hasSuperClass() ? Optional.of(ESTreeFactory.from(classDeclaration.getSuperClass(), ESTree.Expression.class)) : Optional.empty(), ESTreeFactory.from(classDeclaration.getBody(), ESTree.ClassBody.class));
    }

    private static ESTree.FunctionDeclaration fromFunctionDeclarationType(Node node) {
        FunctionDeclaration functionDeclaration = node.getFunctionDeclaration();
        return new ESTree.FunctionDeclaration(ESTreeFactory.fromLocation(node.getLoc()), functionDeclaration.hasId() ? Optional.of(ESTreeFactory.from(functionDeclaration.getId(), ESTree.Identifier.class)) : Optional.empty(), ESTreeFactory.from(functionDeclaration.getBody(), ESTree.BlockStatement.class), ESTreeFactory.from(functionDeclaration.getParamsList(), ESTree.PatternOrTSParameterProperty.class), functionDeclaration.getGenerator(), functionDeclaration.getAsync());
    }

    private static ESTree.ExportNamedDeclaration fromExportNamedDeclarationType(Node node) {
        ExportNamedDeclaration exportNamedDeclaration = node.getExportNamedDeclaration();
        return new ESTree.ExportNamedDeclaration(ESTreeFactory.fromLocation(node.getLoc()), exportNamedDeclaration.hasDeclaration() ? Optional.of(ESTreeFactory.from(exportNamedDeclaration.getDeclaration(), ESTree.Declaration.class)) : Optional.empty(), ESTreeFactory.from(exportNamedDeclaration.getSpecifiersList(), ESTree.ExportSpecifier.class), exportNamedDeclaration.hasSource() ? Optional.of(ESTreeFactory.from(exportNamedDeclaration.getSource(), ESTree.Literal.class)) : Optional.empty());
    }

    private static ESTree.ExportSpecifier fromExportSpecifierType(Node node) {
        ExportSpecifier exportSpecifier = node.getExportSpecifier();
        return new ESTree.ExportSpecifier(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(exportSpecifier.getExported(), ESTree.Identifier.class), ESTreeFactory.from(exportSpecifier.getLocal(), ESTree.Identifier.class));
    }

    private static ESTree.VariableDeclaration fromVariableDeclarationType(Node node) {
        VariableDeclaration variableDeclaration = node.getVariableDeclaration();
        return new ESTree.VariableDeclaration(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(variableDeclaration.getDeclarationsList(), ESTree.VariableDeclarator.class), variableDeclaration.getKind());
    }

    private static ESTree.VariableDeclarator fromVariableDeclaratorType(Node node) {
        VariableDeclarator variableDeclarator = node.getVariableDeclarator();
        return new ESTree.VariableDeclarator(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(variableDeclarator.getId(), ESTree.Pattern.class), variableDeclarator.hasInit() ? Optional.of(ESTreeFactory.from(variableDeclarator.getInit(), ESTree.Expression.class)) : Optional.empty());
    }

    private static ESTree.ImportDeclaration fromImportDeclarationType(Node node) {
        ImportDeclaration importDeclaration = node.getImportDeclaration();
        return new ESTree.ImportDeclaration(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(importDeclaration.getSpecifiersList(), ESTree.ImportDefaultSpecifierOrImportNamespaceSpecifierOrImportSpecifier.class), ESTreeFactory.from(importDeclaration.getSource(), ESTree.Literal.class));
    }

    private static ESTree.ImportNamespaceSpecifier fromImportNamespaceSpecifierType(Node node) {
        ImportNamespaceSpecifier importNamespaceSpecifier = node.getImportNamespaceSpecifier();
        return new ESTree.ImportNamespaceSpecifier(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(importNamespaceSpecifier.getLocal(), ESTree.Identifier.class));
    }

    private static ESTree.ImportDefaultSpecifier fromImportDefaultSpecifierType(Node node) {
        ImportDefaultSpecifier importDefaultSpecifier = node.getImportDefaultSpecifier();
        return new ESTree.ImportDefaultSpecifier(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(importDefaultSpecifier.getLocal(), ESTree.Identifier.class));
    }

    private static ESTree.ImportSpecifier fromImportSpecifierType(Node node) {
        ImportSpecifier importSpecifier = node.getImportSpecifier();
        return new ESTree.ImportSpecifier(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(importSpecifier.getImported(), ESTree.Identifier.class), ESTreeFactory.from(importSpecifier.getLocal(), ESTree.Identifier.class));
    }

    private static ESTree.ForOfStatement fromForOfStatementType(Node node) {
        ForOfStatement forOfStatement = node.getForOfStatement();
        return new ESTree.ForOfStatement(ESTreeFactory.fromLocation(node.getLoc()), forOfStatement.getAwait(), ESTreeFactory.from(forOfStatement.getLeft(), ESTree.PatternOrVariableDeclaration.class), ESTreeFactory.from(forOfStatement.getRight(), ESTree.Expression.class), ESTreeFactory.from(forOfStatement.getBody(), ESTree.Statement.class));
    }

    private static ESTree.ForInStatement fromForInStatementType(Node node) {
        ForInStatement forInStatement = node.getForInStatement();
        return new ESTree.ForInStatement(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(forInStatement.getLeft(), ESTree.PatternOrVariableDeclaration.class), ESTreeFactory.from(forInStatement.getRight(), ESTree.Expression.class), ESTreeFactory.from(forInStatement.getBody(), ESTree.Statement.class));
    }

    private static ESTree.ForStatement fromForStatementType(Node node) {
        ForStatement forStatement = node.getForStatement();
        return new ESTree.ForStatement(ESTreeFactory.fromLocation(node.getLoc()), forStatement.hasInit() ? Optional.of(ESTreeFactory.from(forStatement.getInit(), ESTree.ExpressionOrVariableDeclaration.class)) : Optional.empty(), forStatement.hasTest() ? Optional.of(ESTreeFactory.from(forStatement.getTest(), ESTree.Expression.class)) : Optional.empty(), forStatement.hasUpdate() ? Optional.of(ESTreeFactory.from(forStatement.getUpdate(), ESTree.Expression.class)) : Optional.empty(), ESTreeFactory.from(forStatement.getBody(), ESTree.Statement.class));
    }

    private static ESTree.DoWhileStatement fromDoWhileStatementType(Node node) {
        DoWhileStatement doWhileStatement = node.getDoWhileStatement();
        return new ESTree.DoWhileStatement(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(doWhileStatement.getBody(), ESTree.Statement.class), ESTreeFactory.from(doWhileStatement.getTest(), ESTree.Expression.class));
    }

    private static ESTree.WhileStatement fromWhileStatementType(Node node) {
        WhileStatement whileStatement = node.getWhileStatement();
        return new ESTree.WhileStatement(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(whileStatement.getTest(), ESTree.Expression.class), ESTreeFactory.from(whileStatement.getBody(), ESTree.Statement.class));
    }

    private static ESTree.TryStatement fromTryStatementType(Node node) {
        TryStatement tryStatement = node.getTryStatement();
        return new ESTree.TryStatement(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(tryStatement.getBlock(), ESTree.BlockStatement.class), tryStatement.hasHandler() ? Optional.of(ESTreeFactory.from(tryStatement.getHandler(), ESTree.CatchClause.class)) : Optional.empty(), tryStatement.hasFinalizer() ? Optional.of(ESTreeFactory.from(tryStatement.getFinalizer(), ESTree.BlockStatement.class)) : Optional.empty());
    }

    private static ESTree.CatchClause fromCatchClauseType(Node node) {
        CatchClause catchClause = node.getCatchClause();
        return new ESTree.CatchClause(ESTreeFactory.fromLocation(node.getLoc()), catchClause.hasParam() ? Optional.of(ESTreeFactory.from(catchClause.getParam(), ESTree.Pattern.class)) : Optional.empty(), ESTreeFactory.from(catchClause.getBody(), ESTree.BlockStatement.class));
    }

    private static ESTree.ThrowStatement fromThrowStatementType(Node node) {
        ThrowStatement throwStatement = node.getThrowStatement();
        return new ESTree.ThrowStatement(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(throwStatement.getArgument(), ESTree.Expression.class));
    }

    private static ESTree.SwitchStatement fromSwitchStatementType(Node node) {
        SwitchStatement switchStatement = node.getSwitchStatement();
        return new ESTree.SwitchStatement(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(switchStatement.getDiscriminant(), ESTree.Expression.class), ESTreeFactory.from(switchStatement.getCasesList(), ESTree.SwitchCase.class));
    }

    private static ESTree.SwitchCase fromSwitchCaseType(Node node) {
        SwitchCase switchCase = node.getSwitchCase();
        return new ESTree.SwitchCase(ESTreeFactory.fromLocation(node.getLoc()), switchCase.hasTest() ? Optional.of(ESTreeFactory.from(switchCase.getTest(), ESTree.Expression.class)) : Optional.empty(), ESTreeFactory.from(switchCase.getConsequentList(), ESTree.Statement.class));
    }

    private static ESTree.IfStatement fromIfStatementType(Node node) {
        IfStatement ifStatement = node.getIfStatement();
        return new ESTree.IfStatement(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(ifStatement.getTest(), ESTree.Expression.class), ESTreeFactory.from(ifStatement.getConsequent(), ESTree.Statement.class), ifStatement.hasAlternate() ? Optional.of(ESTreeFactory.from(ifStatement.getAlternate(), ESTree.Statement.class)) : Optional.empty());
    }

    private static ESTree.ContinueStatement fromContinueStatementType(Node node) {
        ContinueStatement continueStatement = node.getContinueStatement();
        return new ESTree.ContinueStatement(ESTreeFactory.fromLocation(node.getLoc()), continueStatement.hasLabel() ? Optional.of(ESTreeFactory.from(continueStatement.getLabel(), ESTree.Identifier.class)) : Optional.empty());
    }

    private static ESTree.BreakStatement fromBreakStatementType(Node node) {
        BreakStatement breakStatement = node.getBreakStatement();
        return new ESTree.BreakStatement(ESTreeFactory.fromLocation(node.getLoc()), breakStatement.hasLabel() ? Optional.of(ESTreeFactory.from(breakStatement.getLabel(), ESTree.Identifier.class)) : Optional.empty());
    }

    private static ESTree.LabeledStatement fromLabeledStatementType(Node node) {
        LabeledStatement labeledStatement = node.getLabeledStatement();
        return new ESTree.LabeledStatement(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(labeledStatement.getLabel(), ESTree.Identifier.class), ESTreeFactory.from(labeledStatement.getBody(), ESTree.Statement.class));
    }

    private static ESTree.ReturnStatement fromReturnStatementType(Node node) {
        ReturnStatement returnStatement = node.getReturnStatement();
        return new ESTree.ReturnStatement(ESTreeFactory.fromLocation(node.getLoc()), returnStatement.hasArgument() ? Optional.of(ESTreeFactory.from(returnStatement.getArgument(), ESTree.Expression.class)) : Optional.empty());
    }

    private static ESTree.WithStatement fromWithStatementType(Node node) {
        WithStatement withStatement = node.getWithStatement();
        return new ESTree.WithStatement(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(withStatement.getObject(), ESTree.Expression.class), ESTreeFactory.from(withStatement.getBody(), ESTree.Statement.class));
    }

    private static ESTree.DebuggerStatement fromDebuggerStatementType(Node node) {
        return new ESTree.DebuggerStatement(ESTreeFactory.fromLocation(node.getLoc()));
    }

    private static ESTree.EmptyStatement fromEmptyStatementType(Node node) {
        return new ESTree.EmptyStatement(ESTreeFactory.fromLocation(node.getLoc()));
    }

    private static ESTree.ExpressionStatement fromExpressionStatementType(Node node) {
        ExpressionStatement expressionStatement = node.getExpressionStatement();
        return new ESTree.ExpressionStatement(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(expressionStatement.getExpression(), ESTree.Expression.class));
    }

    private static ESTree.Directive fromDirective(Node node) {
        ExpressionStatement directive = node.getExpressionStatement();
        return new ESTree.Directive(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(directive.getExpression(), ESTree.Literal.class), directive.getDirective());
    }

    private static ESTree.Literal fromLiteralType(Node node) {
        Literal literal = node.getLiteral();
        if (literal.hasBigint()) {
            return new ESTree.BigIntLiteral(ESTreeFactory.fromLocation(node.getLoc()), new BigInteger(literal.getBigint()), literal.getBigint(), literal.getRaw());
        }
        if (literal.hasPattern()) {
            return new ESTree.RegExpLiteral(ESTreeFactory.fromLocation(node.getLoc()), literal.getPattern(), literal.getFlags(), literal.getRaw());
        }
        if (literal.hasValueNumber()) {
            return new ESTree.SimpleLiteral(ESTreeFactory.fromLocation(node.getLoc()), literal.getValueNumber(), node.getLiteral().getRaw());
        }
        if (literal.hasValueBoolean()) {
            return new ESTree.SimpleLiteral(ESTreeFactory.fromLocation(node.getLoc()), literal.getValueBoolean(), node.getLiteral().getRaw());
        }
        return new ESTree.SimpleLiteral(ESTreeFactory.fromLocation(node.getLoc()), literal.getValueString(), node.getLiteral().getRaw());
    }

    private static ESTree.TemplateElement fromTemplateElementType(Node node) {
        TemplateElement templateElement = node.getTemplateElement();
        return new ESTree.TemplateElement(ESTreeFactory.fromLocation(node.getLoc()), templateElement.getTail(), templateElement.getCooked(), templateElement.getRaw());
    }

    private static ESTree.FunctionExpression fromFunctionExpressionType(Node node) {
        FunctionExpression functionExpression = node.getFunctionExpression();
        return new ESTree.FunctionExpression(ESTreeFactory.fromLocation(node.getLoc()), functionExpression.hasId() ? Optional.of(ESTreeFactory.from(functionExpression.getId(), ESTree.Identifier.class)) : Optional.empty(), ESTreeFactory.from(functionExpression.getBody(), ESTree.BlockStatement.class), ESTreeFactory.from(functionExpression.getParamsList(), ESTree.PatternOrTSParameterProperty.class), functionExpression.getGenerator(), functionExpression.getAsync());
    }

    private static ESTree.TSExternalModuleReference fromTSExternalModuleReferenceType(Node node) {
        TSExternalModuleReference tsExternalModuleReference = node.getTSExternalModuleReference();
        return new ESTree.TSExternalModuleReference(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(tsExternalModuleReference.getExpression(), ESTree.Literal.class));
    }

    private static ESTree.TSQualifiedName fromTSQualifiedName(Node node) {
        TSQualifiedName tsExternalModuleReference = node.getTSQualifiedName();
        return new ESTree.TSQualifiedName(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(tsExternalModuleReference.getLeft(), ESTree.IdentifierOrTSQualifiedName.class), ESTreeFactory.from(tsExternalModuleReference.getRight(), ESTree.Identifier.class));
    }

    private static ESTree.TSImportEqualsDeclaration fromTSImportEqualsDeclaration(Node node) {
        TSImportEqualsDeclaration tsImportEqualsDeclaration = node.getTSImportEqualsDeclaration();
        return new ESTree.TSImportEqualsDeclaration(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(tsImportEqualsDeclaration.getId(), ESTree.Identifier.class), ESTreeFactory.from(tsImportEqualsDeclaration.getModuleReference(), ESTree.IdentifierOrTSQualifiedNameOrTSExternalModuleReference.class), tsImportEqualsDeclaration.getImportKind());
    }

    private static ESTree.TSModuleBlock fromTSModuleBlock(Node node) {
        return new ESTree.TSModuleBlock(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(node.getTSModuleBlock().getBodyList(), ESTree.DirectiveOrModuleDeclarationOrStatement.class));
    }

    private static ESTree.TSModuleDeclaration fromTSModuleDeclaration(Node node) {
        TSModuleDeclaration tsModuleDeclaration = node.getTSModuleDeclaration();
        return new ESTree.TSModuleDeclaration(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(tsModuleDeclaration.getId(), ESTree.IdentifierOrLiteralOrTSQualifiedName.class), tsModuleDeclaration.hasBody() ? Optional.of(ESTreeFactory.from(tsModuleDeclaration.getBody(), ESTree.TSModuleBlock.class)) : Optional.empty(), tsModuleDeclaration.getKind());
    }

    private static ESTree.TSParameterProperty fromTSParameterProperty(Node node) {
        TSParameterProperty tsParameterProperty = node.getTSParameterProperty();
        return new ESTree.TSParameterProperty(ESTreeFactory.fromLocation(node.getLoc()), tsParameterProperty.hasAccessibility() ? Optional.of(tsParameterProperty.getAccessibility()) : Optional.empty(), tsParameterProperty.getReadonly(), ESTreeFactory.from(tsParameterProperty.getParameter(), ESTree.Pattern.class));
    }

    private static ESTree.TSAbstractMethodDefinition fromTSAbstractMethodDefinition(Node node) {
        return new ESTree.TSAbstractMethodDefinition(ESTreeFactory.fromLocation(node.getLoc()));
    }

    private static ESTree.TSDeclareFunction fromTSDeclareFunction(Node node) {
        return new ESTree.TSDeclareFunction(ESTreeFactory.fromLocation(node.getLoc()));
    }

    private static ESTree.TSInterfaceDeclaration fromTSInterfaceDeclaration(Node node) {
        return new ESTree.TSInterfaceDeclaration(ESTreeFactory.fromLocation(node.getLoc()));
    }

    private static ESTree.TSEnumDeclaration fromTSEnumDeclaration(Node node) {
        return new ESTree.TSEnumDeclaration(ESTreeFactory.fromLocation(node.getLoc()));
    }

    private static ESTree.TSTypeAliasDeclaration fromTSTypeAliasDeclaration(Node node) {
        return new ESTree.TSTypeAliasDeclaration(ESTreeFactory.fromLocation(node.getLoc()));
    }

    private static ESTree.TSEmptyBodyFunctionExpression fromTSEmptyBodyFunctionExpression(Node node) {
        return new ESTree.TSEmptyBodyFunctionExpression(ESTreeFactory.fromLocation(node.getLoc()));
    }

    private static ESTree.TSTypeParameterInstantiation fromTSTypeParameterInstantiation(Node node) {
        return new ESTree.TSTypeParameterInstantiation(ESTreeFactory.fromLocation(node.getLoc()));
    }

    private static ESTree.JSXElement fromJSXElement(Node node) {
        JSXElement jsxElement = node.getJSXElement();
        return new ESTree.JSXElement(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(jsxElement.getOpeningElement(), ESTree.JSXOpeningElement.class), jsxElement.hasClosingElement() ? Optional.of(ESTreeFactory.from(jsxElement.getClosingElement(), ESTree.JSXClosingElement.class)) : Optional.empty(), ESTreeFactory.from(jsxElement.getChildrenList(), ESTree.JSXChild.class));
    }

    private static ESTree.JSXFragment fromJSXFragment(Node node) {
        JSXFragment jsxFragment = node.getJSXFragment();
        return new ESTree.JSXFragment(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(jsxFragment.getOpeningFragment(), ESTree.JSXOpeningFragment.class), ESTreeFactory.from(jsxFragment.getClosingFragment(), ESTree.JSXClosingFragment.class), ESTreeFactory.from(jsxFragment.getChildrenList(), ESTree.JSXChild.class));
    }

    private static ESTree.JSXOpeningElement fromJSXOpeningElement(Node node) {
        JSXOpeningElement jsxOpeningElement = node.getJSXOpeningElement();
        return new ESTree.JSXOpeningElement(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(jsxOpeningElement.getName(), ESTree.JSXTagNameExpression.class), ESTreeFactory.from(jsxOpeningElement.getAttributesList(), ESTree.JSXOpeningElementAttribute.class), jsxOpeningElement.getSelfClosing(), jsxOpeningElement.hasTypeArguments() ? Optional.of(ESTreeFactory.from(jsxOpeningElement.getTypeArguments(), ESTree.TSTypeParameterInstantiation.class)) : Optional.empty());
    }

    private static ESTree.JSXClosingElement fromJSXClosingElement(Node node) {
        JSXClosingElement jsxClosingElement = node.getJSXClosingElement();
        return new ESTree.JSXClosingElement(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(jsxClosingElement.getName(), ESTree.JSXTagNameExpression.class));
    }

    private static ESTree.JSXOpeningFragment fromJSXOpeningFragment(Node node) {
        return new ESTree.JSXOpeningFragment(ESTreeFactory.fromLocation(node.getLoc()));
    }

    private static ESTree.JSXClosingFragment fromJSXClosingFragment(Node node) {
        return new ESTree.JSXClosingFragment(ESTreeFactory.fromLocation(node.getLoc()));
    }

    private static ESTree.JSXAttribute fromJSXAttribute(Node node) {
        JSXAttribute jsxAttribute = node.getJSXAttribute();
        return new ESTree.JSXAttribute(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(jsxAttribute.getName(), ESTree.JSXAttributeName.class), jsxAttribute.hasValue() ? Optional.of(ESTreeFactory.from(jsxAttribute.getValue(), ESTree.JSXAttributeValue.class)) : Optional.empty());
    }

    private static ESTree.JSXIdentifier fromJSXIdentifier(Node node) {
        JSXIdentifier jsxIdentifier = node.getJSXIdentifier();
        return new ESTree.JSXIdentifier(ESTreeFactory.fromLocation(node.getLoc()), jsxIdentifier.getName());
    }

    private static ESTree.JSXMemberExpression fromJSXMemberExpression(Node node) {
        JSXMemberExpression jsxMemberExpression = node.getJSXMemberExpression();
        return new ESTree.JSXMemberExpression(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(jsxMemberExpression.getObject(), ESTree.JSXTagNameExpression.class), ESTreeFactory.from(jsxMemberExpression.getProperty(), ESTree.JSXIdentifier.class));
    }

    private static ESTree.JSXNamespacedName fromJSXNamespacedName(Node node) {
        JSXNamespacedName jsxNamespacedName = node.getJSXNamespacedName();
        return new ESTree.JSXNamespacedName(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(jsxNamespacedName.getName(), ESTree.JSXIdentifier.class), ESTreeFactory.from(jsxNamespacedName.getNamespace(), ESTree.JSXIdentifier.class));
    }

    private static ESTree.JSXSpreadAttribute fromJSXSpreadAttribute(Node node) {
        JSXSpreadAttribute jsxSpreadAttribute = node.getJSXSpreadAttribute();
        return new ESTree.JSXSpreadAttribute(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(jsxSpreadAttribute.getArgument(), ESTree.Expression.class));
    }

    private static ESTree.JSXExpressionContainer fromJSXExpressionContainer(Node node) {
        JSXExpressionContainer jsxExpressionContainer = node.getJSXExpressionContainer();
        return new ESTree.JSXExpressionContainer(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(jsxExpressionContainer.getExpression(), ESTree.ExpressionOrJSXEmptyExpression.class));
    }

    private static ESTree.JSXSpreadChild fromJSXSpreadChild(Node node) {
        JSXSpreadChild jsxSpreadChild = node.getJSXSpreadChild();
        return new ESTree.JSXSpreadChild(ESTreeFactory.fromLocation(node.getLoc()), ESTreeFactory.from(jsxSpreadChild.getExpression(), ESTree.ExpressionOrJSXEmptyExpression.class));
    }

    private static ESTree.JSXText fromJSXText(Node node) {
        JSXText jsxText = node.getJSXText();
        return new ESTree.JSXText(ESTreeFactory.fromLocation(node.getLoc()), jsxText.getRaw(), jsxText.getValue());
    }

    private static ESTree.JSXEmptyExpression fromJSXEmptyExpression(Node node) {
        return new ESTree.JSXEmptyExpression(ESTreeFactory.fromLocation(node.getLoc()));
    }

    private static ESTree.UnknownNode fromUnknownNodeType(Node node) {
        return new ESTree.UnknownNode(ESTreeFactory.fromLocation(node.getLoc()));
    }
}

