/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.bridge;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;

class BundleUtils {
    private BundleUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void extractFromClasspath(InputStream resource, Path targetPath) throws IOException {
        Objects.requireNonNull(resource);
        try (GZIPInputStream stream = new GZIPInputStream(new BufferedInputStream(resource));
             TarArchiveInputStream archive = new TarArchiveInputStream(stream);){
            Object entry;
            while ((entry = archive.getNextEntry()) != null) {
                if (!((ArchiveInputStream)archive).canReadEntryData((ArchiveEntry)entry)) {
                    throw new IllegalStateException("Failed to extract bundle");
                }
                Path entryFile = BundleUtils.entryPath(targetPath, entry);
                if (entry.isDirectory()) {
                    Files.createDirectories(entryFile, new FileAttribute[0]);
                    continue;
                }
                Path parent = entryFile.getParent();
                Files.createDirectories(parent, new FileAttribute[0]);
                OutputStream os = Files.newOutputStream(entryFile, new OpenOption[0]);
                try {
                    IOUtils.copy(archive, os);
                }
                finally {
                    if (os == null) continue;
                    os.close();
                }
            }
            return;
        }
    }

    private static Path entryPath(Path targetPath, ArchiveEntry entry) {
        Path entryPath = targetPath.resolve(entry.getName()).normalize();
        if (!entryPath.startsWith(targetPath)) {
            throw new IllegalStateException("Archive entry " + entry.getName() + " is not within " + String.valueOf(targetPath));
        }
        return entryPath;
    }
}

