/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.bridge;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.plugins.javascript.bridge.Bundle;
import org.sonar.plugins.javascript.bridge.BundleUtils;
import org.sonarsource.api.sonarlint.SonarLintSide;

@ScannerSide
@SonarLintSide(lifespan="INSTANCE")
public class BundleImpl
implements Bundle {
    private static final Logger LOG = LoggerFactory.getLogger(BundleImpl.class);
    private static final String BUNDLE_LOCATION = "/sonarjs-1.0.0.tgz";
    public static final String DEFAULT_STARTUP_SCRIPT = "package/bin/server.cjs";
    private Path deployLocation;
    private final String bundleLocation;

    public BundleImpl() {
        this(BUNDLE_LOCATION);
    }

    BundleImpl(String bundleLocation) {
        this.bundleLocation = bundleLocation;
    }

    @Override
    public void setDeployLocation(Path deployLocation) {
        LOG.debug("Setting deploy location to {}", (Object)deployLocation);
        this.deployLocation = deployLocation;
    }

    @Override
    public void deploy(Path deployLocation) throws IOException {
        LOG.debug("Deploying the bridge server into {}", (Object)deployLocation);
        InputStream bundle = this.getClass().getResourceAsStream(this.bundleLocation);
        if (bundle == null) {
            throw new IllegalStateException("The bridge server was not found in the plugin jar");
        }
        BundleUtils.extractFromClasspath(bundle, deployLocation);
        this.setDeployLocation(deployLocation);
    }

    @Override
    public String startServerScript() {
        return this.resolve(DEFAULT_STARTUP_SCRIPT);
    }

    @Override
    public String resolve(String relativePath) {
        return this.deployLocation.resolve(relativePath).toAbsolutePath().toString();
    }
}

