/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.bridge;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.SonarProduct;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.TempFolder;
import org.sonar.plugins.javascript.bridge.BridgeServer;
import org.sonar.plugins.javascript.bridge.BridgeServerConfig;
import org.sonar.plugins.javascript.bridge.Bundle;
import org.sonar.plugins.javascript.bridge.EmbeddedNode;
import org.sonar.plugins.javascript.bridge.EslintRule;
import org.sonar.plugins.javascript.bridge.Http;
import org.sonar.plugins.javascript.bridge.JSWebSocketClient;
import org.sonar.plugins.javascript.bridge.NetUtils;
import org.sonar.plugins.javascript.bridge.NodeDeprecationWarning;
import org.sonar.plugins.javascript.bridge.RulesBundles;
import org.sonar.plugins.javascript.bridge.ServerAlreadyFailedException;
import org.sonar.plugins.javascript.bridge.WebSocketMessageHandler;
import org.sonar.plugins.javascript.nodejs.NodeCommand;
import org.sonar.plugins.javascript.nodejs.NodeCommandBuilder;
import org.sonar.plugins.javascript.nodejs.NodeCommandException;

public class BridgeServerImpl
implements BridgeServer {
    private static final Logger LOG = LoggerFactory.getLogger(BridgeServerImpl.class);
    private static final int DEFAULT_TIMEOUT_SECONDS = 300;
    private static final int TIME_AFTER_FAILURE_TO_RESTART_MS = 60000;
    private static final String MAX_OLD_SPACE_SIZE_PROPERTY = "sonar.javascript.node.maxspace";
    private static final String DEBUG_MEMORY = "sonar.javascript.node.debugMemory";
    public static final String SONARLINT_BUNDLE_PATH = "sonar.js.internal.bundlePath";
    public static final int DEFAULT_NODE_SHUTDOWN_TIMEOUT_MS = 15000;
    public static final String NODE_TIMEOUT_PROPERTY = "sonar.javascript.node.timeout";
    public static final String SONARJS_EXISTING_NODE_PROCESS_PORT = "SONARJS_EXISTING_NODE_PROCESS_PORT";
    private static final Gson GSON = new Gson();
    private static final String BRIDGE_DEPLOY_LOCATION = "bridge-bundle";
    private final NodeCommandBuilder nodeCommandBuilder;
    private final int timeoutSeconds;
    private final Bundle bundle;
    private final String hostAddress;
    private int port;
    private NodeCommand nodeCommand;
    private Status status = Status.NOT_STARTED;
    private final RulesBundles rulesBundles;
    private List<Path> deployedBundles = Collections.emptyList();
    private String workdir;
    private final NodeDeprecationWarning deprecationWarning;
    private final Path temporaryDeployLocation;
    private final EmbeddedNode embeddedNode;
    private static final int HEARTBEAT_INTERVAL_SECONDS = 5;
    private final ScheduledExecutorService heartbeatService;
    private ScheduledFuture<?> heartbeatFuture;
    private final Http http;
    private Long latestOKIsAliveTimestamp;
    private JSWebSocketClient client;

    public BridgeServerImpl(NodeCommandBuilder nodeCommandBuilder, Bundle bundle, RulesBundles rulesBundles, NodeDeprecationWarning deprecationWarning, TempFolder tempFolder, EmbeddedNode embeddedNode) {
        this(nodeCommandBuilder, 300, bundle, rulesBundles, deprecationWarning, tempFolder, embeddedNode);
    }

    BridgeServerImpl(NodeCommandBuilder nodeCommandBuilder, int timeoutSeconds, Bundle bundle, RulesBundles rulesBundles, NodeDeprecationWarning deprecationWarning, TempFolder tempFolder, EmbeddedNode embeddedNode) {
        this(nodeCommandBuilder, timeoutSeconds, bundle, rulesBundles, deprecationWarning, tempFolder, embeddedNode, Http.getJdkHttpClient());
    }

    public BridgeServerImpl(NodeCommandBuilder nodeCommandBuilder, int timeoutSeconds, Bundle bundle, RulesBundles rulesBundles, NodeDeprecationWarning deprecationWarning, TempFolder tempFolder, EmbeddedNode embeddedNode, Http http) {
        this.nodeCommandBuilder = nodeCommandBuilder;
        this.timeoutSeconds = timeoutSeconds;
        this.bundle = bundle;
        this.rulesBundles = rulesBundles;
        this.deprecationWarning = deprecationWarning;
        this.hostAddress = InetAddress.getLoopbackAddress().getHostAddress();
        this.temporaryDeployLocation = tempFolder.newDir(BRIDGE_DEPLOY_LOCATION).toPath();
        this.heartbeatService = Executors.newSingleThreadScheduledExecutor();
        this.embeddedNode = embeddedNode;
        this.http = http;
    }

    void heartbeat() {
        LOG.trace("Pinging the bridge server");
        this.isAlive();
    }

    void serverHasStarted() {
        this.status = Status.STARTED;
        if (this.heartbeatFuture == null) {
            LOG.trace("Starting heartbeat service");
            this.heartbeatFuture = this.heartbeatService.scheduleAtFixedRate(this::heartbeat, 5L, 5L, TimeUnit.SECONDS);
        }
    }

    int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    void deploy(Configuration configuration) throws IOException {
        Optional bundlePath = configuration.get(SONARLINT_BUNDLE_PATH);
        if (bundlePath.isPresent()) {
            this.bundle.setDeployLocation(Path.of((String)bundlePath.get(), new String[0]));
        } else {
            this.bundle.deploy(this.temporaryDeployLocation);
        }
        if (configuration.get("sonar.nodejs.executable").isPresent() || configuration.getBoolean("sonar.scanner.skipNodeProvisioning").orElse(false).booleanValue() || configuration.getBoolean("sonar.nodejs.forceHost").orElse(false).booleanValue()) {
            String property = configuration.get("sonar.nodejs.executable").isPresent() ? "sonar.nodejs.executable" : (configuration.get("sonar.scanner.skipNodeProvisioning").isPresent() ? "sonar.scanner.skipNodeProvisioning" : "sonar.nodejs.forceHost");
            LOG.info("'{}' is set. Skipping embedded Node.js runtime deployment.", (Object)property);
            return;
        }
        this.embeddedNode.deploy();
    }

    void startServer(BridgeServerConfig serverConfig) throws IOException {
        LOG.debug("Starting server");
        long start = System.currentTimeMillis();
        this.port = NetUtils.findOpenPort();
        File scriptFile = new File(this.bundle.startServerScript());
        if (!scriptFile.exists()) {
            throw new NodeCommandException("Node.js script to start the bridge server doesn't exist: " + scriptFile.getAbsolutePath());
        }
        LOG.debug("Creating Node.js process to start the bridge server on port {} ", (Object)this.port);
        this.nodeCommand = this.initNodeCommand(serverConfig, scriptFile);
        this.nodeCommand.start();
        if (!this.waitServerToStart(this.timeoutSeconds * 1000)) {
            this.status = Status.FAILED;
            throw new NodeCommandException("Failed to start the bridge server (" + this.timeoutSeconds + "s timeout)");
        }
        this.serverHasStarted();
        long duration = System.currentTimeMillis() - start;
        LOG.debug("Bridge server started on port {} in {} ms", (Object)this.port, (Object)duration);
        this.establishWebSocketConnection();
        this.deprecationWarning.logNodeDeprecation(this.nodeCommand.getActualNodeVersion());
    }

    void establishWebSocketConnection() {
        if (this.client != null && this.client.isOpen()) {
            LOG.debug("WebSocket connection already established");
            return;
        }
        try {
            this.client = new JSWebSocketClient(this.wsUrl());
            this.client.connectBlocking();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    boolean waitServerToStart(int timeoutMs) {
        int sleepStep = 100;
        long start = System.currentTimeMillis();
        try {
            Thread.sleep(sleepStep);
            while (!this.isAlive()) {
                if (System.currentTimeMillis() - start > (long)timeoutMs) {
                    return false;
                }
                Thread.sleep(sleepStep);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return true;
    }

    private NodeCommand initNodeCommand(BridgeServerConfig serverConfig, File scriptFile) throws IOException {
        Configuration config = serverConfig.config();
        if (serverConfig.product() == SonarProduct.SONARLINT) {
            LOG.info("Running in SonarLint context, metrics will not be computed.");
        }
        Boolean debugMemory = config.getBoolean(DEBUG_MEMORY).orElse(false);
        Integer nodeTimeout = config.getInt(NODE_TIMEOUT_PROPERTY).orElse(15000);
        this.nodeCommandBuilder.outputConsumer(new LogOutputConsumer()).errorConsumer(LOG::error).embeddedNode(this.embeddedNode).pathResolver(this.bundle).minNodeVersion(NodeDeprecationWarning.MIN_SUPPORTED_NODE_VERSION).configuration(serverConfig.config()).script(scriptFile.getAbsolutePath()).scriptArgs(String.valueOf(this.port), this.hostAddress, String.valueOf(debugMemory), String.valueOf(nodeTimeout)).env(BridgeServerImpl.getEnv());
        serverConfig.config().getInt(MAX_OLD_SPACE_SIZE_PROPERTY).ifPresent(this.nodeCommandBuilder::maxOldSpaceSize);
        return this.nodeCommandBuilder.build();
    }

    private static Map<String, String> getEnv() {
        HashMap<String, String> env = new HashMap<String, String>();
        if (LOG.isDebugEnabled()) {
            env.put("TIMING", "all");
        }
        env.put("BROWSERSLIST_IGNORE_OLD_DATA", "true");
        return env;
    }

    @Override
    public void startServerLazily(BridgeServerConfig serverConfig) throws IOException {
        int providedPort;
        if (this.status == Status.FAILED) {
            if (this.shouldRestartFailedServer()) {
                this.status = Status.NOT_STARTED;
            } else {
                throw new ServerAlreadyFailedException();
            }
        }
        if ((providedPort = this.nodeAlreadyRunningPort()) != 0) {
            this.port = providedPort;
            this.serverHasStarted();
            LOG.info("Using existing Node.js process on port {}", (Object)this.port);
            this.establishWebSocketConnection();
        }
        this.workdir = serverConfig.workDirAbsolutePath();
        Files.createDirectories(this.temporaryDeployLocation.resolve("package"), new FileAttribute[0]);
        this.deployedBundles = this.rulesBundles.deploy(this.temporaryDeployLocation.resolve("package"));
        try {
            if (this.isAlive()) {
                LOG.debug("The bridge server is up, no need to start.");
                return;
            }
            if (this.status == Status.STARTED) {
                this.status = Status.FAILED;
                throw new ServerAlreadyFailedException();
            }
            this.deploy(serverConfig.config());
            this.startServer(serverConfig);
        }
        catch (NodeCommandException e) {
            this.status = Status.FAILED;
            throw e;
        }
    }

    @Override
    public void initLinter(List<EslintRule> rules, List<String> environments, List<String> globals, String baseDir, boolean sonarlint) {
        BridgeServer.InitLinterRequest initLinterRequest = new BridgeServer.InitLinterRequest(rules, environments, globals, baseDir, sonarlint, this.deployedBundles.stream().map(Path::toString).toList(), this.workdir);
        String request = GSON.toJson(initLinterRequest);
        String response = BridgeServerImpl.textResponse(this.request(request, "init-linter"));
        if (!"OK".equals(response)) {
            throw new IllegalStateException("Failed to initialize linter");
        }
    }

    private static String textResponse(BridgeServer.BridgeResponse response) {
        BufferedReader bufferedReader = new BufferedReader(response.reader());
        return bufferedReader.lines().collect(Collectors.joining());
    }

    @Override
    public BridgeServer.AnalysisResponse analyzeJsTs(BridgeServer.JsAnalysisRequest request) throws IOException {
        String json = GSON.toJson(request);
        return BridgeServerImpl.response(this.request(json, "analyze-jsts"), request.filePath());
    }

    @Override
    public BridgeServer.AnalysisResponse analyzeCss(BridgeServer.CssAnalysisRequest request) {
        String json = GSON.toJson(request);
        return BridgeServerImpl.response(this.request(json, "analyze-css"), request.filePath());
    }

    @Override
    public BridgeServer.AnalysisResponse analyzeYaml(BridgeServer.JsAnalysisRequest request) {
        String json = GSON.toJson(request);
        return BridgeServerImpl.response(this.request(json, "analyze-yaml"), request.filePath());
    }

    @Override
    public BridgeServer.AnalysisResponse analyzeHtml(BridgeServer.JsAnalysisRequest request) {
        String json = GSON.toJson(request);
        return BridgeServerImpl.response(this.request(json, "analyze-html"), request.filePath());
    }

    @Override
    public void analyzeProject(WebSocketMessageHandler<BridgeServer.ProjectAnalysisRequest> handler) {
        this.client.registerHandler(handler);
        BridgeServer.ProjectAnalysisRequest request = handler.getRequest();
        request.setBundles(this.deployedBundles.stream().map(Path::toString).toList());
        request.setRulesWorkdir(this.workdir);
        this.client.send(GSON.toJson(Map.of("type", "on-analyze-project", "data", request)));
        handler.getFuture().join();
    }

    private BridgeServer.BridgeResponse request(String json, String endpoint) {
        try {
            Http.Response response = this.http.post(json, this.url(endpoint), this.timeoutSeconds);
            InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(response.body()), StandardCharsets.UTF_8);
            return new BridgeServer.BridgeResponse(reader);
        }
        catch (IOException e) {
            throw new IllegalStateException("The bridge server is unresponsive. It might be because you don't have enough memory, so please go see the troubleshooting section: https://docs.sonarsource.com/sonarqube-server/latest/analyzing-source-code/languages/javascript-typescript-css/#slow-or-unresponsive-analysis", e);
        }
    }

    private static BridgeServer.AnalysisResponse response(BridgeServer.BridgeResponse result, String filePath) {
        try {
            return BridgeServer.AnalysisResponse.fromDTO(GSON.fromJson((Reader)result.reader(), BridgeServer.AnalysisResponseDTO.class));
        }
        catch (JsonSyntaxException e) {
            String msg = "Failed to parse response for file " + filePath + ": \n-----\n" + String.valueOf(result) + "\n-----\n";
            LOG.error(msg, e);
            throw new IllegalStateException("Failed to parse response", e);
        }
    }

    @Override
    public boolean isAlive() {
        if (this.nodeCommand == null && this.status != Status.STARTED) {
            return false;
        }
        try {
            String res = this.http.get(this.url("status"));
            boolean result = "OK".equals(res);
            if (result) {
                this.latestOKIsAliveTimestamp = System.currentTimeMillis();
            }
            return result;
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean shouldRestartFailedServer() {
        return this.latestOKIsAliveTimestamp != null && System.currentTimeMillis() - this.latestOKIsAliveTimestamp > 60000L;
    }

    @Override
    public BridgeServer.TelemetryData getTelemetry() {
        if (this.nodeCommand == null) {
            return new BridgeServer.TelemetryData(null);
        }
        return new BridgeServer.TelemetryData(new BridgeServer.RuntimeTelemetry(this.nodeCommand.getActualNodeVersion(), this.nodeCommand.getNodeExecutableOrigin()));
    }

    @Override
    public void clean() {
        this.heartbeatService.shutdownNow();
        if (this.nodeCommand != null && this.isAlive()) {
            this.request("", "close");
            this.nodeCommand.waitFor();
            this.nodeCommand = null;
        }
        this.port = 0;
        this.status = Status.NOT_STARTED;
    }

    void waitFor() {
        this.nodeCommand.waitFor();
    }

    @Override
    public String getCommandInfo() {
        if (this.nodeCommand == null) {
            return "Node.js command to start the bridge server was not built yet.";
        }
        return "Node.js command to start the bridge server was: " + String.valueOf(this.nodeCommand);
    }

    public void start() {
    }

    public void stop() {
        this.clean();
    }

    private URI wsUrl() {
        try {
            return new URI("ws", null, this.hostAddress, this.port, "/ws", null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Invalid URI: " + e.getMessage(), e);
        }
    }

    private URI url(String endpoint) {
        try {
            return new URI("http", null, this.hostAddress, this.port, "/" + endpoint, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Invalid URI: " + e.getMessage(), e);
        }
    }

    int nodeAlreadyRunningPort() {
        try {
            int existingNodePort = Optional.ofNullable(this.getExistingNodeProcessPort()).map(Integer::parseInt).orElse(0);
            if (existingNodePort < 0 || existingNodePort > 65535) {
                throw new IllegalStateException("Node.js process port set in $SONARJS_EXISTING_NODE_PROCESS_PORT should be a number between 1 and 65535 range");
            }
            return existingNodePort;
        }
        catch (NumberFormatException nfe) {
            throw new IllegalStateException("Error parsing number in environment variable SONARJS_EXISTING_NODE_PROCESS_PORT", nfe);
        }
    }

    public String getExistingNodeProcessPort() {
        return System.getenv(SONARJS_EXISTING_NODE_PROCESS_PORT);
    }

    private static enum Status {
        NOT_STARTED,
        FAILED,
        STARTED;

    }

    static class LogOutputConsumer
    implements Consumer<String> {
        LogOutputConsumer() {
        }

        @Override
        public void accept(String message) {
            if (message.startsWith("DEBUG")) {
                LOG.debug(message.substring(5).trim());
            } else if (message.startsWith("WARN")) {
                LOG.warn(message.substring(4).trim());
            } else {
                LOG.info(message);
            }
        }
    }
}

