/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.bridge;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.Startable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.utils.Version;
import org.sonar.plugins.javascript.api.AnalysisMode;
import org.sonar.plugins.javascript.bridge.AnalysisConfiguration;
import org.sonar.plugins.javascript.bridge.AstProtoUtils;
import org.sonar.plugins.javascript.bridge.BridgeServerConfig;
import org.sonar.plugins.javascript.bridge.EslintRule;
import org.sonar.plugins.javascript.bridge.StylelintRule;
import org.sonar.plugins.javascript.bridge.WebSocketMessageHandler;
import org.sonar.plugins.javascript.bridge.protobuf.Node;
import org.sonarsource.api.sonarlint.SonarLintSide;

@ScannerSide
@SonarLintSide(lifespan="INSTANCE")
public interface BridgeServer
extends Startable {
    public void startServerLazily(BridgeServerConfig var1) throws IOException;

    public void initLinter(List<EslintRule> var1, List<String> var2, List<String> var3, String var4, boolean var5) throws IOException;

    public AnalysisResponse analyzeJsTs(JsAnalysisRequest var1) throws IOException;

    public AnalysisResponse analyzeCss(CssAnalysisRequest var1) throws IOException;

    public AnalysisResponse analyzeYaml(JsAnalysisRequest var1) throws IOException;

    public AnalysisResponse analyzeHtml(JsAnalysisRequest var1) throws IOException;

    public void clean() throws InterruptedException;

    public String getCommandInfo();

    public boolean isAlive();

    public TelemetryData getTelemetry();

    public void analyzeProject(WebSocketMessageHandler<ProjectAnalysisRequest> var1);

    public record RuntimeTelemetry(Version version, String nodeExecutableOrigin) {
    }

    public record TelemetryData(@Nullable RuntimeTelemetry runtimeTelemetry) {
    }

    public record CpdToken(Location location, String image) {
    }

    public record Metrics(List<Integer> ncloc, List<Integer> commentLines, List<Integer> nosonarLines, List<Integer> executableLines, int functions, int statements, int classes, int complexity, int cognitiveComplexity) {
        public Metrics() {
            this(List.of(), List.of(), List.of(), List.of(), 0, 0, 0, 0, 0);
        }
    }

    public record Location(int startLine, int startCol, int endLine, int endCol) {
        public TextRange toTextRange(InputFile inputFile) {
            return inputFile.newRange(this.startLine, this.startCol, this.endLine, this.endCol);
        }

        @Override
        public String toString() {
            return String.format("%d:%d-%d:%d", this.startLine, this.startCol, this.endLine, this.endCol);
        }
    }

    public record HighlightedSymbol(Location declaration, List<Location> references) {
    }

    public record Highlight(Location location, String textType) {
    }

    public record IssueLocation(Integer line, Integer column, Integer endLine, Integer endColumn, String message) {
    }

    public record QuickFixEdit(String text, IssueLocation loc) {
    }

    public record QuickFix(String message, List<QuickFixEdit> edits) {
    }

    public record Issue(Integer line, Integer column, Integer endLine, Integer endColumn, String message, String ruleId, String language, List<IssueLocation> secondaryLocations, Double cost, List<QuickFix> quickFixes, List<String> ruleESLintKeys, String filePath) {
    }

    public static enum ParsingErrorCode {
        PARSING,
        FAILING_TYPESCRIPT,
        GENERAL_ERROR;

    }

    public record ParsingError(String message, Integer line, ParsingErrorCode code) {
    }

    public record AnalysisResponse(@Nullable ParsingError parsingError, List<Issue> issues, List<Highlight> highlights, List<HighlightedSymbol> highlightedSymbols, Metrics metrics, List<CpdToken> cpdTokens, @Nullable Node ast) {
        public AnalysisResponse() {
            this(null, List.of(), List.of(), List.of(), new Metrics(), List.of(), null);
        }

        public AnalysisResponse(@Nullable ParsingError parsingError, @Nullable List<Issue> issues, @Nullable List<Highlight> highlights, @Nullable List<HighlightedSymbol> highlightedSymbols, @Nullable Metrics metrics, @Nullable List<CpdToken> cpdTokens, @Nullable Node ast) {
            this.parsingError = parsingError;
            this.issues = issues != null ? issues : List.of();
            this.highlights = highlights != null ? highlights : List.of();
            this.highlightedSymbols = highlightedSymbols != null ? highlightedSymbols : List.of();
            this.metrics = metrics != null ? metrics : new Metrics();
            this.cpdTokens = cpdTokens != null ? cpdTokens : List.of();
            this.ast = ast;
        }

        public static AnalysisResponse fromDTO(AnalysisResponseDTO analysisResponseDTO) {
            Node ast = null;
            if (analysisResponseDTO.ast != null) {
                try {
                    ast = AstProtoUtils.parseProtobuf(analysisResponseDTO.ast);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to parse protobuf", e);
                }
            }
            return new AnalysisResponse(analysisResponseDTO.parsingError, analysisResponseDTO.issues, analysisResponseDTO.highlights, analysisResponseDTO.highlightedSymbols, analysisResponseDTO.metrics, analysisResponseDTO.cpdTokens, ast);
        }
    }

    public record AnalysisResponseDTO(@Nullable ParsingError parsingError, List<Issue> issues, List<Highlight> highlights, List<HighlightedSymbol> highlightedSymbols, Metrics metrics, List<CpdToken> cpdTokens, @Nullable String ast) {
    }

    public record BridgeResponse(InputStreamReader reader) {
    }

    public record CssAnalysisRequest(String filePath, @Nullable String fileContent, List<StylelintRule> rules, @Nullable ProjectAnalysisConfiguration configuration) {
        public CssAnalysisRequest(String filePath, @Nullable String fileContent, List<StylelintRule> rules) {
            this(filePath, fileContent, rules, null);
        }
    }

    public record ProjectAnalysisMetaResponse(List<String> warnings) {
        public ProjectAnalysisMetaResponse() {
            this(List.of());
        }
    }

    public static class ProjectAnalysisConfiguration {
        String baseDir;
        boolean sonarlint;
        Map<String, String> fsEvents;
        boolean allowTsParserJsFiles;
        AnalysisMode analysisMode;
        Boolean skipAst;
        boolean ignoreHeaderComments;
        long maxFileSize;
        int maxFilesForTypeChecking;
        List<String> environments;
        List<String> globals;
        List<String> tsSuffixes;
        List<String> jsSuffixes;
        List<String> cssSuffixes;
        Set<String> tsConfigPaths;
        List<String> jsTsExclusions;
        List<String> sources;
        List<String> inclusions;
        List<String> exclusions;
        List<String> tests;
        List<String> testInclusions;
        List<String> testExclusions;
        boolean detectBundles;
        boolean canAccessFileSystem;

        public ProjectAnalysisConfiguration(String baseDir, AnalysisConfiguration analysisConfiguration) {
            this.baseDir = baseDir;
            this.sonarlint = analysisConfiguration.isSonarLint();
            this.fsEvents = Map.of();
            this.allowTsParserJsFiles = analysisConfiguration.allowTsParserJsFiles();
            this.analysisMode = analysisConfiguration.getAnalysisMode();
            this.skipAst = true;
            this.ignoreHeaderComments = analysisConfiguration.ignoreHeaderComments();
            this.maxFileSize = analysisConfiguration.getMaxFileSizeProperty();
            this.maxFilesForTypeChecking = analysisConfiguration.getTypeCheckingLimit();
            this.environments = analysisConfiguration.getEnvironments();
            this.globals = analysisConfiguration.getGlobals();
            this.tsSuffixes = analysisConfiguration.getTsExtensions();
            this.jsSuffixes = analysisConfiguration.getJsExtensions();
            this.cssSuffixes = analysisConfiguration.getCssExtensions();
            this.tsConfigPaths = analysisConfiguration.getTsConfigPaths();
            this.jsTsExclusions = analysisConfiguration.getJsTsExcludedPaths();
            this.detectBundles = analysisConfiguration.shouldDetectBundles();
            this.canAccessFileSystem = analysisConfiguration.canAccessFileSystem();
        }

        public boolean skipAst() {
            return this.skipAst;
        }

        public void setSkipAst(boolean skipAst) {
            this.skipAst = skipAst;
        }

        public void setFsEvents(Map<String, String> fsEvents) {
            this.fsEvents = fsEvents;
        }
    }

    public static class ProjectAnalysisRequest {
        private Map<String, JsTsFile> files;
        private List<EslintRule> rules;
        public ProjectAnalysisConfiguration configuration;
        private List<String> bundles;
        private String rulesWorkdir;

        public ProjectAnalysisRequest(Map<String, JsTsFile> files, List<EslintRule> rules, ProjectAnalysisConfiguration configuration) {
            this.files = files;
            this.rules = rules;
            this.configuration = configuration;
        }

        public Map<String, JsTsFile> getFiles() {
            return this.files;
        }

        public ProjectAnalysisConfiguration getConfiguration() {
            return this.configuration;
        }

        public void setBundles(List<String> bundles) {
            this.bundles = bundles;
        }

        public void setRulesWorkdir(String rulesWorkdir) {
            this.rulesWorkdir = rulesWorkdir;
        }
    }

    public record JsTsFile(String filePath, String fileType, InputFile.Status fileStatus, @Nullable String fileContent) {
    }

    public record JsAnalysisRequest(String filePath, String fileType, @Nullable String fileContent, boolean ignoreHeaderComments, @Nullable List<String> tsConfigs, @Nullable String programId, InputFile.Status fileStatus, AnalysisMode analysisMode, boolean skipAst, boolean shouldClearDependenciesCache, boolean sonarlint, boolean allowTsParserJsFiles, @Nullable ProjectAnalysisConfiguration configuration) {
        public JsAnalysisRequest(String filePath, String fileType, @Nullable String fileContent, boolean ignoreHeaderComments, @Nullable List<String> tsConfigs, @Nullable String programId, InputFile.Status fileStatus, AnalysisMode analysisMode, boolean skipAst, boolean shouldClearDependenciesCache, boolean sonarlint, boolean allowTsParserJsFiles) {
            this(filePath, fileType, fileContent, ignoreHeaderComments, tsConfigs, programId, fileStatus, analysisMode, skipAst, shouldClearDependenciesCache, sonarlint, allowTsParserJsFiles, null);
        }
    }

    public record ProjectAnalysisOutputDTO(Map<String, AnalysisResponseDTO> files, ProjectAnalysisMetaResponse meta) {
    }

    public record InitLinterRequest(List<EslintRule> rules, List<String> environments, List<String> globals, String baseDir, boolean sonarlint, List<String> bundles, String rulesWorkdir) {
    }
}

