/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.bridge;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.plugins.javascript.bridge.protobuf.Node;

public class AstProtoUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AstProtoUtils.class);
    private static final int PROTOBUF_RECURSION_LIMIT = 300;

    private AstProtoUtils() {
    }

    public static Node parseProtobuf(String astBase64) throws IOException {
        return AstProtoUtils.readProtobufFromBytes(Base64.getDecoder().decode(astBase64));
    }

    public static Node readProtobufFromBytes(byte[] bytes) throws IOException {
        return AstProtoUtils.readProtobuf(CodedInputStream.newInstance(bytes));
    }

    private static Node readProtobuf(CodedInputStream input) throws IOException {
        try {
            input.setRecursionLimit(300);
            return Node.parseFrom(input);
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error("Failed to deserialize Protobuf message: {}", (Object)e.getMessage());
            return null;
        }
    }
}

