/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.api.estree;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ESTree {
    private ESTree() {
    }

    public record JSXEmptyExpression(Location loc) implements ExpressionOrJSXEmptyExpression
    {
    }

    public record JSXText(Location loc, String raw, String value) implements JSXChild
    {
    }

    public record JSXSpreadChild(Location loc, ExpressionOrJSXEmptyExpression expression) implements JSXExpression
    {
    }

    public record JSXExpressionContainer(Location loc, ExpressionOrJSXEmptyExpression expression) implements JSXExpression
    {
    }

    public record JSXSpreadAttribute(Location loc, Expression argument) implements JSXOpeningElementAttribute
    {
    }

    public record JSXNamespacedName(Location loc, JSXIdentifier name, JSXIdentifier namespace) implements JSXAttributeName,
    JSXTagNameExpression
    {
    }

    public record JSXMemberExpression(Location loc, JSXTagNameExpression object, JSXIdentifier property) implements JSXTagNameExpression
    {
    }

    public record JSXIdentifier(Location loc, String name) implements JSXTagNameExpression,
    JSXAttributeName
    {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface JSXAttributeName
    extends Node {
    }

    public record JSXAttribute(Location loc, JSXAttributeName name, Optional<JSXAttributeValue> value) implements JSXOpeningElementAttribute
    {
    }

    public record JSXClosingFragment(Location loc) implements Node
    {
    }

    public record JSXOpeningFragment(Location loc) implements Node
    {
    }

    public record JSXClosingElement(Location loc, JSXTagNameExpression name) implements Node
    {
    }

    public record JSXOpeningElement(Location loc, JSXTagNameExpression name, List<JSXOpeningElementAttribute> attributes, boolean selfClosing, Optional<TSTypeParameterInstantiation> typeArguments) implements Node
    {
    }

    public record JSXFragment(Location loc, JSXOpeningFragment openingFragment, JSXClosingFragment closingFragment, List<JSXChild> children) implements Expression,
    JSXChild
    {
    }

    public record JSXElement(Location loc, JSXOpeningElement openingElement, Optional<JSXClosingElement> closingElement, List<JSXChild> children) implements Expression,
    JSXChild,
    JSXAttributeValue
    {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ExpressionOrJSXEmptyExpression
    extends Node {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface JSXAttributeValue
    extends Node {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface JSXOpeningElementAttribute
    extends Node {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface JSXExpression
    extends JSXChild,
    JSXAttributeValue {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface JSXTagNameExpression
    extends Node {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface JSXChild
    extends Node {
    }

    public record TSTypeParameterInstantiation(Location loc) implements Node
    {
    }

    public record TSAbstractMethodDefinition(Location loc) implements MethodDefinitionOrPropertyDefinitionOrStaticBlock
    {
    }

    public record TSEmptyBodyFunctionExpression(Location loc) implements FunctionExpressionOrTSEmptyBodyFunctionExpression
    {
    }

    public record TSDeclareFunction(Location loc) implements Declaration
    {
    }

    public record TSInterfaceDeclaration(Location loc) implements Declaration
    {
    }

    public record TSEnumDeclaration(Location loc) implements Declaration
    {
    }

    public record TSTypeAliasDeclaration(Location loc) implements Declaration
    {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface FunctionExpressionOrTSEmptyBodyFunctionExpression
    extends Expression {
    }

    public record TSParameterProperty(Location loc, Optional<String> accessibility, boolean readonly, Pattern parameter) implements PatternOrTSParameterProperty
    {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface PatternOrTSParameterProperty
    extends Node {
    }

    public record TSModuleDeclaration(Location loc, IdentifierOrLiteralOrTSQualifiedName id, Optional<TSModuleBlock> body, String kind) implements Declaration
    {
    }

    public record TSModuleBlock(Location loc, List<DirectiveOrModuleDeclarationOrStatement> body) implements Node
    {
    }

    public record TSImportEqualsDeclaration(Location loc, Identifier id, IdentifierOrTSQualifiedNameOrTSExternalModuleReference moduleReference, String importKind) implements ModuleDeclaration
    {
    }

    public record TSExternalModuleReference(Location loc, Literal expression) implements IdentifierOrTSQualifiedNameOrTSExternalModuleReference
    {
    }

    public record TSQualifiedName(Location loc, IdentifierOrTSQualifiedName left, Identifier right) implements IdentifierOrTSQualifiedNameOrTSExternalModuleReference,
    IdentifierOrLiteralOrTSQualifiedName
    {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface IdentifierOrTSQualifiedName
    extends Node {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface IdentifierOrTSQualifiedNameOrTSExternalModuleReference
    extends IdentifierOrTSQualifiedName {
    }

    public static enum UpdateOperator implements Operator
    {
        INCREMENT("++"),
        DECREMENT("--");

        private final String raw;

        private UpdateOperator(String raw) {
            this.raw = raw;
        }

        @Override
        public String raw() {
            return this.raw;
        }

        public static UpdateOperator from(String operator) {
            return Arrays.stream(UpdateOperator.values()).filter(v -> Objects.equals(operator, v.raw)).findFirst().orElse(null);
        }
    }

    public static enum AssignmentOperator implements Operator
    {
        ASSIGN("="),
        PLUS_ASSIGN("+="),
        MINUS_ASSIGN("-="),
        MULTIPLY_ASSIGN("*="),
        DIVIDE_ASSIGN("/="),
        MODULO_ASSIGN("%="),
        EXPONENTIATION_ASSIGN("**="),
        LEFT_SHIFT_ASSIGN("<<="),
        RIGHT_SHIFT_ASSIGN(">>="),
        UNSIGNED_RIGHT_SHIFT_ASSIGN(">>>="),
        BITWISE_OR_ASSIGN("|="),
        BITWISE_XOR_ASSIGN("^="),
        BITWISE_AND_ASSIGN("&="),
        LOGICAL_OR_ASSIGN("||="),
        LOGICAL_AND_ASSIGN("&&="),
        NULLISH_COALESCING_ASSIGN("??=");

        private final String raw;

        private AssignmentOperator(String raw) {
            this.raw = raw;
        }

        @Override
        public String raw() {
            return this.raw;
        }

        public static AssignmentOperator from(String operator) {
            return Arrays.stream(AssignmentOperator.values()).filter(v -> Objects.equals(operator, v.raw)).findFirst().orElse(null);
        }
    }

    public static enum LogicalOperator implements Operator
    {
        AND("&&"),
        OR("||"),
        NULLISH_COALESCING("??");

        private final String raw;

        private LogicalOperator(String raw) {
            this.raw = raw;
        }

        @Override
        public String raw() {
            return this.raw;
        }

        public static LogicalOperator from(String operator) {
            return Arrays.stream(LogicalOperator.values()).filter(v -> Objects.equals(operator, v.raw)).findFirst().orElse(null);
        }
    }

    public static enum BinaryOperator implements Operator
    {
        EQUAL("=="),
        NOT_EQUAL("!="),
        STRICT_EQUAL("==="),
        STRICT_NOT_EQUAL("!=="),
        LESS_THAN("<"),
        LESS_THAN_OR_EQUAL("<="),
        GREATER_THAN(">"),
        GREATER_THAN_OR_EQUAL(">="),
        LEFT_SHIFT("<<"),
        RIGHT_SHIFT(">>"),
        UNSIGNED_RIGHT_SHIFT(">>>"),
        PLUS("+"),
        MINUS("-"),
        MULTIPLY("*"),
        DIVIDE("/"),
        MODULO("%"),
        EXPONENTIATION("**"),
        BITWISE_AND("&"),
        BITWISE_OR("|"),
        BITWISE_XOR("^"),
        IN("in"),
        INSTANCEOF("instanceof");

        private final String raw;

        private BinaryOperator(String raw) {
            this.raw = raw;
        }

        @Override
        public String raw() {
            return this.raw;
        }

        public static BinaryOperator from(String operator) {
            return Arrays.stream(BinaryOperator.values()).filter(v -> Objects.equals(operator, v.raw)).findFirst().orElse(null);
        }
    }

    public static enum UnaryOperator implements Operator
    {
        MINUS("-"),
        PLUS("+"),
        LOGICAL_NOT("!"),
        BITWISE_NOT("~"),
        TYPEOF("typeof"),
        VOID("void"),
        DELETE("delete");

        private final String raw;

        private UnaryOperator(String raw) {
            this.raw = raw;
        }

        @Override
        public String raw() {
            return this.raw;
        }

        public static UnaryOperator from(String operator) {
            return Arrays.stream(UnaryOperator.values()).filter(v -> Objects.equals(operator, v.raw)).findFirst().orElse(null);
        }
    }

    public static interface Operator {
        public String raw();
    }

    public record UnknownNode(Location loc) implements Expression
    {
    }

    public record YieldExpression(Location loc, Optional<Expression> argument, boolean delegate) implements Expression
    {
    }

    public record WithStatement(Location loc, Expression object, Statement body) implements Statement
    {
    }

    public record WhileStatement(Location loc, Expression test, Statement body) implements Statement
    {
    }

    public record VariableDeclarator(Location loc, Pattern id, Optional<Expression> init) implements Node
    {
    }

    public record VariableDeclaration(Location loc, List<VariableDeclarator> declarations, String kind) implements ExpressionOrVariableDeclaration,
    PatternOrVariableDeclaration,
    Declaration
    {
    }

    public record UpdateExpression(Location loc, UpdateOperator operator, Expression argument, boolean prefix) implements Expression
    {
    }

    public record UnaryExpression(Location loc, UnaryOperator operator, boolean prefix, Expression argument) implements Expression
    {
    }

    public record TryStatement(Location loc, BlockStatement block, Optional<CatchClause> handler, Optional<BlockStatement> finalizer) implements Statement
    {
    }

    public record ThrowStatement(Location loc, Expression argument) implements Statement
    {
    }

    public record ThisExpression(Location loc) implements Expression
    {
    }

    public record TemplateLiteral(Location loc, List<TemplateElement> quasis, List<Expression> expressions) implements Expression
    {
    }

    public record TemplateElement(Location loc, boolean tail, String cooked, String raw) implements Node
    {
    }

    public record TaggedTemplateExpression(Location loc, Expression tag, TemplateLiteral quasi) implements Expression
    {
    }

    public record SwitchStatement(Location loc, Expression discriminant, List<SwitchCase> cases) implements Statement
    {
    }

    public record SwitchCase(Location loc, Optional<Expression> test, List<Statement> consequent) implements Node
    {
    }

    public record Super(Location loc) implements ExpressionOrSuper
    {
    }

    public record StaticBlock(Location loc, List<Statement> body) implements MethodDefinitionOrPropertyDefinitionOrStaticBlock,
    Statement
    {
    }

    public record SpreadElement(Location loc, Expression argument) implements ExpressionOrSpreadElement,
    PropertyOrSpreadElement
    {
    }

    public record SimpleLiteral(Location loc, Object value, String raw) implements Literal
    {
    }

    public record SimpleCallExpression(Location loc, boolean optional, ExpressionOrSuper callee, List<ExpressionOrSpreadElement> arguments) implements CallExpression,
    ChainElement
    {
    }

    public record SequenceExpression(Location loc, List<Expression> expressions) implements Expression
    {
    }

    public record ReturnStatement(Location loc, Optional<Expression> argument) implements Statement
    {
    }

    public record RestElement(Location loc, Pattern argument) implements PropertyOrRestElement,
    Pattern
    {
    }

    public record RegExpLiteral(Location loc, String pattern, String flags, String raw) implements Literal
    {
    }

    public record PropertyDefinition(Location loc, ExpressionOrPrivateIdentifier key, Optional<Expression> value, boolean computed, boolean isStatic) implements MethodDefinitionOrPropertyDefinitionOrStaticBlock
    {
    }

    public record Property(Location loc, ExpressionOrPrivateIdentifier key, ExpressionOrPattern value, String kind, boolean method, boolean shorthand, boolean computed) implements PropertyOrSpreadElement,
    PropertyOrRestElement
    {
    }

    public record Program(Location loc, String sourceType, List<DirectiveOrModuleDeclarationOrStatement> body) implements Node
    {
    }

    public record PrivateIdentifier(Location loc, String name) implements ExpressionOrPrivateIdentifier
    {
    }

    public record ObjectPattern(Location loc, List<PropertyOrRestElement> properties) implements Pattern
    {
    }

    public record ObjectExpression(Location loc, List<PropertyOrSpreadElement> properties) implements Expression
    {
    }

    public record NewExpression(Location loc, ExpressionOrSuper callee, List<ExpressionOrSpreadElement> arguments) implements CallExpression
    {
    }

    public record MethodDefinition(Location loc, ExpressionOrPrivateIdentifier key, FunctionExpressionOrTSEmptyBodyFunctionExpression value, String kind, boolean computed, boolean isStatic) implements MethodDefinitionOrPropertyDefinitionOrStaticBlock
    {
    }

    public record MetaProperty(Location loc, Identifier meta, Identifier property) implements Expression
    {
    }

    public record MemberExpression(Location loc, ExpressionOrSuper object, ExpressionOrPrivateIdentifier property, boolean computed, boolean optional) implements ChainElement,
    Expression,
    Pattern
    {
    }

    public record LogicalExpression(Location loc, LogicalOperator operator, Expression left, Expression right) implements Expression
    {
    }

    public record LabeledStatement(Location loc, Identifier label, Statement body) implements Statement
    {
    }

    public record ImportSpecifier(Location loc, Identifier imported, Identifier local) implements ImportDefaultSpecifierOrImportNamespaceSpecifierOrImportSpecifier
    {
    }

    public record ImportNamespaceSpecifier(Location loc, Identifier local) implements ImportDefaultSpecifierOrImportNamespaceSpecifierOrImportSpecifier
    {
    }

    public record ImportExpression(Location loc, Expression source) implements Expression
    {
    }

    public record ImportDefaultSpecifier(Location loc, Identifier local) implements ImportDefaultSpecifierOrImportNamespaceSpecifierOrImportSpecifier
    {
    }

    public record ImportDeclaration(Location loc, List<ImportDefaultSpecifierOrImportNamespaceSpecifierOrImportSpecifier> specifiers, Literal source) implements ModuleDeclaration
    {
    }

    public record IfStatement(Location loc, Expression test, Statement consequent, Optional<Statement> alternate) implements Statement
    {
    }

    public record Identifier(Location loc, String name) implements Expression,
    Pattern,
    IdentifierOrLiteral,
    IdentifierOrTSQualifiedNameOrTSExternalModuleReference
    {
    }

    public record FunctionExpression(Location loc, Optional<Identifier> id, BlockStatement body, List<PatternOrTSParameterProperty> params, boolean generator, boolean async) implements FunctionExpressionOrTSEmptyBodyFunctionExpression
    {
    }

    public record FunctionDeclaration(Location loc, Optional<Identifier> id, BlockStatement body, List<PatternOrTSParameterProperty> params, boolean generator, boolean async) implements Declaration,
    ExpressionOrClassDeclarationOrFunctionDeclaration
    {
    }

    public record ForStatement(Location loc, Optional<ExpressionOrVariableDeclaration> init, Optional<Expression> test, Optional<Expression> update, Statement body) implements Statement
    {
    }

    public record ForOfStatement(Location loc, boolean await, PatternOrVariableDeclaration left, Expression right, Statement body) implements Statement
    {
    }

    public record ForInStatement(Location loc, PatternOrVariableDeclaration left, Expression right, Statement body) implements Statement
    {
    }

    public record ExpressionStatement(Location loc, Expression expression) implements Statement
    {
    }

    public record ExportSpecifier(Location loc, Identifier exported, Identifier local) implements Node
    {
    }

    public record ExportNamedDeclaration(Location loc, Optional<Declaration> declaration, List<ExportSpecifier> specifiers, Optional<Literal> source) implements ModuleDeclaration
    {
    }

    public record ExportDefaultDeclaration(Location loc, ExpressionOrClassDeclarationOrFunctionDeclaration declaration) implements ModuleDeclaration
    {
    }

    public record ExportAssignment(Location loc, Expression expression) implements Statement
    {
    }

    public record ExportAllDeclaration(Location loc, Optional<IdentifierOrLiteral> exported, Literal source) implements ModuleDeclaration
    {
    }

    public record EmptyStatement(Location loc) implements Statement
    {
    }

    public record DoWhileStatement(Location loc, Statement body, Expression test) implements Statement
    {
    }

    public record Directive(Location loc, Literal expression, String directive) implements Statement
    {
    }

    public record DebuggerStatement(Location loc) implements Statement
    {
    }

    public record ContinueStatement(Location loc, Optional<Identifier> label) implements Statement
    {
    }

    public record ConditionalExpression(Location loc, Expression test, Expression alternate, Expression consequent) implements Expression
    {
    }

    public record ClassExpression(Location loc, Optional<Identifier> id, Optional<Expression> superClass, ClassBody body) implements Expression
    {
    }

    public record ClassDeclaration(Location loc, Optional<Identifier> id, Optional<Expression> superClass, ClassBody body) implements Declaration,
    ExpressionOrClassDeclarationOrFunctionDeclaration
    {
    }

    public record ClassBody(Location loc, List<MethodDefinitionOrPropertyDefinitionOrStaticBlock> body) implements Node
    {
    }

    public record ChainExpression(Location loc, ChainElement expression) implements Expression
    {
    }

    public record CatchClause(Location loc, Optional<Pattern> param, BlockStatement body) implements Node
    {
    }

    public record BreakStatement(Location loc, Optional<Identifier> label) implements Statement
    {
    }

    public record BlockStatement(Location loc, List<Statement> body) implements BlockStatementOrExpression,
    Statement
    {
    }

    public record BinaryExpression(Location loc, BinaryOperator operator, Expression left, Expression right) implements Expression
    {
    }

    public record BigIntLiteral(Location loc, BigInteger value, String bigint, String raw) implements Literal
    {
    }

    public record AwaitExpression(Location loc, Expression argument) implements Expression
    {
    }

    public record AssignmentPattern(Location loc, Pattern left, Expression right) implements Pattern
    {
    }

    public record AssignmentExpression(Location loc, AssignmentOperator operator, MemberExpressionOrPattern left, Expression right) implements Expression
    {
    }

    public record ArrowFunctionExpression(Location loc, boolean expression, BlockStatementOrExpression body, List<PatternOrTSParameterProperty> params, boolean generator, boolean async) implements Expression
    {
    }

    public record ArrayPattern(Location loc, List<Optional<Pattern>> elements) implements Pattern
    {
    }

    public record ArrayExpression(Location loc, List<Optional<ExpressionOrSpreadElement>> elements) implements Expression
    {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface IdentifierOrLiteralOrTSQualifiedName
    extends Node {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface IdentifierOrLiteral
    extends IdentifierOrLiteralOrTSQualifiedName {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ExpressionOrPattern
    extends Node {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface DirectiveOrModuleDeclarationOrStatement
    extends Node {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface PropertyOrRestElement
    extends Node {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface PropertyOrSpreadElement
    extends Node {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ExpressionOrSuper
    extends Node {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ImportDefaultSpecifierOrImportNamespaceSpecifierOrImportSpecifier
    extends Node {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ExpressionOrVariableDeclaration
    extends Node {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface PatternOrVariableDeclaration
    extends Node {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ExpressionOrClassDeclarationOrFunctionDeclaration
    extends Node {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface MethodDefinitionOrPropertyDefinitionOrStaticBlock
    extends Node {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ExpressionOrPrivateIdentifier
    extends Node {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface MemberExpressionOrPattern
    extends Node {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface BlockStatementOrExpression
    extends Node {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ExpressionOrSpreadElement
    extends Node {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Statement
    extends DirectiveOrModuleDeclarationOrStatement {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Pattern
    extends PatternOrTSParameterProperty,
    ExpressionOrPattern,
    PatternOrVariableDeclaration,
    MemberExpressionOrPattern {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ModuleDeclaration
    extends DirectiveOrModuleDeclarationOrStatement {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Literal
    extends Expression,
    IdentifierOrLiteral,
    JSXAttributeValue {
        public String raw();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Expression
    extends ExpressionOrSpreadElement,
    ExpressionOrSuper,
    ExpressionOrPrivateIdentifier,
    ExpressionOrPattern,
    ExpressionOrVariableDeclaration,
    ExpressionOrClassDeclarationOrFunctionDeclaration,
    BlockStatementOrExpression,
    ExpressionOrJSXEmptyExpression {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Declaration
    extends Statement {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ChainElement
    extends Node {
        public boolean optional();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface CallExpression
    extends Expression {
        public ExpressionOrSuper callee();

        public List<ExpressionOrSpreadElement> arguments();
    }

    public record Location(Position start, Position end) {
    }

    public record Position(int line, int column) {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Node {
        public Location loc();
    }
}

