/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.analysis.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

class StringTable {
    private final Map<String, Integer> table = new HashMap<String, Integer>();
    private final List<String> byIndex;

    StringTable() {
        this.byIndex = new ArrayList<String>();
    }

    StringTable(List<String> byIndex) {
        this.byIndex = byIndex;
        for (int i = 0; i < byIndex.size(); ++i) {
            this.table.put(byIndex.get(i), i);
        }
    }

    int getIndex(@Nullable String string) {
        return this.table.computeIfAbsent(string, s -> {
            this.byIndex.add((String)s);
            return this.byIndex.size() - 1;
        });
    }

    String getString(int index) {
        return this.byIndex.get(index);
    }

    List<String> getStringList() {
        return Collections.unmodifiableList(this.byIndex);
    }
}

