/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.analysis.cache;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.plugins.javascript.analysis.cache.CacheKey;
import org.sonar.plugins.javascript.analysis.cache.CacheSerialization;

class JsonSerialization<P>
extends CacheSerialization {
    private static final Logger LOG = LoggerFactory.getLogger(JsonSerialization.class);
    private final Class<P> jsonClass;
    private final Gson gson = new Gson();

    JsonSerialization(Class<P> jsonClass, SensorContext context, CacheKey cacheKey) {
        super(context, cacheKey);
        this.jsonClass = jsonClass;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    P readFromCache() throws IOException {
        try (InputStream input = this.getInputStream();){
            P value = this.gson.fromJson((Reader)new InputStreamReader(input, StandardCharsets.UTF_8), this.jsonClass);
            LOG.debug("Cache entry extracted for key '{}'", (Object)this.getCacheKey());
            P p = value;
            return p;
        }
        catch (JsonParseException e) {
            throw new IOException("Failure when parsing cache entry JSON", e);
        }
    }

    void writeToCache(P payload) {
        this.writeToCache((P)this.gson.toJson(payload).getBytes(StandardCharsets.UTF_8));
        LOG.debug("Cache entry created for key '{}'", (Object)this.getCacheKey());
    }
}

