/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.analysis.cache;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.sonar.api.batch.fs.InputFile;

public class FileMetadata {
    private final long size;
    private final byte[] hash;

    FileMetadata(long size, byte[] hash) {
        this.size = size;
        this.hash = hash;
    }

    static FileMetadata from(InputFile file) throws IOException {
        return new FileMetadata(FileMetadata.fileSize(file), FileMetadata.computeHash(file));
    }

    boolean compareTo(InputFile file) throws IOException {
        return this.size == (long)FileMetadata.fileSize(file) && Arrays.equals(this.hash, FileMetadata.computeHash(file));
    }

    static int fileSize(InputFile file) throws IOException {
        return file.contents().getBytes(file.charset()).length;
    }

    static byte[] computeHash(InputFile file) throws IOException {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] bytes = file.contents().getBytes(file.charset());
            return digest.digest(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

