/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.analysis.cache;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.compress.utils.CountingInputStream;

class FileIterator
implements Iterator<InputStream> {
    private final Iterator<Path> iterator;
    private final Map<Path, Long> fileSizes;

    FileIterator(Iterable<Path> files) {
        this.iterator = files.iterator();
        this.fileSizes = new LinkedHashMap<Path, Long>();
    }

    List<Path> getFiles() {
        return List.copyOf(this.fileSizes.keySet());
    }

    int getCount() {
        return this.fileSizes.size();
    }

    long getFileSize(Path file) {
        return this.fileSizes.get(file);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public InputStream next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.openNextFile();
    }

    private CountingInputStream openNextFile() {
        try {
            final Path file = this.iterator.next();
            return new CountingInputStream(new BufferedInputStream(Files.newInputStream(file, new OpenOption[0]))){

                @Override
                public void close() throws IOException {
                    super.close();
                    FileIterator.this.fileSizes.put(file, this.getBytesRead());
                }
            };
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failure when opening file", e);
        }
    }
}

