/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.analysis.cache;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.plugins.javascript.analysis.cache.CpdData;
import org.sonar.plugins.javascript.analysis.cache.StringTable;
import org.sonar.plugins.javascript.analysis.cache.VarLengthOutputStream;
import org.sonar.plugins.javascript.bridge.BridgeServer;

class CpdSerializer {
    private final ByteArrayOutputStream stream = new ByteArrayOutputStream();
    private final VarLengthOutputStream out = new VarLengthOutputStream(this.stream);
    private final StringTable stringTable = new StringTable();

    private CpdSerializer() {
    }

    static SerializationResult toBinary(CpdData cpdData) throws IOException {
        CpdSerializer serializer = new CpdSerializer();
        return serializer.convert(cpdData);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private SerializationResult convert(CpdData cpdData) throws IOException {
        try (VarLengthOutputStream varLengthOutputStream = this.out;){
            SerializationResult serializationResult;
            block15: {
                ByteArrayOutputStream byteArrayOutputStream = this.stream;
                try {
                    List<BridgeServer.CpdToken> cpdTokens = cpdData.getCpdTokens();
                    this.writeInt(cpdTokens.size());
                    for (BridgeServer.CpdToken cpdToken : cpdTokens) {
                        this.write(cpdToken);
                    }
                    this.out.writeUTF("END");
                    serializationResult = new SerializationResult(this.stream.toByteArray(), this.writeStringTable());
                    if (byteArrayOutputStream == null) break block15;
                }
                catch (Throwable throwable) {
                    if (byteArrayOutputStream != null) {
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                byteArrayOutputStream.close();
            }
            return serializationResult;
        }
        catch (IOException e) {
            throw new IOException("Can't store data in cache", e);
        }
    }

    private void write(BridgeServer.CpdToken cpdToken) throws IOException {
        BridgeServer.Location location = cpdToken.location();
        this.writeInt(location.startLine());
        this.writeInt(location.startCol());
        this.writeInt(location.endLine());
        this.writeInt(location.endCol());
        this.writeText(cpdToken.image());
    }

    private void writeText(@Nullable String text) throws IOException {
        this.out.writeInt(this.stringTable.getIndex(text));
    }

    private void writeInt(int number) throws IOException {
        this.out.writeInt(number);
    }

    private byte[] writeStringTable() throws IOException {
        ByteArrayOutputStream stringTableStream = new ByteArrayOutputStream();
        VarLengthOutputStream output = new VarLengthOutputStream(stringTableStream);
        List<String> byIndex = this.stringTable.getStringList();
        output.writeInt(byIndex.size());
        for (String string : byIndex) {
            output.writeUTF(string);
        }
        output.writeUTF("END");
        return stringTableStream.toByteArray();
    }

    static class SerializationResult {
        private final byte[] data;
        private final byte[] stringTable;

        private SerializationResult(byte[] data, byte[] stringTable) {
            this.data = data;
            this.stringTable = stringTable;
        }

        byte[] getData() {
            return this.data;
        }

        byte[] getStringTable() {
            return this.stringTable;
        }
    }
}

