/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.analysis.cache;

import java.io.IOException;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.plugins.javascript.analysis.cache.CacheKey;
import org.sonar.plugins.javascript.analysis.cache.CacheSerialization;
import org.sonar.plugins.javascript.analysis.cache.CpdData;
import org.sonar.plugins.javascript.analysis.cache.CpdDeserializer;
import org.sonar.plugins.javascript.analysis.cache.CpdSerializer;

class CpdSerialization
extends CacheSerialization {
    static final String DATA_PREFIX = "DATA";
    static final String STRING_TABLE_PREFIX = "STRING_TABLE";
    private final CacheSerialization cpdDataSerialization;
    private final CacheSerialization cpdStringTableSerialization;

    CpdSerialization(SensorContext context, CacheKey cacheKey) {
        super(context, cacheKey);
        this.cpdDataSerialization = new CacheSerialization(context, cacheKey.withPrefix(DATA_PREFIX));
        this.cpdStringTableSerialization = new CacheSerialization(context, cacheKey.withPrefix(STRING_TABLE_PREFIX));
    }

    @Override
    boolean isInCache() {
        return this.cpdDataSerialization.isInCache() && this.cpdStringTableSerialization.isInCache();
    }

    @Override
    void copyFromPrevious() {
        this.cpdDataSerialization.copyFromPrevious();
        this.cpdStringTableSerialization.copyFromPrevious();
    }

    CpdData readFromCache() throws IOException {
        byte[] data = this.cpdDataSerialization.readBytesFromCache();
        byte[] stringTable = this.cpdStringTableSerialization.readBytesFromCache();
        return CpdDeserializer.fromBinary(data, stringTable);
    }

    void writeToCache(CpdData cpdData) throws IOException {
        CpdSerializer.SerializationResult serializationResult = CpdSerializer.toBinary(cpdData);
        this.cpdDataSerialization.writeToCache(serializationResult.getData());
        this.cpdStringTableSerialization.writeToCache(serializationResult.getStringTable());
    }
}

