/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.analysis.cache;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.sonar.plugins.javascript.analysis.cache.CpdData;
import org.sonar.plugins.javascript.analysis.cache.StringTable;
import org.sonar.plugins.javascript.analysis.cache.VarLengthInputStream;
import org.sonar.plugins.javascript.bridge.BridgeServer;

public class CpdDeserializer {
    private final VarLengthInputStream in;
    private final VarLengthInputStream stringTableIn;
    private StringTable stringTable;

    private CpdDeserializer(byte[] data, byte[] stringTable) {
        this.in = new VarLengthInputStream(data);
        this.stringTableIn = new VarLengthInputStream(stringTable);
    }

    public static CpdData fromBinary(byte[] data, byte[] stringTable) throws IOException {
        CpdDeserializer deserializer = new CpdDeserializer(data, stringTable);
        return deserializer.convert();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private CpdData convert() throws IOException {
        try (VarLengthInputStream varLengthInputStream = this.in;){
            CpdData cpdData;
            block16: {
                VarLengthInputStream varLengthInputStream2 = this.stringTableIn;
                try {
                    this.stringTable = this.readStringTable();
                    int sizeOfCpdTokens = this.readInt();
                    ArrayList<BridgeServer.CpdToken> cpdTokens = new ArrayList<BridgeServer.CpdToken>(sizeOfCpdTokens);
                    for (int i = 0; i < sizeOfCpdTokens; ++i) {
                        this.readCpdToken(cpdTokens);
                    }
                    if (!"END".equals(this.in.readUTF())) {
                        throw new IOException("Can't read data from cache, format corrupted");
                    }
                    cpdData = new CpdData(cpdTokens);
                    if (varLengthInputStream2 == null) break block16;
                }
                catch (Throwable throwable) {
                    if (varLengthInputStream2 != null) {
                        try {
                            varLengthInputStream2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                varLengthInputStream2.close();
            }
            return cpdData;
        }
        catch (IOException e) {
            throw new IOException("Can't deserialize data from the cache", e);
        }
    }

    private void readCpdToken(List<BridgeServer.CpdToken> cpdTokens) throws IOException {
        BridgeServer.Location location = new BridgeServer.Location(this.readInt(), this.readInt(), this.readInt(), this.readInt());
        BridgeServer.CpdToken cpdToken = new BridgeServer.CpdToken(location, this.readString());
        cpdTokens.add(cpdToken);
    }

    private int readInt() throws IOException {
        return this.in.readInt();
    }

    private String readString() throws IOException {
        return this.stringTable.getString(this.in.readInt());
    }

    private StringTable readStringTable() throws IOException {
        int size = this.stringTableIn.readInt();
        ArrayList<String> byIndex = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            byIndex.add(this.stringTableIn.readUTF());
        }
        if (!"END".equals(this.stringTableIn.readUTF())) {
            throw new IOException("Can't read data from cache, format corrupted");
        }
        return new StringTable(byIndex);
    }
}

