/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.analysis.cache;

import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.plugins.javascript.analysis.cache.CacheAnalysis;
import org.sonar.plugins.javascript.analysis.cache.CacheAnalysisSerialization;

public class CacheStrategy {
    static final String NO_CACHE = "NO_CACHE";
    static final String READ_AND_WRITE = "READ_AND_WRITE";
    static final String WRITE_ONLY = "WRITE_ONLY";
    private final String name;
    private final CacheAnalysis cacheAnalysis;
    private final CacheAnalysisSerialization serialization;

    private CacheStrategy(String name, @Nullable CacheAnalysis cacheAnalysis, @Nullable CacheAnalysisSerialization serialization) {
        this.name = name;
        this.cacheAnalysis = cacheAnalysis;
        this.serialization = serialization;
    }

    static CacheStrategy noCache() {
        return new CacheStrategy(NO_CACHE, null, null);
    }

    static CacheStrategy writeOnly(CacheAnalysisSerialization serialization) {
        return new CacheStrategy(WRITE_ONLY, null, serialization);
    }

    static CacheStrategy readAndWrite(CacheAnalysis cacheAnalysis, CacheAnalysisSerialization serialization) {
        return new CacheStrategy(READ_AND_WRITE, cacheAnalysis, serialization);
    }

    String getName() {
        return this.name;
    }

    public boolean isAnalysisRequired() {
        return this.cacheAnalysis == null;
    }

    public void writeAnalysisToCache(CacheAnalysis analysis, InputFile file) throws IOException {
        if (this.serialization != null) {
            this.serialization.writeToCache(analysis, file);
        }
    }

    public CacheAnalysis readAnalysisFromCache() {
        return Objects.requireNonNull(this.cacheAnalysis);
    }
}

