/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.analysis.cache;

import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.SonarProduct;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.utils.Version;
import org.sonar.plugins.javascript.analysis.JsTsContext;
import org.sonar.plugins.javascript.analysis.cache.CacheAnalysis;
import org.sonar.plugins.javascript.analysis.cache.CacheAnalysisSerialization;
import org.sonar.plugins.javascript.analysis.cache.CacheKey;
import org.sonar.plugins.javascript.analysis.cache.CacheReporter;
import org.sonar.plugins.javascript.analysis.cache.CacheStrategy;
import org.sonar.plugins.javascript.analysis.cache.FileMetadata;
import org.sonar.plugins.javascript.api.AnalysisMode;
import org.sonar.plugins.javascript.bridge.PluginInfo;

public class CacheStrategies {
    private static final Logger LOG = LoggerFactory.getLogger(CacheStrategies.class);
    private static final CacheReporter REPORTER = new CacheReporter();

    private CacheStrategies() {
    }

    private static boolean isRuntimeApiCompatible(JsTsContext<?> context) {
        SonarRuntime runtime = context.getSensorContext().runtime();
        boolean isVersionValid = runtime.getApiVersion().isGreaterThanOrEqual(Version.create((int)9, (int)4));
        boolean isProductValid = runtime.getProduct() != SonarProduct.SONARLINT;
        return isVersionValid && isProductValid;
    }

    static String getLogMessage(CacheStrategy cacheStrategy, InputFile inputFile, @Nullable String reason) {
        StringBuilder logBuilder = new StringBuilder("Cache strategy set to '");
        logBuilder.append(cacheStrategy.getName()).append("' for file '").append(inputFile).append("'");
        if (reason != null) {
            logBuilder.append(" as ").append(reason);
        }
        return logBuilder.toString();
    }

    public static CacheStrategy getStrategyFor(JsTsContext<?> context, InputFile inputFile) throws IOException {
        return CacheStrategies.getStrategyFor(context, inputFile, PluginInfo.getVersion());
    }

    static CacheStrategy getStrategyFor(JsTsContext<?> context, InputFile inputFile, @Nullable String pluginVersion) throws IOException {
        if (!CacheStrategies.isRuntimeApiCompatible(context)) {
            CacheStrategy strategy = CacheStrategy.noCache();
            REPORTER.logAndIncrement(strategy, inputFile, MissReason.RUNTIME_API_INCOMPATIBLE);
            return strategy;
        }
        CacheKey cacheKey = CacheKey.forFile(inputFile, pluginVersion);
        CacheAnalysisSerialization serialization = new CacheAnalysisSerialization((SensorContext)context.getSensorContext(), cacheKey);
        if (context.getAnalysisMode() == AnalysisMode.DEFAULT) {
            CacheStrategy strategy = CacheStrategy.writeOnly(serialization);
            REPORTER.logAndIncrement(strategy, inputFile, MissReason.ANALYSIS_MODE_INELIGIBLE);
            return strategy;
        }
        Optional<FileMetadata> fileMetadata = serialization.fileMetadata();
        if (fileMetadata.isEmpty() || !CacheStrategies.isSameFile(fileMetadata.get(), inputFile)) {
            CacheStrategy strategy = CacheStrategy.writeOnly(serialization);
            REPORTER.logAndIncrement(strategy, inputFile, MissReason.FILE_CHANGED);
            return strategy;
        }
        if (!serialization.isInCache()) {
            CacheStrategy strategy = CacheStrategy.writeOnly(serialization);
            REPORTER.logAndIncrement(strategy, inputFile, MissReason.FILE_NOT_IN_CACHE);
            return strategy;
        }
        CacheAnalysis cacheAnalysis = CacheStrategies.readFromCache(serialization);
        if (cacheAnalysis == null) {
            CacheStrategy strategy = CacheStrategy.writeOnly(serialization);
            REPORTER.logAndIncrement(strategy, inputFile, MissReason.CACHE_CORRUPTED);
            return strategy;
        }
        CacheStrategy strategy = CacheStrategy.readAndWrite(cacheAnalysis, serialization);
        REPORTER.logAndIncrement(strategy, inputFile, null);
        return strategy;
    }

    private static boolean isSameFile(FileMetadata fileMetadata, InputFile inputFile) throws IOException {
        return fileMetadata.compareTo(inputFile);
    }

    static CacheAnalysis readFromCache(CacheAnalysisSerialization serialization) {
        try {
            CacheAnalysis cacheAnalysis = serialization.readFromCache();
            serialization.copyFromPrevious();
            return cacheAnalysis;
        }
        catch (IOException e) {
            LOG.error("Failure when reading cache entry", e);
            return null;
        }
    }

    public static void reset() {
        REPORTER.reset();
    }

    public static void logReport() {
        REPORTER.logReport();
    }

    static enum MissReason {
        RUNTIME_API_INCOMPATIBLE("the runtime API is not compatible"),
        CACHE_DISABLED("cache is disabled"),
        ANALYSIS_MODE_INELIGIBLE("current analysis requires all files to be analyzed"),
        FILE_CHANGED("the current file is changed"),
        FILE_NOT_IN_CACHE("the current file is not cached"),
        CACHE_CORRUPTED("the cache is corrupted");

        private final String description;

        private MissReason(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

