/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.analysis.cache;

import java.io.IOException;
import java.io.InputStream;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.plugins.javascript.analysis.cache.CacheKey;

class CacheSerialization {
    private final SensorContext context;
    private final CacheKey cacheKey;

    CacheSerialization(SensorContext context, CacheKey cacheKey) {
        this.context = context;
        this.cacheKey = cacheKey;
    }

    boolean isInCache() {
        return this.context.previousCache().contains(this.cacheKey.toString());
    }

    void copyFromPrevious() {
        this.context.nextCache().copyFromPrevious(this.cacheKey.toString());
    }

    SensorContext getContext() {
        return this.context;
    }

    CacheKey getCacheKey() {
        return this.cacheKey;
    }

    InputStream getInputStream() {
        return this.context.previousCache().read(this.cacheKey.toString());
    }

    byte[] readBytesFromCache() throws IOException {
        try (InputStream input = this.getInputStream();){
            byte[] byArray = input.readAllBytes();
            return byArray;
        }
    }

    void writeToCache(byte[] bytes) {
        this.context.nextCache().write(this.cacheKey.toString(), bytes);
    }

    void writeToCache(InputStream sequence) {
        this.context.nextCache().write(this.cacheKey.toString(), sequence);
    }
}

