/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.analysis.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.plugins.javascript.analysis.cache.CacheStrategies;
import org.sonar.plugins.javascript.analysis.cache.CacheStrategy;

class CacheReporter {
    private static final Logger LOG = LoggerFactory.getLogger(CacheReporter.class);
    private final Map<Optional<CacheStrategies.MissReason>, AtomicInteger> counters = new HashMap<Optional<CacheStrategies.MissReason>, AtomicInteger>();

    CacheReporter() {
    }

    private static String getStrategyMessage(CacheStrategy strategy, @Nullable InputFile inputFile, @Nullable CacheStrategies.MissReason missReason) {
        StringBuilder logBuilder = new StringBuilder("Cache strategy set to '");
        logBuilder.append(strategy.getName()).append("'");
        if (inputFile != null) {
            logBuilder.append(" for file '").append(inputFile).append("'");
        }
        if (missReason != null) {
            logBuilder.append(" as ").append(missReason.getDescription());
        }
        return logBuilder.toString();
    }

    private static String getMissMessage(int total, CacheStrategies.MissReason reason, int count) {
        return String.format("%s [%d/%d]", reason.name(), count, total);
    }

    void logAndIncrement(CacheStrategy strategy, InputFile inputFile, @Nullable CacheStrategies.MissReason missReason) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(CacheReporter.getStrategyMessage(strategy, inputFile, missReason));
        }
        this.getCounter(missReason).incrementAndGet();
    }

    void reset() {
        this.counters.clear();
    }

    void logReport() {
        int total = this.getTotal();
        int hits = this.getHits();
        int misses = total - hits;
        LOG.info(String.format("Hit the cache for %d out of %d", hits, total));
        LOG.info(String.format("Miss the cache for %d out of %d%s", misses, total, this.getMissMessages(total)));
    }

    private String getMissMessages(int total) {
        String message = this.counters.entrySet().stream().filter(entry -> ((Optional)entry.getKey()).isPresent()).map(entry -> CacheReporter.getMissMessage(total, (CacheStrategies.MissReason)((Object)((Object)((Optional)entry.getKey()).get())), ((AtomicInteger)entry.getValue()).intValue())).sorted().collect(Collectors.joining(", "));
        return message.length() > 0 ? ": " + message : "";
    }

    private int getTotal() {
        int total = 0;
        for (AtomicInteger count : this.counters.values()) {
            total += count.intValue();
        }
        return total;
    }

    private int getHits() {
        return this.getCounter(null).intValue();
    }

    private AtomicInteger getCounter(@Nullable CacheStrategies.MissReason reason) {
        return this.counters.computeIfAbsent(Optional.ofNullable(reason), key -> new AtomicInteger(0));
    }
}

