/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.analysis.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;

class CacheKey {
    private final String file;
    private final List<String> prefixes;
    private final String pluginVersion;

    private CacheKey(List<String> prefixes, @Nullable String pluginVersion, String file) {
        this.prefixes = prefixes.stream().filter(Objects::nonNull).toList();
        this.pluginVersion = pluginVersion;
        this.file = file;
    }

    static CacheKey forFile(InputFile inputFile, @Nullable String pluginVersion) {
        return new CacheKey(Collections.emptyList(), pluginVersion, inputFile.key());
    }

    CacheKey forCpd() {
        return this.withPrefix("js", "cpd");
    }

    CacheKey forAst() {
        return this.withPrefix("js", "ast");
    }

    CacheKey forFileMetadata() {
        return this.withPrefix("js", "filemetadata");
    }

    CacheKey withPrefix(String ... prefixes) {
        return new CacheKey(Stream.concat(this.prefixes.stream(), Arrays.stream(prefixes)).toList(), this.pluginVersion, this.file);
    }

    public String toString() {
        ArrayList<String> elements = new ArrayList<String>(this.prefixes);
        if (this.pluginVersion != null) {
            elements.add(this.pluginVersion);
        }
        elements.add(this.file);
        return String.join((CharSequence)":", elements);
    }
}

