/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.analysis.cache;

import java.io.IOException;
import java.util.Optional;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.plugins.javascript.analysis.cache.AstProtobufSerialization;
import org.sonar.plugins.javascript.analysis.cache.CacheAnalysis;
import org.sonar.plugins.javascript.analysis.cache.CacheKey;
import org.sonar.plugins.javascript.analysis.cache.CacheSerialization;
import org.sonar.plugins.javascript.analysis.cache.CpdData;
import org.sonar.plugins.javascript.analysis.cache.CpdSerialization;
import org.sonar.plugins.javascript.analysis.cache.FileMetadata;
import org.sonar.plugins.javascript.analysis.cache.JsonSerialization;
import org.sonar.plugins.javascript.bridge.protobuf.Node;

public class CacheAnalysisSerialization
extends CacheSerialization {
    private final AstProtobufSerialization astProtobufSerialization;
    private final CpdSerialization cpdSerialization;
    private final JsonSerialization<FileMetadata> fileMetadataSerialization;

    CacheAnalysisSerialization(SensorContext context, CacheKey cacheKey) {
        super(context, cacheKey);
        this.astProtobufSerialization = new AstProtobufSerialization(context, cacheKey.forAst());
        this.cpdSerialization = new CpdSerialization(context, cacheKey.forCpd());
        this.fileMetadataSerialization = new JsonSerialization<FileMetadata>(FileMetadata.class, context, cacheKey.forFileMetadata());
    }

    @Override
    boolean isInCache() {
        return this.cpdSerialization.isInCache() && this.astProtobufSerialization.isInCache();
    }

    Optional<FileMetadata> fileMetadata() throws IOException {
        if (this.fileMetadataSerialization.isInCache()) {
            return Optional.of(this.fileMetadataSerialization.readFromCache());
        }
        return Optional.empty();
    }

    CacheAnalysis readFromCache() throws IOException {
        Optional<Node> astData = this.astProtobufSerialization.readFromCache();
        CpdData cpdData = this.cpdSerialization.readFromCache();
        return CacheAnalysis.fromCache(cpdData.getCpdTokens(), astData.orElse(null));
    }

    void writeToCache(CacheAnalysis analysis, InputFile file) throws IOException {
        this.astProtobufSerialization.writeToCache(analysis.getAst());
        this.cpdSerialization.writeToCache(new CpdData(analysis.getCpdTokens()));
        this.fileMetadataSerialization.writeToCache(FileMetadata.from(file));
    }

    @Override
    void copyFromPrevious() {
        this.astProtobufSerialization.copyFromPrevious();
        this.cpdSerialization.copyFromPrevious();
    }
}

