/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.analysis.cache;

import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.plugins.javascript.analysis.cache.CacheKey;
import org.sonar.plugins.javascript.analysis.cache.CacheSerialization;
import org.sonar.plugins.javascript.bridge.AstProtoUtils;
import org.sonar.plugins.javascript.bridge.protobuf.Node;

public class AstProtobufSerialization
extends CacheSerialization {
    private static final Logger LOG = LoggerFactory.getLogger(AstProtobufSerialization.class);

    AstProtobufSerialization(SensorContext context, CacheKey cacheKey) {
        super(context, cacheKey);
    }

    Optional<Node> readFromCache() throws IOException {
        byte[] bytes = this.readBytesFromCache();
        if (bytes.length == 0) {
            return Optional.empty();
        }
        Node node = AstProtoUtils.readProtobufFromBytes(bytes);
        if (node == null) {
            throw new IOException("The AST is null for key " + String.valueOf(this.getCacheKey()));
        }
        LOG.debug("Cache entry extracted for key '{}'", (Object)this.getCacheKey());
        return Optional.of(node);
    }

    void writeToCache(@Nullable Node node) {
        byte[] bytes = node == null ? new byte[]{} : node.toByteArray();
        this.writeToCache(bytes);
        LOG.debug("Cache entry created for key '{}'", (Object)this.getCacheKey());
    }
}

