/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.analysis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.plugins.javascript.CancellationException;
import org.sonar.plugins.javascript.JavaScriptFilePredicate;
import org.sonar.plugins.javascript.analysis.AbstractBridgeSensor;
import org.sonar.plugins.javascript.analysis.AnalysisProcessor;
import org.sonar.plugins.javascript.analysis.JsTsChecks;
import org.sonar.plugins.javascript.analysis.cache.CacheAnalysis;
import org.sonar.plugins.javascript.analysis.cache.CacheStrategies;
import org.sonar.plugins.javascript.analysis.cache.CacheStrategy;
import org.sonar.plugins.javascript.bridge.BridgeServer;
import org.sonar.plugins.javascript.utils.ProgressReport;

public class YamlSensor
extends AbstractBridgeSensor {
    public static final String LANGUAGE = "yaml";
    public static final String SAM_TRANSFORM_FIELD = "AWS::Serverless-2016-10-31";
    public static final String NODEJS_RUNTIME_REGEX = "^\\s*Runtime:\\s*['\"]?nodejs\\S*['\"]?";
    private static final Logger LOG = LoggerFactory.getLogger(YamlSensor.class);
    private final JsTsChecks checks;
    private final AnalysisProcessor analysisProcessor;

    public YamlSensor(JsTsChecks checks, BridgeServer bridgeServer, AnalysisProcessor processAnalysis) {
        super(bridgeServer, "JS in YAML");
        this.checks = checks;
        this.analysisProcessor = processAnalysis;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.name("JavaScript inside YAML analysis").onlyOnLanguage(LANGUAGE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void analyzeFiles(List<InputFile> inputFiles) throws IOException {
        ProgressReport progressReport = new ProgressReport("Analysis progress", TimeUnit.SECONDS.toMillis(10L));
        boolean success = false;
        try {
            progressReport.start(inputFiles.size(), inputFiles.iterator().next().toString());
            this.bridgeServer.initLinter(this.checks.enabledEslintRules(), this.context.getEnvironments(), this.context.getGlobals(), this.context.getSensorContext().fileSystem().baseDir().getAbsolutePath(), this.context.isSonarLint());
            for (InputFile inputFile : inputFiles) {
                if (this.context.getSensorContext().isCancelled()) {
                    throw new CancellationException("Analysis interrupted because the SensorContext is in cancelled state");
                }
                progressReport.nextFile(inputFile.toString());
                this.analyze(inputFile);
            }
            success = true;
        }
        finally {
            if (success) {
                progressReport.stop();
            } else {
                progressReport.cancel();
            }
        }
    }

    @Override
    protected List<InputFile> getInputFiles() {
        FileSystem fileSystem = this.context.getSensorContext().fileSystem();
        FilePredicates p = fileSystem.predicates();
        FilePredicate yamlPredicate = JavaScriptFilePredicate.getYamlPredicate(fileSystem);
        FilePredicate filePredicate = p.and(yamlPredicate, input -> YamlSensor.isSamTemplate(input, LOG));
        Iterable inputFiles = fileSystem.inputFiles(filePredicate);
        return StreamSupport.stream(inputFiles.spliterator(), false).toList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isSamTemplate(InputFile inputFile, Logger logger) {
        boolean hasAwsTransform = false;
        boolean hasNodeJsRuntime = false;
        try (Scanner scanner = new Scanner(inputFile.inputStream(), inputFile.charset().name());){
            Pattern regex = Pattern.compile(NODEJS_RUNTIME_REGEX);
            do {
                Matcher lineMatch;
                if (!scanner.hasNextLine()) return false;
                String line = scanner.nextLine();
                if (line.contains(SAM_TRANSFORM_FIELD)) {
                    hasAwsTransform = true;
                }
                if (!(lineMatch = regex.matcher(line)).find()) continue;
                hasNodeJsRuntime = true;
            } while (!hasAwsTransform || !hasNodeJsRuntime);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            logger.error(String.format("Unable to read file: %s.", inputFile.uri()));
            logger.error(e.getMessage());
        }
        return false;
    }

    private List<BridgeServer.Issue> analyze(InputFile file) throws IOException {
        List<BridgeServer.Issue> issues = new ArrayList<BridgeServer.Issue>();
        CacheStrategy cacheStrategy = CacheStrategies.getStrategyFor(this.context, file);
        if (cacheStrategy.isAnalysisRequired()) {
            try {
                LOG.debug("Analyzing file: {}", (Object)file.uri());
                String fileContent = this.context.shouldSendFileContent(file) ? file.contents() : null;
                BridgeServer.JsAnalysisRequest jsAnalysisRequest = new BridgeServer.JsAnalysisRequest(file.absolutePath(), file.type().toString(), fileContent, this.context.ignoreHeaderComments(), null, null, file.status(), this.context.getAnalysisMode(), false, false, this.context.isSonarLint(), this.context.allowTsParserJsFiles(), this.configuration);
                BridgeServer.AnalysisResponse response = this.bridgeServer.analyzeYaml(jsAnalysisRequest);
                issues = this.analysisProcessor.processResponse(this.context, this.checks, file, response);
                cacheStrategy.writeAnalysisToCache(CacheAnalysis.fromResponse(response.cpdTokens(), response.ast()), file);
            }
            catch (IOException e) {
                LOG.error("Failed to get response while analyzing " + String.valueOf(file.uri()), e);
                throw e;
            }
        }
        return issues;
    }
}

