/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.analysis;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.fix.NewInputFileEdit;
import org.sonar.api.batch.sensor.issue.fix.NewQuickFix;
import org.sonar.api.batch.sensor.issue.fix.NewTextEdit;
import org.sonar.plugins.javascript.bridge.BridgeServer;

class QuickFixSupport {
    private static final Logger LOG = LoggerFactory.getLogger(QuickFixSupport.class);

    private QuickFixSupport() {
    }

    static void addQuickFixes(BridgeServer.Issue issue, NewIssue sonarLintIssue, InputFile file) {
        issue.quickFixes().forEach(qf -> {
            LOG.debug("Adding quick fix for issue {} at line {}", (Object)issue.ruleId(), (Object)issue.line());
            NewQuickFix quickFix = sonarLintIssue.newQuickFix();
            NewInputFileEdit fileEdit = quickFix.newInputFileEdit();
            qf.edits().forEach(e -> {
                NewTextEdit textEdit = fileEdit.newTextEdit();
                textEdit.at(file.newRange(e.loc().line().intValue(), e.loc().column().intValue(), e.loc().endLine().intValue(), e.loc().endColumn().intValue())).withNewText(e.text());
                fileEdit.on(file).addTextEdit(textEdit);
            });
            quickFix.addInputFileEdit(fileEdit).message(qf.message());
            sonarLintIssue.addQuickFix(quickFix);
        });
    }
}

