/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.analysis;

import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.utils.Version;
import org.sonar.plugins.javascript.analysis.JsTsContext;
import org.sonar.plugins.javascript.bridge.BridgeServer;

public class PluginTelemetry {
    private static final Logger LOG = LoggerFactory.getLogger(PluginTelemetry.class);
    private static final String KEY_PREFIX = "javascript.";
    private static final String RUNTIME_PREFIX = "javascript.runtime.";
    private final BridgeServer server;
    private final JsTsContext<?> ctx;

    public PluginTelemetry(JsTsContext<?> ctx, BridgeServer server) {
        this.ctx = ctx;
        this.server = server;
    }

    void reportTelemetry() {
        if (this.ctx.isSonarLint()) {
            return;
        }
        boolean isTelemetrySupported = this.ctx.getSensorContext().runtime().getApiVersion().isGreaterThanOrEqual(Version.create((int)10, (int)9));
        if (!isTelemetrySupported) {
            return;
        }
        BridgeServer.TelemetryData telemetry = this.server.getTelemetry();
        if (telemetry.runtimeTelemetry() != null) {
            HashMap<String, String> keyMapToSave = new HashMap<String, String>();
            keyMapToSave.put("javascript.runtime.node-executable-origin", telemetry.runtimeTelemetry().nodeExecutableOrigin());
            keyMapToSave.put("javascript.runtime.version", telemetry.runtimeTelemetry().version().toString());
            keyMapToSave.put("javascript.runtime.major-version", Integer.toString(telemetry.runtimeTelemetry().version().major()));
            keyMapToSave.forEach((arg_0, arg_1) -> this.ctx.getSensorContext().addTelemetryProperty(arg_0, arg_1));
            LOG.debug("Telemetry saved: {}", (Object)keyMapToSave);
        }
    }
}

