/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.analysis;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.plugins.javascript.CancellationException;
import org.sonar.plugins.javascript.JavaScriptFilePredicate;
import org.sonar.plugins.javascript.analysis.AbstractBridgeSensor;
import org.sonar.plugins.javascript.analysis.AnalysisConsumers;
import org.sonar.plugins.javascript.analysis.AnalysisProcessor;
import org.sonar.plugins.javascript.analysis.JsTsChecks;
import org.sonar.plugins.javascript.analysis.JsTsContext;
import org.sonar.plugins.javascript.analysis.PluginTelemetry;
import org.sonar.plugins.javascript.analysis.cache.CacheAnalysis;
import org.sonar.plugins.javascript.analysis.cache.CacheStrategies;
import org.sonar.plugins.javascript.analysis.cache.CacheStrategy;
import org.sonar.plugins.javascript.api.JsFile;
import org.sonar.plugins.javascript.api.estree.ESTree;
import org.sonar.plugins.javascript.bridge.AnalysisWarningsWrapper;
import org.sonar.plugins.javascript.bridge.BridgeServer;
import org.sonar.plugins.javascript.bridge.ESTreeFactory;
import org.sonar.plugins.javascript.bridge.WebSocketMessageHandler;
import org.sonar.plugins.javascript.bridge.protobuf.Node;
import org.sonar.plugins.javascript.external.EslintReportImporter;
import org.sonar.plugins.javascript.external.ExternalIssue;
import org.sonar.plugins.javascript.external.ExternalIssueRepository;
import org.sonar.plugins.javascript.sonarlint.FSListener;

@DependedUpon(value={"js-analysis"})
public class JsTsSensor
extends AbstractBridgeSensor {
    private static final Logger LOG = LoggerFactory.getLogger(JsTsSensor.class);
    private static final Gson GSON = new Gson();
    private final JsTsChecks checks;
    private final AnalysisConsumers consumers;
    private final AnalysisProcessor analysisProcessor;
    private final AnalysisWarningsWrapper analysisWarnings;
    FSListener fsListener;

    public JsTsSensor(JsTsChecks checks, BridgeServer bridgeServer, AnalysisProcessor analysisProcessor, AnalysisWarningsWrapper analysisWarnings, AnalysisConsumers consumers) {
        this(checks, bridgeServer, analysisProcessor, analysisWarnings, consumers, null);
    }

    public JsTsSensor(JsTsChecks checks, BridgeServer bridgeServer, AnalysisProcessor analysisProcessor, AnalysisWarningsWrapper analysisWarnings, AnalysisConsumers consumers, @Nullable FSListener fsListener) {
        super(bridgeServer, "JS/TS");
        this.checks = checks;
        this.consumers = consumers;
        this.analysisProcessor = analysisProcessor;
        this.fsListener = fsListener;
        this.analysisWarnings = analysisWarnings;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguages(new String[]{"js", "ts"}).name("JavaScript/TypeScript analysis");
    }

    @Override
    protected List<InputFile> getInputFiles() {
        FileSystem fileSystem = this.context.getSensorContext().fileSystem();
        FilePredicate allFilesPredicate = JavaScriptFilePredicate.getJsTsPredicate(fileSystem);
        return StreamSupport.stream(fileSystem.inputFiles(allFilesPredicate).spliterator(), false).toList();
    }

    @Override
    protected void analyzeFiles(List<InputFile> inputFiles) {
        EslintReportImporter eslintImporter = new EslintReportImporter();
        Map<String, List<ExternalIssue>> externalIssues = eslintImporter.execute(this.context);
        try {
            AnalyzeProjectHandler handler = new AnalyzeProjectHandler(this.context, inputFiles, externalIssues);
            this.bridgeServer.analyzeProject(handler);
            new PluginTelemetry(this.context, this.bridgeServer).reportTelemetry();
            this.consumers.doneAnalysis((SensorContext)this.context.getSensorContext());
        }
        catch (CompletionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof CancellationException) {
                CancellationException nestedException = (CancellationException)throwable;
                throw nestedException;
            }
            throw e;
        }
        catch (Exception e) {
            LOG.error("Failed to get response from analysis", e);
            throw e;
        }
    }

    class AnalyzeProjectHandler
    implements WebSocketMessageHandler<BridgeServer.ProjectAnalysisRequest> {
        private final JsTsContext<?> context;
        private final Map<String, List<ExternalIssue>> externalIssues;
        private final List<InputFile> inputFiles;
        private final Map<String, InputFile> fileToInputFile = new HashMap<String, InputFile>();
        private final HashMap<String, CacheStrategy> fileToCacheStrategy = new HashMap();
        private final CompletableFuture<Void> handle;

        AnalyzeProjectHandler(JsTsContext<?> context, List<InputFile> inputFiles, Map<String, List<ExternalIssue>> externalIssues) {
            this.inputFiles = inputFiles;
            this.context = context;
            this.handle = new CompletableFuture();
            this.externalIssues = externalIssues;
        }

        @Override
        public BridgeServer.ProjectAnalysisRequest getRequest() {
            HashMap<String, BridgeServer.JsTsFile> files = new HashMap<String, BridgeServer.JsTsFile>();
            try {
                for (InputFile inputFile : this.inputFiles) {
                    CacheStrategy cacheStrategy = null;
                    cacheStrategy = CacheStrategies.getStrategyFor(this.context, inputFile);
                    if (cacheStrategy.isAnalysisRequired()) {
                        files.put(inputFile.absolutePath(), new BridgeServer.JsTsFile(inputFile.absolutePath(), inputFile.type().toString(), inputFile.status(), this.context.shouldSendFileContent(inputFile) ? inputFile.contents() : null));
                        this.fileToInputFile.put(inputFile.absolutePath(), inputFile);
                        this.fileToCacheStrategy.put(inputFile.absolutePath(), cacheStrategy);
                        continue;
                    }
                    LOG.debug("Processing cache analysis of file: {}", (Object)inputFile.uri());
                    CacheAnalysis cacheAnalysis = cacheStrategy.readAnalysisFromCache();
                    JsTsSensor.this.analysisProcessor.processCacheAnalysis(this.context, inputFile, cacheAnalysis);
                    this.acceptAstResponse(cacheAnalysis.getAst(), inputFile);
                }
            }
            catch (IOException e) {
                this.handle.completeExceptionally(new IllegalStateException(e));
            }
            if (JsTsSensor.this.fsListener != null) {
                JsTsSensor.this.configuration.setFsEvents(JsTsSensor.this.fsListener.listFSEvents());
            }
            JsTsSensor.this.configuration.setSkipAst(this.context.skipAst(JsTsSensor.this.consumers));
            return new BridgeServer.ProjectAnalysisRequest(files, JsTsSensor.this.checks.enabledEslintRules(), JsTsSensor.this.configuration);
        }

        @Override
        public CompletableFuture<Void> getFuture() {
            return this.handle;
        }

        @Override
        public SensorContext getContext() {
            return this.context.getSensorContext();
        }

        @Override
        public void handleMessage(JsonObject jsonObject) {
            String messageType = jsonObject.get("messageType").getAsString();
            if ("fileResult".equals(messageType)) {
                String filePath = jsonObject.get("filename").getAsString();
                BridgeServer.AnalysisResponse response = BridgeServer.AnalysisResponse.fromDTO(GSON.fromJson((JsonElement)jsonObject, BridgeServer.AnalysisResponseDTO.class));
                InputFile file = this.fileToInputFile.get(filePath);
                CacheStrategy cacheStrategy = this.fileToCacheStrategy.get(filePath);
                List<BridgeServer.Issue> issues = JsTsSensor.this.analysisProcessor.processResponse(this.context, JsTsSensor.this.checks, file, response);
                List<ExternalIssue> dedupedIssues = ExternalIssueRepository.deduplicateIssues(this.externalIssues.get(filePath), issues);
                if (!dedupedIssues.isEmpty()) {
                    ExternalIssueRepository.saveESLintIssues(this.context.getSensorContext(), dedupedIssues);
                }
                this.externalIssues.remove(filePath);
                try {
                    cacheStrategy.writeAnalysisToCache(CacheAnalysis.fromResponse(response.cpdTokens(), response.ast()), file);
                }
                catch (IOException e) {
                    this.handle.completeExceptionally(new IllegalStateException(e));
                }
                this.acceptAstResponse(response.ast(), file);
            } else if ("meta".equals(messageType)) {
                BridgeServer.ProjectAnalysisMetaResponse meta = GSON.fromJson((JsonElement)jsonObject, BridgeServer.ProjectAnalysisMetaResponse.class);
                meta.warnings().forEach(JsTsSensor.this.analysisWarnings::addUnique);
                this.handle.complete(null);
            } else if ("cancelled".equals(messageType)) {
                this.handle.completeExceptionally(new CancellationException("Analysis interrupted because the SensorContext is in cancelled state"));
            }
        }

        @Override
        public void onClose(int code, String reason, boolean remote) {
            this.handle.completeExceptionally(new IllegalStateException("WebSocket connection closed abnormally: " + reason));
        }

        @Override
        public void onError(Exception ex) {
            this.handle.completeExceptionally(new IllegalStateException("WebSocket connection error", ex));
        }

        private void acceptAstResponse(@Nullable Node responseAst, InputFile file) {
            if (responseAst != null) {
                try {
                    ESTree.Program program = ESTreeFactory.from(responseAst, ESTree.Program.class);
                    JsTsSensor.this.consumers.accept(new JsFile(file, program));
                }
                catch (Exception e) {
                    LOG.debug("Failed to deserialize AST for file: {}", (Object)file.uri(), (Object)e);
                }
            }
        }
    }
}

