/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.analysis;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputFileFilter;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.WildcardPattern;
import org.sonar.plugins.javascript.analysis.JsTsContext;

public class JsTsExclusionsFilter
implements InputFileFilter {
    private final WildcardPattern[] excludedPatterns;
    private static final Logger LOG = LoggerFactory.getLogger(JsTsExclusionsFilter.class);

    public JsTsExclusionsFilter(Configuration configuration) {
        this.excludedPatterns = WildcardPattern.create((String[])JsTsContext.getJsTsExcludedPaths(configuration));
    }

    public boolean accept(InputFile inputFile) {
        boolean shouldFilterFile;
        boolean bl = shouldFilterFile = "js".equals(inputFile.language()) || "ts".equals(inputFile.language()) || "css".equals(inputFile.language());
        if (shouldFilterFile && WildcardPattern.match((WildcardPattern[])this.excludedPatterns, (String)inputFile.relativePath())) {
            LOG.debug("File {} was excluded by {} or {}", inputFile, "sonar.javascript.exclusions", "sonar.typescript.exclusions");
            return false;
        }
        return true;
    }
}

