/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.analysis;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.SonarProduct;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.config.Configuration;
import org.sonar.plugins.javascript.JavaScriptPlugin;
import org.sonar.plugins.javascript.analysis.AnalysisConsumers;
import org.sonar.plugins.javascript.api.AnalysisMode;
import org.sonar.plugins.javascript.bridge.AnalysisConfiguration;

public class JsTsContext<T extends SensorContext>
implements AnalysisConfiguration {
    private static final String ALLOW_TS_PARSER_JS_FILES = "sonar.javascript.allowTsParserJsFiles";
    private static final Logger LOG = LoggerFactory.getLogger(JsTsContext.class);
    private final T context;

    public JsTsContext(T context) {
        this.context = context;
    }

    public T getSensorContext() {
        return this.context;
    }

    @Override
    public boolean isSonarLint() {
        return this.context.runtime().getProduct() == SonarProduct.SONARLINT;
    }

    public boolean isSonarQube() {
        return this.context.runtime().getProduct() == SonarProduct.SONARQUBE;
    }

    @Override
    public boolean ignoreHeaderComments() {
        return this.context.config().getBoolean("sonar.javascript.ignoreHeaderComments").orElse(JavaScriptPlugin.IGNORE_HEADER_COMMENTS_DEFAULT_VALUE);
    }

    public boolean shouldSendFileContent(InputFile file) {
        return this.isSonarLint() || !StandardCharsets.UTF_8.equals(file.charset());
    }

    public boolean failFast() {
        return this.context.config().getBoolean("sonar.internal.analysis.failFast").orElse(false);
    }

    @Override
    public boolean allowTsParserJsFiles() {
        return this.context.config().getBoolean(ALLOW_TS_PARSER_JS_FILES).orElse(true);
    }

    @Override
    public AnalysisMode getAnalysisMode() {
        boolean canSkipUnchangedFiles = this.context.canSkipUnchangedFiles();
        if (!canSkipUnchangedFiles) {
            return AnalysisMode.DEFAULT;
        }
        return AnalysisMode.SKIP_UNCHANGED;
    }

    @Override
    public List<String> getEnvironments() {
        return Arrays.asList(this.context.config().getStringArray("sonar.javascript.environments"));
    }

    @Override
    public List<String> getGlobals() {
        return Arrays.asList(this.context.config().getStringArray("sonar.javascript.globals"));
    }

    public static long getMaxFileSizeProperty(Configuration configuration) {
        Optional property = configuration.get("sonar.javascript.maxFileSize");
        if (property.isPresent()) {
            String propertyValue = (String)property.get();
            try {
                long maxFileSize = Long.parseLong(propertyValue);
                if (maxFileSize <= 0L) {
                    LOG.warn("Maximum file size (sonar.javascript.maxFileSize) is not strictly positive: {}, falling back to {}.", (Object)propertyValue, (Object)1000L);
                }
                return maxFileSize;
            }
            catch (NumberFormatException e) {
                LOG.warn("Maximum file size (sonar.javascript.maxFileSize) is not an integer: \"{}\", falling back to {}.", (Object)propertyValue, (Object)1000L);
            }
        }
        return 1000L;
    }

    @Override
    public long getMaxFileSizeProperty() {
        return JsTsContext.getMaxFileSizeProperty(this.context.config());
    }

    @Override
    public int getTypeCheckingLimit() {
        return Math.max(this.context.config().getInt("sonar.javascript.sonarlint.typechecking.maxfiles").orElse(20000), 0);
    }

    public boolean skipAst(AnalysisConsumers consumers) {
        return !consumers.isEnabled();
    }

    @Override
    public Set<String> getTsConfigPaths() {
        if (!this.context.config().hasKey("sonar.typescript.tsconfigPaths") && !this.context.config().hasKey("sonar.typescript.tsconfigPath")) {
            return Collections.emptySet();
        }
        String property = this.context.config().hasKey("sonar.typescript.tsconfigPaths") ? "sonar.typescript.tsconfigPaths" : "sonar.typescript.tsconfigPath";
        return new LinkedHashSet<String>(List.of(this.context.config().getStringArray(property)));
    }

    public static List<String> getJsExtensions(Configuration config) {
        return List.of(config.hasKey("sonar.javascript.file.suffixes") ? config.getStringArray("sonar.javascript.file.suffixes") : ".js,.jsx,.cjs,.mjs,.vue".split(","));
    }

    @Override
    public List<String> getJsExtensions() {
        return JsTsContext.getJsExtensions(this.context.config());
    }

    public static List<String> getTsExtensions(Configuration config) {
        return List.of(config.hasKey("sonar.typescript.file.suffixes") ? config.getStringArray("sonar.typescript.file.suffixes") : ".ts,.tsx,.cts,.mts".split(","));
    }

    @Override
    public List<String> getTsExtensions() {
        return JsTsContext.getTsExtensions(this.context.config());
    }

    public Set<String> getJsTsExtensions() {
        HashSet<String> extensions = new HashSet<String>();
        extensions.addAll(this.getJsExtensions());
        extensions.addAll(this.getTsExtensions());
        return extensions;
    }

    @Override
    public List<String> getCssExtensions() {
        return JsTsContext.getCssExtensions(this.context.config());
    }

    public static List<String> getCssExtensions(Configuration config) {
        return List.of(config.hasKey("sonar.css.file.suffixes") ? config.getStringArray("sonar.css.file.suffixes") : ".css,.less,.scss,.sass".split(","));
    }

    @Override
    public List<String> getJsTsExcludedPaths() {
        return Arrays.asList(JsTsContext.getJsTsExcludedPaths(this.context.config()));
    }

    public static String[] getJsTsExcludedPaths(Configuration configuration) {
        if (JsTsContext.isExclusionOverridden(configuration)) {
            return (String[])Stream.concat(Arrays.stream(configuration.getStringArray("sonar.javascript.exclusions")), Arrays.stream(configuration.getStringArray("sonar.typescript.exclusions"))).filter(x -> !x.isBlank()).toArray(String[]::new);
        }
        return JavaScriptPlugin.EXCLUSIONS_DEFAULT_VALUE;
    }

    private static boolean isExclusionOverridden(Configuration configuration) {
        return configuration.get("sonar.javascript.exclusions").isPresent() || configuration.get("sonar.typescript.exclusions").isPresent();
    }

    @Override
    public boolean shouldDetectBundles() {
        return JsTsContext.shouldDetectBundles(this.context.config());
    }

    public static boolean shouldDetectBundles(Configuration config) {
        return config.getBoolean("sonar.javascript.detectBundles").orElse(true);
    }

    @Override
    public boolean canAccessFileSystem() {
        return JsTsContext.canAccessFileSystem(this.context.config());
    }

    public static boolean canAccessFileSystem(Configuration config) {
        return config.getBoolean("sonar.javascript.canAccessFileSystem").orElse(true);
    }

    @Override
    public List<String> getSources() {
        return Arrays.stream(this.context.config().getStringArray("sonar.sources")).filter(x -> !x.isBlank()).toList();
    }

    @Override
    public List<String> getInclusions() {
        return Arrays.stream(this.context.config().getStringArray("sonar.inclusions")).filter(x -> !x.isBlank()).toList();
    }

    @Override
    public List<String> getExclusions() {
        return Arrays.stream(this.context.config().getStringArray("sonar.exclusions")).filter(x -> !x.isBlank()).toList();
    }

    @Override
    public List<String> getTests() {
        return Arrays.stream(this.context.config().getStringArray("sonar.tests")).filter(x -> !x.isBlank()).toList();
    }

    @Override
    public List<String> getTestInclusions() {
        return Arrays.stream(this.context.config().getStringArray("sonar.test.inclusions")).filter(x -> !x.isBlank()).toList();
    }

    @Override
    public List<String> getTestExclusions() {
        return Arrays.stream(this.context.config().getStringArray("sonar.test.exclusions")).filter(x -> !x.isBlank()).toList();
    }
}

