/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.analysis;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.javascript.checks.CheckList;
import org.sonar.javascript.checks.S2260;
import org.sonar.plugins.javascript.api.CustomRuleRepository;
import org.sonar.plugins.javascript.api.EslintHook;
import org.sonar.plugins.javascript.api.EslintHookRegistrar;
import org.sonar.plugins.javascript.api.Language;
import org.sonar.plugins.javascript.bridge.EslintRule;
import org.sonarsource.api.sonarlint.SonarLintSide;

@ScannerSide
@SonarLintSide
public class JsTsChecks {
    private static final Logger LOG = LoggerFactory.getLogger(JsTsChecks.class);
    private final CheckFactory checkFactory;
    private final CustomRuleRepository[] customRuleRepositories;
    private final Map<Language, Set<EslintHook>> eslintHooksByLanguage = new EnumMap<Language, Set<EslintHook>>(Language.class);
    private final Map<LanguageAndRepository, Checks<EslintHook>> checks = new HashMap<LanguageAndRepository, Checks<EslintHook>>();
    private final Map<String, Map<Language, RuleKey>> eslintKeyToRuleKey = new HashMap<String, Map<Language, RuleKey>>();
    private RuleKey parseErrorRuleKey;

    public JsTsChecks(CheckFactory checkFactory) {
        this(checkFactory, new CustomRuleRepository[0], new EslintHookRegistrar[0]);
    }

    public JsTsChecks(CheckFactory checkFactory, CustomRuleRepository[] customRuleRepositories) {
        this(checkFactory, customRuleRepositories, new EslintHookRegistrar[0]);
    }

    public JsTsChecks(CheckFactory checkFactory, EslintHookRegistrar[] eslintHookRegistrars) {
        this(checkFactory, new CustomRuleRepository[0], eslintHookRegistrars);
    }

    public JsTsChecks(CheckFactory checkFactory, CustomRuleRepository[] customRuleRepositories, EslintHookRegistrar[] eslintHookRegistrars) {
        this.checkFactory = checkFactory;
        this.customRuleRepositories = customRuleRepositories;
        for (EslintHookRegistrar registrar : eslintHookRegistrars) {
            registrar.register((language, hook) -> this.eslintHooksByLanguage.computeIfAbsent(language, it -> new HashSet()).add(hook));
        }
        this.doAddChecks(Language.TYPESCRIPT, "typescript", CheckList.getTypeScriptChecks());
        this.addCustomChecks(Language.TYPESCRIPT);
        this.doAddChecks(Language.JAVASCRIPT, "javascript", CheckList.getJavaScriptChecks());
        this.addCustomChecks(Language.JAVASCRIPT);
        this.initParsingErrorRuleKey();
    }

    private void doAddChecks(Language language, String repositoryKey, Iterable<?> checkClass) {
        Checks chks = this.checkFactory.create(repositoryKey).addAnnotatedChecks(checkClass);
        LanguageAndRepository key = new LanguageAndRepository(language, repositoryKey);
        this.checks.put(key, (Checks<EslintHook>)chks);
        LOG.debug("Added {} checks for {}", (Object)chks.all().size(), (Object)key);
        chks.all().stream().forEach(check -> this.eslintKeyToRuleKey.computeIfAbsent(check.eslintKey(), k -> new EnumMap(Language.class)).put(language, chks.ruleKey(check)));
    }

    private void addCustomChecks(Language language) {
        for (CustomRuleRepository repo : this.customRuleRepositories) {
            if (!repo.compatibleLanguages().contains((Object)language)) continue;
            this.doAddChecks(language, repo.repositoryKey(), repo.checkClasses());
        }
    }

    Stream<EslintHook> all() {
        return this.checks.values().stream().flatMap(c -> c.all().stream());
    }

    @Nullable
    private RuleKey ruleKeyFor(EslintHook check) {
        return this.checks.values().stream().map(chks -> chks.ruleKey((Object)check)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Nullable
    public RuleKey ruleKeyByEslintKey(String eslintKey, Language language) {
        Map<Language, RuleKey> k = this.eslintKeyToRuleKey.get(eslintKey);
        return k != null ? k.get((Object)language) : null;
    }

    @Nullable
    RuleKey parsingErrorRuleKey() {
        return this.parseErrorRuleKey;
    }

    protected void initParsingErrorRuleKey() {
        this.parseErrorRuleKey = this.all().filter(S2260.class::isInstance).findFirst().map(this::ruleKeyFor).orElse(null);
    }

    List<EslintRule> enabledEslintRules() {
        Stream eslintRules = this.checks.entrySet().stream().flatMap(e -> ((Checks)e.getValue()).all().stream().filter(EslintHook::isEnabled).map(check -> new EslintRule(check.eslintKey(), check.configurations(), check.targets(), check.analysisModes(), check.blacklistedExtensions(), ((LanguageAndRepository)e.getKey()).language)));
        Stream eslintHooks = this.eslintHooksByLanguage.entrySet().stream().flatMap(entry -> {
            String languageKey = ((Language)((Object)((Object)entry.getKey()))).toString();
            return ((Set)entry.getValue()).stream().filter(EslintHook::isEnabled).map(hook -> new EslintRule(hook.eslintKey(), hook.configurations(), hook.targets(), hook.analysisModes(), hook.blacklistedExtensions(), languageKey));
        });
        return Stream.concat(eslintRules, eslintHooks).toList();
    }

    static class LanguageAndRepository {
        final String language;
        final String repository;

        LanguageAndRepository(Language language, String repository) {
            this.language = language == Language.JAVASCRIPT ? "js" : "ts";
            this.repository = repository;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LanguageAndRepository that = (LanguageAndRepository)o;
            return Objects.equals(this.language, that.language) && Objects.equals(this.repository, that.repository);
        }

        public int hashCode() {
            return Objects.hash(this.language, this.repository);
        }

        public String toString() {
            return String.format("language='%s', repository='%s'", this.language, this.repository);
        }
    }
}

