/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.analysis;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.plugins.javascript.CancellationException;
import org.sonar.plugins.javascript.analysis.AbstractBridgeSensor;
import org.sonar.plugins.javascript.analysis.AnalysisProcessor;
import org.sonar.plugins.javascript.analysis.JsTsChecks;
import org.sonar.plugins.javascript.analysis.cache.CacheAnalysis;
import org.sonar.plugins.javascript.analysis.cache.CacheStrategies;
import org.sonar.plugins.javascript.analysis.cache.CacheStrategy;
import org.sonar.plugins.javascript.bridge.BridgeServer;
import org.sonar.plugins.javascript.utils.ProgressReport;

public class HtmlSensor
extends AbstractBridgeSensor {
    public static final String LANGUAGE = "web";
    private static final Logger LOG = LoggerFactory.getLogger(HtmlSensor.class);
    private final JsTsChecks checks;
    private final AnalysisProcessor analysisProcessor;

    public HtmlSensor(JsTsChecks checks, BridgeServer bridgeServer, AnalysisProcessor processAnalysis) {
        super(bridgeServer, "JS in HTML");
        this.analysisProcessor = processAnalysis;
        this.checks = checks;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage(LANGUAGE).name("JavaScript inside HTML analysis");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void analyzeFiles(List<InputFile> inputFiles) throws IOException {
        ProgressReport progressReport = new ProgressReport("Analysis progress", TimeUnit.SECONDS.toMillis(10L));
        boolean success = false;
        try {
            progressReport.start(inputFiles.size(), inputFiles.iterator().next().toString());
            this.bridgeServer.initLinter(this.checks.enabledEslintRules(), this.context.getEnvironments(), this.context.getGlobals(), this.context.getSensorContext().fileSystem().baseDir().getAbsolutePath(), this.context.isSonarLint());
            for (InputFile inputFile : inputFiles) {
                if (this.context.getSensorContext().isCancelled()) {
                    throw new CancellationException("Analysis interrupted because the SensorContext is in cancelled state");
                }
                progressReport.nextFile(inputFile.toString());
                CacheStrategy cacheStrategy = CacheStrategies.getStrategyFor(this.context, inputFile);
                if (!cacheStrategy.isAnalysisRequired()) continue;
                this.analyze(inputFile, cacheStrategy);
            }
            success = true;
        }
        finally {
            if (success) {
                progressReport.stop();
            } else {
                progressReport.cancel();
            }
        }
    }

    @Override
    protected List<InputFile> getInputFiles() {
        FileSystem fileSystem = this.context.getSensorContext().fileSystem();
        FilePredicates p = fileSystem.predicates();
        FilePredicate filePredicate = p.and(p.hasLanguage(LANGUAGE), fileSystem.predicates().or(fileSystem.predicates().hasExtension("htm"), fileSystem.predicates().hasExtension("html")));
        Iterable inputFiles = fileSystem.inputFiles(filePredicate);
        return StreamSupport.stream(inputFiles.spliterator(), false).toList();
    }

    private List<BridgeServer.Issue> analyze(InputFile file, CacheStrategy cacheStrategy) throws IOException {
        List<BridgeServer.Issue> issues;
        try {
            LOG.debug("Analyzing file: {}", (Object)file.uri());
            String fileContent = this.context.shouldSendFileContent(file) ? file.contents() : null;
            BridgeServer.JsAnalysisRequest jsAnalysisRequest = new BridgeServer.JsAnalysisRequest(file.absolutePath(), file.type().toString(), fileContent, this.context.ignoreHeaderComments(), null, null, file.status(), this.context.getAnalysisMode(), false, false, this.context.isSonarLint(), this.context.allowTsParserJsFiles(), this.configuration);
            BridgeServer.AnalysisResponse response = this.bridgeServer.analyzeHtml(jsAnalysisRequest);
            issues = this.analysisProcessor.processResponse(this.context, this.checks, file, response);
            cacheStrategy.writeAnalysisToCache(CacheAnalysis.fromResponse(response.cpdTokens(), response.ast()), file);
        }
        catch (IOException e) {
            LOG.error("Failed to get response while analyzing " + String.valueOf(file.uri()), e);
            throw e;
        }
        return issues;
    }
}

