/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.analysis;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.SonarProduct;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.Version;
import org.sonar.css.CssRules;
import org.sonar.plugins.javascript.CancellationException;
import org.sonar.plugins.javascript.analysis.AbstractBridgeSensor;
import org.sonar.plugins.javascript.analysis.JsTsContext;
import org.sonar.plugins.javascript.bridge.BridgeServer;
import org.sonar.plugins.javascript.bridge.StylelintRule;
import org.sonar.plugins.javascript.utils.ProgressReport;

public class CssRuleSensor
extends AbstractBridgeSensor {
    private static final Logger LOG = LoggerFactory.getLogger(CssRuleSensor.class);
    private final SonarRuntime sonarRuntime;
    private final CssRules cssRules;

    public CssRuleSensor(SonarRuntime sonarRuntime, BridgeServer bridgeServer, CheckFactory checkFactory) {
        super(bridgeServer, "CSS");
        this.sonarRuntime = sonarRuntime;
        this.cssRules = new CssRules(checkFactory);
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.createIssuesForRuleRepository(new String[]{"css"}).name("CSS Rules");
        this.processesFilesIndependently(descriptor);
    }

    private void processesFilesIndependently(SensorDescriptor descriptor) {
        if (this.sonarRuntime.getProduct() == SonarProduct.SONARQUBE && this.sonarRuntime.getApiVersion().isGreaterThanOrEqual(Version.create((int)9, (int)3))) {
            descriptor.processesFilesIndependently();
        }
    }

    @Override
    public void execute(SensorContext context) {
        this.context = new JsTsContext<SensorContext>(context);
        List<InputFile> inputFiles = this.getInputFiles();
        if (inputFiles.isEmpty()) {
            LOG.info("No CSS, PHP, HTML or VueJS files are found in the project. CSS analysis is skipped.");
            return;
        }
        super.execute(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void analyzeFiles(List<InputFile> inputFiles) {
        ProgressReport progressReport = new ProgressReport("Analysis progress", TimeUnit.SECONDS.toMillis(10L));
        boolean success = false;
        List<StylelintRule> rules = this.cssRules.getStylelintRules();
        try {
            progressReport.start(inputFiles.size(), inputFiles.iterator().next().toString());
            for (InputFile inputFile : inputFiles) {
                if (this.context.getSensorContext().isCancelled()) {
                    throw new CancellationException("Analysis interrupted because the SensorContext is in cancelled state");
                }
                this.analyzeFile(inputFile, this.context, rules);
                progressReport.nextFile(inputFile.toString());
            }
            success = true;
        }
        finally {
            if (success) {
                progressReport.stop();
            } else {
                progressReport.cancel();
            }
        }
    }

    List<BridgeServer.Issue> analyzeFile(InputFile inputFile, JsTsContext<?> context, List<StylelintRule> rules) {
        List<BridgeServer.Issue> issues;
        try {
            URI uri = inputFile.uri();
            if (!"file".equalsIgnoreCase(uri.getScheme())) {
                LOG.debug("Skipping {} as it has not 'file' scheme", (Object)uri);
                return new ArrayList<BridgeServer.Issue>();
            }
            LOG.debug("Analyzing file: {}", (Object)uri);
            String fileContent = context.shouldSendFileContent(inputFile) ? inputFile.contents() : null;
            BridgeServer.CssAnalysisRequest request = new BridgeServer.CssAnalysisRequest(new File(uri).getAbsolutePath(), fileContent, rules, this.configuration);
            BridgeServer.AnalysisResponse analysisResponse = this.bridgeServer.analyzeCss(request);
            issues = analysisResponse.issues();
            LOG.debug("Found {} issue(s)", (Object)issues.size());
            this.saveIssues(context, inputFile, issues);
        }
        catch (IOException | RuntimeException e) {
            throw new IllegalStateException("Failure during analysis of " + String.valueOf(inputFile.uri()), e);
        }
        return issues;
    }

    private void saveIssues(JsTsContext<?> context, InputFile inputFile, List<BridgeServer.Issue> issues) {
        for (BridgeServer.Issue issue : issues) {
            RuleKey ruleKey = this.cssRules.getActiveSonarKey(issue.ruleId());
            if (ruleKey == null) {
                if ("CssSyntaxError".equals(issue.ruleId())) {
                    String errorMessage = issue.message().replace("(CssSyntaxError)", "").trim();
                    CssRuleSensor.logWarningOrDebug(inputFile, "Failed to parse file {}, line {}, {}", inputFile.uri(), issue.line(), errorMessage);
                    continue;
                }
                CssRuleSensor.logErrorOrDebug(inputFile, "Unknown stylelint rule or rule not enabled: '" + issue.ruleId() + "'", new Object[0]);
                continue;
            }
            NewIssue sonarIssue = context.getSensorContext().newIssue();
            NewIssueLocation location = sonarIssue.newLocation().on((InputComponent)inputFile).at(inputFile.selectLine(issue.line().intValue())).message(CssRuleSensor.normalizeMessage(issue.message()));
            sonarIssue.at(location).forRule(ruleKey).save();
        }
    }

    private static void logErrorOrDebug(InputFile file, String msg, Object ... arguments) {
        if ("css".equals(file.language())) {
            LOG.error(msg, arguments);
        } else {
            LOG.debug(msg, arguments);
        }
    }

    private static void logWarningOrDebug(InputFile file, String msg, Object ... arguments) {
        if ("css".equals(file.language())) {
            LOG.warn(msg, arguments);
        } else {
            LOG.debug(msg, arguments);
        }
    }

    @Override
    protected void logErrorOrWarn(String msg, Throwable e) {
        if (CssRuleSensor.hasCssFiles(this.context)) {
            LOG.error(msg, e);
        } else {
            LOG.warn(msg);
        }
    }

    @Override
    protected List<InputFile> getInputFiles() {
        FileSystem fileSystem = this.context.getSensorContext().fileSystem();
        FilePredicates p = fileSystem.predicates();
        FilePredicate cssFilePredicate = p.and(p.hasType(InputFile.Type.MAIN), p.or(new FilePredicate[]{p.hasLanguages(new String[]{"css"})}));
        FilePredicate webFilePredicate = p.and(p.hasType(InputFile.Type.MAIN), p.or(new FilePredicate[]{p.hasExtension("htm"), p.hasExtension("html"), p.hasExtension("xhtml")}));
        FilePredicate vueFilePredicate = p.and(new FilePredicate[]{p.hasType(InputFile.Type.MAIN), p.hasExtension("vue"), p.hasLanguages(new String[]{"js", "ts"})});
        return StreamSupport.stream(fileSystem.inputFiles(p.or(new FilePredicate[]{cssFilePredicate, webFilePredicate, vueFilePredicate})).spliterator(), false).toList();
    }

    public static boolean hasCssFiles(JsTsContext<?> context) {
        FileSystem fileSystem = context.getSensorContext().fileSystem();
        FilePredicate mainFilePredicate = fileSystem.predicates().and(fileSystem.predicates().hasType(InputFile.Type.MAIN), fileSystem.predicates().hasLanguages(new String[]{"css"}));
        return fileSystem.inputFiles(mainFilePredicate).iterator().hasNext();
    }

    private static String normalizeMessage(String message) {
        Pattern pattern = Pattern.compile("(.+)\\([a-z\\-/]+\\)");
        Matcher matcher = pattern.matcher(message);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return message;
    }
}

