/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.analysis;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.cpd.NewCpdTokens;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.batch.sensor.symbol.NewSymbol;
import org.sonar.api.batch.sensor.symbol.NewSymbolTable;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.measures.Metric;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.utils.Version;
import org.sonar.plugins.javascript.analysis.JsTsChecks;
import org.sonar.plugins.javascript.analysis.JsTsContext;
import org.sonar.plugins.javascript.analysis.QuickFixSupport;
import org.sonar.plugins.javascript.analysis.cache.CacheAnalysis;
import org.sonar.plugins.javascript.api.Language;
import org.sonar.plugins.javascript.bridge.BridgeServer;
import org.sonarsource.api.sonarlint.SonarLintSide;
import org.sonarsource.sonarlint.plugin.api.SonarLintRuntime;

@ScannerSide
@SonarLintSide
public class AnalysisProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AnalysisProcessor.class);
    private final NoSonarFilter noSonarFilter;
    private final FileLinesContextFactory fileLinesContextFactory;
    private InputFile file;
    private JsTsChecks checks;
    HashSet<String> uniqueParsingErrors;

    public AnalysisProcessor(NoSonarFilter noSonarFilter, FileLinesContextFactory fileLinesContextFactory) {
        this.noSonarFilter = noSonarFilter;
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.uniqueParsingErrors = new HashSet();
    }

    List<BridgeServer.Issue> processResponse(JsTsContext<?> context, JsTsChecks checks, InputFile file, BridgeServer.AnalysisResponse response) {
        this.checks = checks;
        this.file = file;
        if (response.parsingError() != null) {
            this.uniqueParsingErrors.add(file.absolutePath());
            this.processParsingError(context, response.parsingError());
            return new ArrayList<BridgeServer.Issue>();
        }
        List<BridgeServer.Issue> issues = response.issues();
        if ("yaml".equals(file.language()) || "web".equals(file.language())) {
            this.saveIssues(context, issues);
        } else {
            this.saveMetrics(context, response.metrics());
            this.saveIssues(context, issues);
            this.saveHighlights(context, response.highlights());
            this.saveHighlightedSymbols(context, response.highlightedSymbols());
            this.saveCpd(context, response.cpdTokens());
        }
        return issues;
    }

    void processCacheAnalysis(JsTsContext<?> context, InputFile file, CacheAnalysis cacheAnalysis) {
        this.file = file;
        if ("yaml".equals(file.language()) || "web".equals(file.language())) {
            LOG.debug("Skipping processing of the analysis extracted from cache because the javascript plugin doesn't save analysis data of YAML files");
        } else {
            this.saveCpd(context, cacheAnalysis.getCpdTokens());
        }
    }

    private void processParsingError(JsTsContext<?> context, BridgeServer.ParsingError parsingError) {
        Integer line = parsingError.line();
        String message = parsingError.message();
        if (line != null) {
            LOG.warn("Failed to parse file [{}] at line {}: {}", this.file, line, message);
        } else if (parsingError.code() == BridgeServer.ParsingErrorCode.FAILING_TYPESCRIPT) {
            LOG.error("Failed to analyze file [{}] from TypeScript: {}", (Object)this.file, (Object)message);
        } else {
            LOG.error("Failed to analyze file [{}]: {}", (Object)this.file, (Object)message);
            if (context.failFast()) {
                throw new IllegalStateException("Failed to analyze file " + String.valueOf(this.file));
            }
        }
        RuleKey parsingErrorRuleKey = this.checks.parsingErrorRuleKey();
        if (parsingErrorRuleKey != null) {
            NewIssue newIssue = context.getSensorContext().newIssue();
            NewIssueLocation primaryLocation = newIssue.newLocation().message(message).on((InputComponent)this.file);
            if (line != null) {
                primaryLocation.at(this.file.selectLine(line.intValue()));
            }
            newIssue.forRule(parsingErrorRuleKey).at(primaryLocation).save();
        }
        context.getSensorContext().newAnalysisError().onFile(this.file).at(this.file.newPointer(line != null ? line : 1, 0)).message(message).save();
    }

    private void saveIssues(JsTsContext<?> context, List<BridgeServer.Issue> issues) {
        for (BridgeServer.Issue issue : issues) {
            LOG.debug("Saving issue for rule {} on file {} at line {}", issue.ruleId(), this.file, issue.line());
            try {
                this.saveIssue(context, issue);
            }
            catch (RuntimeException e) {
                LOG.warn("Failed to save issue in {} at line {}", (Object)this.file.uri(), (Object)issue.line());
                LOG.warn("Exception cause", e);
            }
        }
    }

    private void saveHighlights(JsTsContext<?> context, List<BridgeServer.Highlight> highlights) {
        NewHighlighting highlighting = context.getSensorContext().newHighlighting().onFile(this.file);
        for (BridgeServer.Highlight highlight : highlights) {
            try {
                highlighting.highlight(highlight.location().toTextRange(this.file), TypeOfText.valueOf((String)highlight.textType()));
            }
            catch (RuntimeException e) {
                LOG.warn("Failed to create highlight in {} at {}", (Object)this.file.uri(), (Object)highlight.location());
                LOG.warn("Exception cause", e);
            }
        }
        try {
            highlighting.save();
        }
        catch (RuntimeException e) {
            LOG.warn("Failed to save highlights in {}.", (Object)this.file.uri());
            LOG.warn("Exception cause", e);
        }
    }

    private void saveHighlightedSymbols(JsTsContext<?> context, List<BridgeServer.HighlightedSymbol> highlightedSymbols) {
        NewSymbolTable symbolTable = context.getSensorContext().newSymbolTable().onFile(this.file);
        for (BridgeServer.HighlightedSymbol highlightedSymbol : highlightedSymbols) {
            NewSymbol newSymbol;
            BridgeServer.Location declaration = highlightedSymbol.declaration();
            try {
                newSymbol = symbolTable.newSymbol(declaration.startLine(), declaration.startCol(), declaration.endLine(), declaration.endCol());
            }
            catch (RuntimeException e) {
                LOG.warn("Failed to create symbol declaration in {} at {}", (Object)this.file.uri(), (Object)declaration);
                continue;
            }
            for (BridgeServer.Location reference : highlightedSymbol.references()) {
                try {
                    newSymbol.newReference(reference.startLine(), reference.startCol(), reference.endLine(), reference.endCol());
                }
                catch (RuntimeException e) {
                    LOG.warn("Failed to create symbol reference in {} at {}", (Object)this.file.uri(), (Object)reference);
                }
            }
        }
        symbolTable.save();
    }

    private void saveMetrics(JsTsContext<?> context, BridgeServer.Metrics metrics) {
        if (this.file.type() == InputFile.Type.TEST || context.isSonarLint()) {
            this.noSonarFilter.noSonarInFile(this.file, Set.copyOf(metrics.nosonarLines()));
            return;
        }
        AnalysisProcessor.saveMetric(context, this.file, CoreMetrics.FUNCTIONS, metrics.functions());
        AnalysisProcessor.saveMetric(context, this.file, CoreMetrics.STATEMENTS, metrics.statements());
        AnalysisProcessor.saveMetric(context, this.file, CoreMetrics.CLASSES, metrics.classes());
        AnalysisProcessor.saveMetric(context, this.file, CoreMetrics.NCLOC, metrics.ncloc().size());
        AnalysisProcessor.saveMetric(context, this.file, CoreMetrics.COMMENT_LINES, metrics.commentLines().size());
        AnalysisProcessor.saveMetric(context, this.file, CoreMetrics.COMPLEXITY, metrics.complexity());
        AnalysisProcessor.saveMetric(context, this.file, CoreMetrics.COGNITIVE_COMPLEXITY, metrics.cognitiveComplexity());
        this.noSonarFilter.noSonarInFile(this.file, Set.copyOf(metrics.nosonarLines()));
        FileLinesContext fileLinesContext = this.fileLinesContextFactory.createFor(this.file);
        for (int line : metrics.ncloc()) {
            fileLinesContext.setIntValue("ncloc_data", line, 1);
        }
        for (int line : metrics.executableLines()) {
            fileLinesContext.setIntValue("executable_lines_data", line, 1);
        }
        fileLinesContext.save();
    }

    private static <T extends Serializable> void saveMetric(JsTsContext<?> context, InputFile file, Metric<T> metric, T value) {
        context.getSensorContext().newMeasure().withValue(value).forMetric(metric).on((InputComponent)file).save();
    }

    private void saveCpd(JsTsContext<?> context, List<BridgeServer.CpdToken> cpdTokens) {
        if (this.file.type().equals((Object)InputFile.Type.TEST) || context.isSonarLint()) {
            return;
        }
        try {
            NewCpdTokens newCpdTokens = context.getSensorContext().newCpdTokens().onFile(this.file);
            for (BridgeServer.CpdToken cpdToken : cpdTokens) {
                newCpdTokens.addToken(cpdToken.location().toTextRange(this.file), cpdToken.image());
            }
            newCpdTokens.save();
        }
        catch (RuntimeException e) {
            LOG.warn("Failed to save CPD token in {}. File will not be analyzed for duplications.", (Object)this.file.uri());
            LOG.warn("Exception cause", e);
        }
    }

    void saveIssue(JsTsContext<?> context, BridgeServer.Issue issue) {
        RuleKey ruleKey;
        NewIssue newIssue = context.getSensorContext().newIssue();
        NewIssueLocation location = newIssue.newLocation().on((InputComponent)this.file);
        if (issue.message() != null) {
            location.message(issue.message());
        }
        if (issue.endLine() != null) {
            location.at(this.file.newRange(issue.line().intValue(), issue.column().intValue(), issue.endLine().intValue(), issue.endColumn().intValue()));
        } else if (issue.line() != 0) {
            location.at(this.file.selectLine(issue.line().intValue()));
        }
        issue.secondaryLocations().forEach(secondary -> {
            NewIssueLocation newIssueLocation = AnalysisProcessor.newSecondaryLocation(this.file, newIssue, secondary);
            if (newIssueLocation != null) {
                newIssue.addLocation(newIssueLocation);
            }
        });
        if (issue.cost() != null) {
            newIssue.gap(issue.cost());
        }
        if (issue.quickFixes() != null && !issue.quickFixes().isEmpty()) {
            if (AnalysisProcessor.isSqQuickFixCompatible(context)) {
                newIssue.setQuickFixAvailable(true);
            }
            if (AnalysisProcessor.isQuickFixCompatible(context)) {
                QuickFixSupport.addQuickFixes(issue, newIssue, this.file);
            }
        }
        if ((ruleKey = this.findRuleKey(issue)) != null) {
            newIssue.at(location).forRule(ruleKey).save();
        }
    }

    private RuleKey findRuleKey(BridgeServer.Issue issue) {
        return this.checks.ruleKeyByEslintKey(issue.ruleId(), Language.of(issue.language()));
    }

    private static boolean isSqQuickFixCompatible(JsTsContext<?> context) {
        return context.isSonarQube() && context.getSensorContext().runtime().getApiVersion().isGreaterThanOrEqual(Version.create((int)9, (int)2));
    }

    private static boolean isQuickFixCompatible(JsTsContext<?> context) {
        return context.isSonarLint() && ((SonarLintRuntime)context.getSensorContext().runtime()).getSonarLintPluginApiVersion().isGreaterThanOrEqual(Version.create((int)6, (int)3));
    }

    private static NewIssueLocation newSecondaryLocation(InputFile inputFile, NewIssue issue, BridgeServer.IssueLocation location) {
        NewIssueLocation newIssueLocation = issue.newLocation().on((InputComponent)inputFile);
        if (location.line() != null && location.endLine() != null && location.column() != null && location.endColumn() != null) {
            newIssueLocation.at(inputFile.newRange(location.line().intValue(), location.column().intValue(), location.endLine().intValue(), location.endColumn().intValue()));
            if (location.message() != null) {
                newIssueLocation.message(location.message());
            }
            return newIssueLocation;
        }
        return null;
    }
}

