/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.analysis;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.plugins.javascript.api.JsAnalysisConsumer;
import org.sonar.plugins.javascript.api.JsFile;
import org.sonarsource.api.sonarlint.SonarLintSide;

@ScannerSide
@SonarLintSide
public class AnalysisConsumers
implements JsAnalysisConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(AnalysisConsumers.class);
    private final List<JsAnalysisConsumer> consumers;

    public AnalysisConsumers() {
        this.consumers = List.of();
        LOG.debug("No registered JsAnalysisConsumer.");
    }

    public AnalysisConsumers(List<JsAnalysisConsumer> consumers) {
        this.consumers = consumers.stream().filter(JsAnalysisConsumer::isEnabled).toList();
        LOG.debug("Enabled JsAnalysisConsumers {}/{}", (Object)this.consumers.size(), (Object)consumers.size());
        LOG.debug("Registered JsAnalysisConsumers {}", (Object)this.consumers);
    }

    @Override
    public void accept(JsFile jsFile) {
        this.consumers.forEach(c -> c.accept(jsFile));
    }

    @Override
    public void doneAnalysis(SensorContext context) {
        this.consumers.forEach(c -> c.doneAnalysis(context));
    }

    @Override
    public boolean isEnabled() {
        return !this.consumers.isEmpty();
    }
}

