/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.analysis;

import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.plugins.javascript.CancellationException;
import org.sonar.plugins.javascript.analysis.JsTsContext;
import org.sonar.plugins.javascript.analysis.cache.CacheStrategies;
import org.sonar.plugins.javascript.api.AnalysisMode;
import org.sonar.plugins.javascript.bridge.BridgeServer;
import org.sonar.plugins.javascript.bridge.BridgeServerConfig;
import org.sonar.plugins.javascript.bridge.ServerAlreadyFailedException;
import org.sonar.plugins.javascript.nodejs.NodeCommandException;

public abstract class AbstractBridgeSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBridgeSensor.class);
    protected final String lang;
    protected final BridgeServer bridgeServer;
    protected JsTsContext<?> context;
    protected BridgeServer.ProjectAnalysisConfiguration configuration;

    protected AbstractBridgeSensor(BridgeServer bridgeServer, String lang) {
        this.bridgeServer = bridgeServer;
        this.lang = lang;
    }

    public void execute(SensorContext sensorContext) {
        CacheStrategies.reset();
        this.context = new JsTsContext<SensorContext>(sensorContext);
        try {
            List<InputFile> inputFiles = this.getInputFiles();
            if (inputFiles.isEmpty()) {
                LOG.info("No input files found for analysis");
                return;
            }
            if (this.context.getSensorContext().isCancelled()) {
                throw new CancellationException("Analysis interrupted because the SensorContext is in cancelled state");
            }
            String msg = this.context.getAnalysisMode() == AnalysisMode.SKIP_UNCHANGED ? "Files which didn't change will only be analyzed for architecture rules, other rules will not be executed" : "Analysis of unchanged files will not be skipped (current analysis requires all files to be analyzed)";
            LOG.debug(msg);
            this.configuration = new BridgeServer.ProjectAnalysisConfiguration(sensorContext.fileSystem().baseDir().getAbsolutePath(), this.context);
            this.bridgeServer.startServerLazily(BridgeServerConfig.fromSensorContext(sensorContext));
            this.analyzeFiles(inputFiles);
        }
        catch (CancellationException e) {
            LOG.info(e.toString());
        }
        catch (ServerAlreadyFailedException e) {
            LOG.debug("Skipping the start of the bridge server as it failed to start during the first analysis or it's not answering anymore");
            LOG.debug("No rules will be executed");
        }
        catch (NodeCommandException e) {
            this.logErrorOrWarn(e.getMessage(), e);
            throw new IllegalStateException("Error while running Node.js. A supported version of Node.js is required for running the analysis of " + this.lang + " files. Please make sure a supported version of Node.js is available in the PATH or an executable path is provided via 'sonar.nodejs.executable' property. Alternatively, you can exclude " + this.lang + " files from your analysis using the 'sonar.exclusions' configuration property. See the docs for configuring the analysis environment: https://docs.sonarsource.com/sonarqube/latest/analyzing-source-code/languages/javascript-typescript-css/", e);
        }
        catch (Exception e) {
            LOG.error("Failure during analysis", e);
            throw new IllegalStateException("Analysis of " + this.lang + " files failed", e);
        }
        finally {
            CacheStrategies.logReport();
        }
    }

    protected void logErrorOrWarn(String msg, Throwable e) {
        LOG.error(msg, e);
    }

    protected abstract void analyzeFiles(List<InputFile> var1) throws IOException;

    protected abstract List<InputFile> getInputFiles();
}

