/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.server.profile.BuiltInQualityProfilesDefinition;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.CheckList;
import org.sonar.plugins.javascript.api.EslintHook;
import org.sonar.plugins.javascript.api.Language;
import org.sonar.plugins.javascript.api.ProfileRegistrar;
import org.sonarsource.analyzer.commons.BuiltInQualityProfileJsonLoader;

public class JavaScriptProfilesDefinition
implements BuiltInQualityProfilesDefinition {
    private static final Logger LOG = LoggerFactory.getLogger(JavaScriptProfilesDefinition.class);
    static final String SONAR_WAY = "Sonar way";
    public static final String RESOURCE_PATH = "org/sonar/l10n/javascript/rules/javascript";
    public static final String SONAR_WAY_JSON = "org/sonar/l10n/javascript/rules/javascript/Sonar_way_profile.json";
    private static final Map<String, String> PROFILES = new HashMap<String, String>();
    static final String SONAR_JASMIN_RULES_CLASS_NAME = "com.sonar.plugins.jasmin.api.JsRules";
    public static final String SECURITY_RULE_KEYS_METHOD_NAME = "getSecurityRuleKeys";
    private static final Map<Language, String> REPO_BY_LANGUAGE;
    private final Map<Language, ArrayList<RuleKey>> additionalRulesByLanguage = new EnumMap<Language, ArrayList<RuleKey>>(Language.class);

    public JavaScriptProfilesDefinition() {
        this(new ProfileRegistrar[0]);
    }

    public JavaScriptProfilesDefinition(ProfileRegistrar[] profileRegistrars) {
        for (ProfileRegistrar profileRegistrar : profileRegistrars) {
            profileRegistrar.register((language, rules) -> {
                ArrayList additionalRules = this.additionalRulesByLanguage.computeIfAbsent(language, it -> new ArrayList());
                additionalRules.addAll(rules);
            });
        }
    }

    public void define(BuiltInQualityProfilesDefinition.Context context) {
        this.createSonarWayProfile("js", context);
        this.createSonarWayProfile("ts", context);
    }

    private void createSonarWayProfile(String language, BuiltInQualityProfilesDefinition.Context context) {
        BuiltInQualityProfilesDefinition.NewBuiltInQualityProfile newProfile = context.createBuiltInQualityProfile(SONAR_WAY, language);
        JavaScriptProfilesDefinition.activateBuiltInRules(newProfile);
        this.activateAdditionalRules(newProfile);
        JavaScriptProfilesDefinition.activateSecurityRules(newProfile, language);
        newProfile.done();
    }

    private static void activateBuiltInRules(BuiltInQualityProfilesDefinition.NewBuiltInQualityProfile profile) {
        Language language = Language.of(profile.language());
        String repositoryKey = REPO_BY_LANGUAGE.get((Object)language);
        String jsonProfilePath = PROFILES.get(profile.name());
        Set<String> activeKeysForBothLanguages = BuiltInQualityProfileJsonLoader.loadActiveKeysFromJsonProfile(jsonProfilePath);
        JavaScriptProfilesDefinition.ruleKeys(CheckList.getChecksForLanguage(language)).stream().filter(activeKeysForBothLanguages::contains).forEach(key -> profile.activateRule(repositoryKey, key));
    }

    void activateAdditionalRules(BuiltInQualityProfilesDefinition.NewBuiltInQualityProfile profile) {
        String language = profile.language();
        ArrayList<RuleKey> rules = this.additionalRulesByLanguage.get((Object)Language.of(language));
        if (rules == null) {
            return;
        }
        rules.forEach(it -> profile.activateRule(it.repository(), it.rule()));
        LOG.debug("Adding extra {} ruleKeys {}", (Object)language, (Object)rules);
    }

    private static void activateSecurityRules(BuiltInQualityProfilesDefinition.NewBuiltInQualityProfile newProfile, String language) {
        Set<RuleKey> sonarJasminRuleKeys = JavaScriptProfilesDefinition.getSecurityRuleKeys(SONAR_JASMIN_RULES_CLASS_NAME, SECURITY_RULE_KEYS_METHOD_NAME, language);
        LOG.debug("Adding security ruleKeys {}", (Object)sonarJasminRuleKeys);
        sonarJasminRuleKeys.forEach(r -> newProfile.activateRule(r.repository(), r.rule()));
    }

    static Set<RuleKey> getSecurityRuleKeys(String className, String ruleKeysMethodName, String language) {
        try {
            Class<?> rulesClass = Class.forName(className);
            Method getRuleKeysMethod = rulesClass.getMethod(ruleKeysMethodName, String.class);
            return (Set)getRuleKeysMethod.invoke(null, language);
        }
        catch (ClassNotFoundException e) {
            LOG.debug("{} is not found, {}", (Object)className, (Object)JavaScriptProfilesDefinition.securityRuleMessage(e));
        }
        catch (NoSuchMethodException e) {
            LOG.debug("Method not found on {}, {}", (Object)className, (Object)JavaScriptProfilesDefinition.securityRuleMessage(e));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOG.debug("{}: {}", (Object)e.getClass().getSimpleName(), (Object)JavaScriptProfilesDefinition.securityRuleMessage(e));
        }
        return Collections.emptySet();
    }

    private static Set<String> ruleKeys(List<Class<? extends EslintHook>> checks) {
        return checks.stream().map(c -> c.getAnnotation(Rule.class).key()).collect(Collectors.toSet());
    }

    private static String securityRuleMessage(Exception e) {
        return "no security rules added to builtin profile: " + e.getMessage();
    }

    static {
        PROFILES.put(SONAR_WAY, SONAR_WAY_JSON);
        REPO_BY_LANGUAGE = new EnumMap<Language, String>(Language.class);
        REPO_BY_LANGUAGE.put(Language.JAVASCRIPT, "javascript");
        REPO_BY_LANGUAGE.put(Language.TYPESCRIPT, "typescript");
    }
}

