/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.Plugin;
import org.sonar.api.PropertyType;
import org.sonar.api.SonarProduct;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.css.CssLanguage;
import org.sonar.css.CssProfileDefinition;
import org.sonar.css.CssRulesDefinition;
import org.sonar.css.StylelintReportSensor;
import org.sonar.css.metrics.CssMetricSensor;
import org.sonar.plugins.javascript.JavaScriptLanguage;
import org.sonar.plugins.javascript.JavaScriptProfilesDefinition;
import org.sonar.plugins.javascript.TypeScriptLanguage;
import org.sonar.plugins.javascript.analysis.AnalysisConsumers;
import org.sonar.plugins.javascript.analysis.AnalysisProcessor;
import org.sonar.plugins.javascript.analysis.CssRuleSensor;
import org.sonar.plugins.javascript.analysis.HtmlSensor;
import org.sonar.plugins.javascript.analysis.JsTsChecks;
import org.sonar.plugins.javascript.analysis.JsTsExclusionsFilter;
import org.sonar.plugins.javascript.analysis.JsTsSensor;
import org.sonar.plugins.javascript.analysis.YamlSensor;
import org.sonar.plugins.javascript.bridge.AnalysisWarningsWrapper;
import org.sonar.plugins.javascript.bridge.BridgeServerImpl;
import org.sonar.plugins.javascript.bridge.BundleImpl;
import org.sonar.plugins.javascript.bridge.EmbeddedNode;
import org.sonar.plugins.javascript.bridge.Environment;
import org.sonar.plugins.javascript.bridge.NodeDeprecationWarning;
import org.sonar.plugins.javascript.bridge.RulesBundles;
import org.sonar.plugins.javascript.external.TslintReportSensor;
import org.sonar.plugins.javascript.lcov.CoverageSensor;
import org.sonar.plugins.javascript.nodejs.NodeCommandBuilderImpl;
import org.sonar.plugins.javascript.nodejs.ProcessWrapperImpl;
import org.sonar.plugins.javascript.rules.EslintRulesDefinition;
import org.sonar.plugins.javascript.rules.JavaScriptRulesDefinition;
import org.sonar.plugins.javascript.rules.TslintRulesDefinition;
import org.sonar.plugins.javascript.rules.TypeScriptRulesDefinition;
import org.sonar.plugins.javascript.sonarlint.FSListenerImpl;

public class JavaScriptPlugin
implements Plugin {
    private static final Logger LOG = LoggerFactory.getLogger(JavaScriptPlugin.class);
    private static final String GENERAL = "General";
    private static final String TEST_AND_COVERAGE = "Tests and Coverage";
    private static final String JS_TS_CATEGORY = "JavaScript / TypeScript";
    private static final String TS_SUB_CATEGORY = "TypeScript";
    private static final String CSS_CATEGORY = "CSS";
    public static final String LCOV_REPORT_PATHS = "sonar.javascript.lcov.reportPaths";
    public static final String LCOV_REPORT_PATHS_ALIAS = "sonar.typescript.lcov.reportPaths";
    public static final String LCOV_REPORT_PATHS_DEFAULT_VALUE = "";
    public static final String ENVIRONMENTS = "sonar.javascript.environments";
    public static final String[] ENVIRONMENTS_DEFAULT_VALUE = new String[]{"amd", "applescript", "atomtest", "browser", "commonjs", "embertest", "greasemonkey", "jasmine", "jest", "jquery", "meteor", "mocha", "mongo", "nashorn", "node", "phantomjs", "prototypejs", "protractor", "qunit", "serviceworker", "shared-node-browser", "shelljs", "webextensions", "worker"};
    public static final String GLOBALS = "sonar.javascript.globals";
    public static final String GLOBALS_DEFAULT_VALUE = "angular,goog,google,OpenLayers,d3,dojo,dojox,dijit,Backbone,moment,casper,_,sap";
    public static final String IGNORE_HEADER_COMMENTS = "sonar.javascript.ignoreHeaderComments";
    public static final Boolean IGNORE_HEADER_COMMENTS_DEFAULT_VALUE = true;
    public static final String JS_EXCLUSIONS_KEY = "sonar.javascript.exclusions";
    public static final String TS_EXCLUSIONS_KEY = "sonar.typescript.exclusions";
    public static final String[] EXCLUSIONS_DEFAULT_VALUE = new String[]{"**/.git/**", "**/node_modules/**", "**/bower_components/**", "**/dist/**", "**/vendor/**", "**/external/**", "**/contrib/**", "**/*.d.ts"};
    public static final String EXTERNAL_ANALYZERS_CATEGORY = "External Analyzers";
    public static final String EXTERNAL_ANALYZERS_SUB_CATEGORY = "JavaScript/TypeScript";
    public static final String ESLINT_REPORT_PATHS = "sonar.eslint.reportPaths";
    public static final String TSLINT_REPORT_PATHS = "sonar.typescript.tslint.reportPaths";
    private static final String FILE_SUFFIXES_DESCRIPTION = "List of suffixes for files to analyze.";
    public static final String PROPERTY_KEY_MAX_FILE_SIZE = "sonar.javascript.maxFileSize";
    public static final long DEFAULT_MAX_FILE_SIZE_KB = 1000L;
    public static final String MAX_FILES_PROPERTY = "sonar.javascript.sonarlint.typechecking.maxfiles";
    public static final int DEFAULT_MAX_FILES_FOR_TYPE_CHECKING = 20000;
    public static final String TSCONFIG_PATHS = "sonar.typescript.tsconfigPaths";
    public static final String TSCONFIG_PATHS_ALIAS = "sonar.typescript.tsconfigPath";
    public static final String SKIP_NODE_PROVISIONING_PROPERTY = "sonar.scanner.skipNodeProvisioning";
    public static final String DETECT_BUNDLES_PROPERTY = "sonar.javascript.detectBundles";
    public static final String NO_FS = "sonar.javascript.canAccessFileSystem";

    public void define(Plugin.Context context) {
        context.addExtensions(AnalysisConsumers.class, JavaScriptLanguage.class, new Object[]{JavaScriptRulesDefinition.class, JavaScriptProfilesDefinition.class, JsTsExclusionsFilter.class, NodeCommandBuilderImpl.class, ProcessWrapperImpl.class, BridgeServerImpl.class, NodeDeprecationWarning.class, BundleImpl.class, JsTsSensor.class, TypeScriptLanguage.class, TypeScriptRulesDefinition.class, RulesBundles.class, JsTsChecks.class, AnalysisWarningsWrapper.class, AnalysisProcessor.class, YamlSensor.class, HtmlSensor.class, EmbeddedNode.class, Environment.class});
        context.addExtensions((Object)PropertyDefinition.builder((String)LCOV_REPORT_PATHS).defaultValue(LCOV_REPORT_PATHS_DEFAULT_VALUE).name("LCOV Files").description("Paths (absolute or relative) to the files with LCOV data.").onConfigScopes(PropertyDefinition.ConfigScope.PROJECT, new PropertyDefinition.ConfigScope[0]).subCategory(TEST_AND_COVERAGE).category(JS_TS_CATEGORY).multiValues(true).build(), (Object)PropertyDefinition.builder((String)"sonar.javascript.file.suffixes").defaultValue(".js,.jsx,.cjs,.mjs,.vue").name("JavaScript File Suffixes").description(FILE_SUFFIXES_DESCRIPTION).subCategory(GENERAL).category(JS_TS_CATEGORY).multiValues(true).onConfigScopes(PropertyDefinition.ConfigScope.PROJECT, new PropertyDefinition.ConfigScope[0]).build(), new Object[]{PropertyDefinition.builder((String)"sonar.typescript.file.suffixes").defaultValue(".ts,.tsx,.cts,.mts").name("TypeScript File Suffixes").description(FILE_SUFFIXES_DESCRIPTION).subCategory(GENERAL).category(JS_TS_CATEGORY).onConfigScopes(PropertyDefinition.ConfigScope.PROJECT, new PropertyDefinition.ConfigScope[0]).multiValues(true).build(), PropertyDefinition.builder((String)TSCONFIG_PATHS).name("TypeScript tsconfig.json location").description("Comma-delimited list of paths to TSConfig files. Wildcards are supported.").onConfigScopes(PropertyDefinition.ConfigScope.PROJECT, new PropertyDefinition.ConfigScope[0]).subCategory(TS_SUB_CATEGORY).category(JS_TS_CATEGORY).multiValues(true).build(), PropertyDefinition.builder((String)PROPERTY_KEY_MAX_FILE_SIZE).name("Maximum size of analyzed files").description("Threshold for the maximum size of analyzed files (in kilobytes). Files that are larger are excluded from the analysis.").onConfigScopes(PropertyDefinition.ConfigScope.PROJECT, new PropertyDefinition.ConfigScope[0]).subCategory(GENERAL).category(JS_TS_CATEGORY).type(PropertyType.INTEGER).defaultValue("1000").build(), PropertyDefinition.builder((String)IGNORE_HEADER_COMMENTS).defaultValue(IGNORE_HEADER_COMMENTS_DEFAULT_VALUE.toString()).name("Ignore header comments").description("True to not count file header comments in comment metrics.").onConfigScopes(PropertyDefinition.ConfigScope.PROJECT, new PropertyDefinition.ConfigScope[0]).subCategory(GENERAL).category(JS_TS_CATEGORY).type(PropertyType.BOOLEAN).build(), PropertyDefinition.builder((String)ENVIRONMENTS).defaultValue(String.join((CharSequence)",", ENVIRONMENTS_DEFAULT_VALUE)).name("JavaScript execution environments").description("List of environments names. The analyzer automatically adds global variables based on that list. Available environment names: " + String.join((CharSequence)", ", ENVIRONMENTS_DEFAULT_VALUE) + ".").onConfigScopes(PropertyDefinition.ConfigScope.PROJECT, new PropertyDefinition.ConfigScope[0]).subCategory(GENERAL).multiValues(true).category(JS_TS_CATEGORY).build(), PropertyDefinition.builder((String)GLOBALS).defaultValue(GLOBALS_DEFAULT_VALUE).name("Global variables").description("List of global variables.").onConfigScopes(PropertyDefinition.ConfigScope.PROJECT, new PropertyDefinition.ConfigScope[0]).subCategory(GENERAL).multiValues(true).category(JS_TS_CATEGORY).build(), PropertyDefinition.builder((String)SKIP_NODE_PROVISIONING_PROPERTY).defaultValue("false").name("Skip the deployment of the embedded Node.js runtime").description(JavaScriptPlugin.getHTMLMarkup("Controls whether the scanner should skip the deployment of the embedded Node.js runtime, and use the host-provided runtime instead.\n\nAnalysis will fail if a compatible version of Node.js is not provided via `sonar.nodejs.executable` or the `PATH`.")).onConfigScopes(PropertyDefinition.ConfigScope.PROJECT, new PropertyDefinition.ConfigScope[0]).subCategory(GENERAL).category(JS_TS_CATEGORY).type(PropertyType.BOOLEAN).build()});
        context.addExtensions(CssLanguage.class, CssProfileDefinition.class, new Object[]{CssRulesDefinition.class, CssRuleSensor.class});
        context.addExtension((Object)PropertyDefinition.builder((String)"sonar.css.file.suffixes").defaultValue(".css,.less,.scss,.sass").name("File Suffixes").description(FILE_SUFFIXES_DESCRIPTION).subCategory(GENERAL).category(CSS_CATEGORY).onConfigScopes(PropertyDefinition.ConfigScope.PROJECT, new PropertyDefinition.ConfigScope[0]).multiValues(true).build());
        if (!context.getRuntime().getProduct().equals((Object)SonarProduct.SONARLINT)) {
            context.addExtensions(CoverageSensor.class, EslintRulesDefinition.class, new Object[]{TslintReportSensor.class, TslintRulesDefinition.class});
            context.addExtension((Object)PropertyDefinition.builder((String)ESLINT_REPORT_PATHS).name("ESLint Report Files").description("Paths (absolute or relative) to the JSON files with ESLint issues.").onConfigScopes(PropertyDefinition.ConfigScope.PROJECT, new PropertyDefinition.ConfigScope[0]).category(EXTERNAL_ANALYZERS_CATEGORY).subCategory(EXTERNAL_ANALYZERS_SUB_CATEGORY).multiValues(true).build());
            context.addExtension((Object)PropertyDefinition.builder((String)TSLINT_REPORT_PATHS).name("TSLint Report Files").description("Paths (absolute or relative) to the JSON files with TSLint issues.").onConfigScopes(PropertyDefinition.ConfigScope.PROJECT, new PropertyDefinition.ConfigScope[0]).category(EXTERNAL_ANALYZERS_CATEGORY).subCategory(EXTERNAL_ANALYZERS_SUB_CATEGORY).multiValues(true).build());
            context.addExtensions(CssMetricSensor.class, StylelintReportSensor.class, new Object[0]);
            context.addExtension((Object)PropertyDefinition.builder((String)"sonar.css.stylelint.reportPaths").defaultValue(LCOV_REPORT_PATHS_DEFAULT_VALUE).name("Stylelint Report Files").description("Paths (absolute or relative) to the JSON files with stylelint issues.").onConfigScopes(PropertyDefinition.ConfigScope.PROJECT, new PropertyDefinition.ConfigScope[0]).category(EXTERNAL_ANALYZERS_CATEGORY).subCategory(CSS_CATEGORY).multiValues(true).build());
        } else {
            SonarLintPluginAPIManager sonarLintPluginAPIManager = new SonarLintPluginAPIManager();
            sonarLintPluginAPIManager.addSonarLintExtensions(context, new SonarLintPluginAPIVersion());
        }
    }

    private static String getHTMLMarkup(String markdownMarkup) {
        return markdownMarkup.replace("\n", "<br>").replaceAll("`(.*?)`", "<code>$1</code>");
    }

    static class SonarLintPluginAPIManager {
        SonarLintPluginAPIManager() {
        }

        public void addSonarLintExtensions(Plugin.Context context, SonarLintPluginAPIVersion sonarLintPluginAPIVersion) {
            if (sonarLintPluginAPIVersion.isDependencyAvailable()) {
                context.addExtension(FSListenerImpl.class);
            } else {
                LOG.debug("Error while trying to inject SonarLint extensions");
            }
        }
    }

    static class SonarLintPluginAPIVersion {
        SonarLintPluginAPIVersion() {
        }

        boolean isDependencyAvailable() {
            try {
                Class.forName("org.sonarsource.sonarlint.plugin.api.module.file.ModuleFileListener");
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            return true;
        }
    }
}

