/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript;

import java.io.IOException;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;

public class JavaScriptFilePredicate {
    private static final String DIRECTIVE_IN_COMMENT = "#.*\\{\\{";
    private static final String DIRECTIVE_IN_SINGLE_QUOTE = "'[^']*\\{\\{[^']*'";
    private static final String DIRECTIVE_IN_DOUBLE_QUOTE = "\"[^\"]*\\{\\{[^\"]*\"";
    private static final String CODEFRESH_VARIABLES = "\\{\\{[\\w\\s]+}}";
    private static final Pattern HELM_DIRECTIVE_IN_COMMENT_OR_STRING = Pattern.compile("(" + String.join((CharSequence)"|", "#.*\\{\\{", "'[^']*\\{\\{[^']*'", "\"[^\"]*\\{\\{[^\"]*\"", "\\{\\{[\\w\\s]+}}") + ")");

    private JavaScriptFilePredicate() {
    }

    public static FilePredicate getYamlPredicate(FileSystem fs) {
        return fs.predicates().and(fs.predicates().hasLanguage("yaml"), inputFile -> {
            try (Scanner scanner = new Scanner(inputFile.inputStream(), inputFile.charset().name());){
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    if (!line.contains("{{") || HELM_DIRECTIVE_IN_COMMENT_OR_STRING.matcher(line).find()) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Unable to read file: %s. %s", inputFile.uri(), e.getMessage()), e);
            }
        });
    }

    public static FilePredicate getJsTsPredicate(FileSystem fs) {
        return fs.predicates().hasLanguages(new String[]{"js", "ts"});
    }
}

