/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.lang.annotation.Annotation;
import java.util.List;
import org.sonar.javascript.checks.AllChecks;
import org.sonar.plugins.javascript.api.EslintHook;
import org.sonar.plugins.javascript.api.JavaScriptRule;
import org.sonar.plugins.javascript.api.Language;
import org.sonar.plugins.javascript.api.TypeScriptRule;

public final class CheckList {
    public static final String JS_REPOSITORY_KEY = "javascript";
    public static final String TS_REPOSITORY_KEY = "typescript";
    public static final String REPOSITORY_NAME = "SonarAnalyzer";

    private CheckList() {
    }

    public static List<Class<? extends EslintHook>> getTypeScriptChecks() {
        return CheckList.filterChecksByAnnotation(TypeScriptRule.class);
    }

    public static List<Class<? extends EslintHook>> getJavaScriptChecks() {
        return CheckList.filterChecksByAnnotation(JavaScriptRule.class);
    }

    public static List<Class<? extends EslintHook>> getChecksForLanguage(Language language) {
        return switch (language) {
            default -> throw new IncompatibleClassChangeError();
            case Language.JAVASCRIPT -> CheckList.getJavaScriptChecks();
            case Language.TYPESCRIPT -> CheckList.getTypeScriptChecks();
        };
    }

    private static List<Class<? extends EslintHook>> filterChecksByAnnotation(Class<? extends Annotation> annotation) {
        List<Class<? extends EslintHook>> allChecks = CheckList.getAllChecks();
        return allChecks.stream().filter(c -> c.isAnnotationPresent(annotation)).toList();
    }

    public static List<Class<? extends EslintHook>> getAllChecks() {
        return AllChecks.rules;
    }
}

