/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.css.rules;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.css.rules.CssRule;
import org.sonar.css.rules.RuleUtils;

@Rule(key="S4670")
public class SelectorTypeNoUnknown
implements CssRule {
    private static final String DEFAULT_IGNORED_TYPES = "/^(mat|md|fa)-/";
    private static final String DEFAULT_IGNORE = "custom-elements";
    @RuleProperty(key="ignoreTypes", description="Comma-separated list of regular expressions for selector types to consider as valid.", defaultValue="/^(mat|md|fa)-/")
    String ignoreTypes = "/^(mat|md|fa)-/";
    @RuleProperty(key="ignore", description="Comma-separated list of ignored elements. The possible values are:\n\"custom-elements\": Allow custom elements (e.g \"x-foo\").\n\"default-namespace\": Allow unknown type selectors if they belong to the default namespace.\n", defaultValue="custom-elements")
    String ignore = "custom-elements";

    @Override
    public String stylelintKey() {
        return "selector-type-no-unknown";
    }

    @Override
    public List<Object> stylelintOptions() {
        return Arrays.asList(true, new StylelintIgnoreOption(RuleUtils.splitAndTrim(this.ignoreTypes), RuleUtils.splitAndTrim(this.ignore)));
    }

    private static class StylelintIgnoreOption {
        private final List<String> ignoreTypes;
        private final List<String> ignore;

        StylelintIgnoreOption(List<String> ignoreTypes, List<String> ignore) {
            this.ignoreTypes = ignoreTypes;
            this.ignore = ignore;
        }
    }
}

